#ifndef __Incl__Zug__
#define __Incl__Zug__

#ifndef STRICT
#define STRICT               // Striktere Typprfungen einschalten
#endif

class Zug
{
  unsigned int QS_ZS,AnzK;
  signed int Wert;
  public:
  Zug() { AnzK = QS_ZS = 0; Wert = -32768; }
  void SetQ(int q)    { QS_ZS = (QS_ZS & 240) | q; }
  void SetZ(int z)    { QS_ZS = (QS_ZS & 15) | (z << 4); }
  void SetAnz(int n)  { AnzK = n; }
  void SetWert(int w) { Wert = w; }
  int GetQ()     { return(QS_ZS & 15); }
  int GetZ()     { return(QS_ZS >> 4); }
  int GetAnz()   { return((int) AnzK); }
  int GetWert()  { return(Wert); }
};

class ZugListe
{
  public:
  Zug* Liste;
  int ZugAnz,Groesse;
  ZugListe() 
  { 
    ZugAnz = 0; 
    Groesse = 8;
    Liste = (Zug*) new Zug[Groesse]; 
  }
  ~ZugListe() { delete[] Liste; }
  void Anfuegen(Zug& z) 
  { 
    // Zuglisten-Array falls noetig vergroessern
    if (ZugAnz >= Groesse)
    { 
      Zug* NeueListe;
      Groesse <<= 1;
      NeueListe = (Zug*) new Zug[Groesse];
      for (int i = 0; i < ZugAnz; i++) NeueListe[i] = Liste[i];
      delete[] Liste;
      Liste = NeueListe;
    }
    Liste[ZugAnz++] = z; 
  }
  void Loeschen() { ZugAnz = 0; }
  void Sortieren();
};


#endif
