/*
 * lpr.c - Windows NT lpr
 *
 * by Eric W. Brown
 *    3 November '92
 */
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <winsock.h>
#include "lp.h"

#define ARGS_LEN 512
#define DEFAULT_INTERVAL 5
#define USERNAME_LEN 64
#define HOSTNAME_LEN 64

int usage()
{
	fprintf(stderr, "Usage: lprm [-Pprinter] [-Sserver] [-] [job# ...]\n");
	exit(1);
	return 0;
} /* usage() */

void main(int argc, char **argv)
{
	int 	sockfd = 0;
	char	*printer = NULL;
	char	*server = NULL;
	char	hostname[HOSTNAME_LEN];
	char	username[USERNAME_LEN];
	char	args[ARGS_LEN + 1] = "";
	int		args_len = 0;
	char	request[ARGS_LEN + 128];
	int		interval = 0;
	char	buf[133];
	int		len;
	
	/*
	 * Get environment variables
	 */
	server = getenv("SERVER");
	printer = getenv("PRINTER");
	if (!printer) 
		printer = DEFAULT_PRINTER;

	len = HOSTNAME_LEN;
	if (!GetComputerName(hostname, &len) || len == 0) {
		fprintf(stderr, "lprm: No hostname, name your computer!!!\n");
		exit(1);
	} /* if */
	
	len = USERNAME_LEN;
	if (!GetUserName(username, &len))
		strncpy(username, hostname, USERNAME_LEN);
	
	/*
	 * Parse command line
	 */
#define NEXT_ARG()  (argc--, argv++, argc ? *argv : (char *)(usage(), NULL))
#define ARG_ARG()   (strlen(*argv) == 2 ? NEXT_ARG() : (*argv) + 2)
	while (argc > 1) {
		NEXT_ARG();
		if ((*argv[0] == '-' || *argv[0] == '/') && strlen(*argv) > 1) {
			switch(argv[0][1]) {
			case 'P':
				printer = ARG_ARG();
				break;
			case 'S':
				server = ARG_ARG();
				break;
			case 'U':	/* Impersonate a user! */
				strncpy(username, ARG_ARG(), USERNAME_LEN);
				break;
			default:
				fprintf(stderr, "lprm: %s: Invalid option\n", *argv);
				usage();
			} /* switch */
		}
		else if (*argv[0] == '-') {
			args_len += strlen(username) + 1;
			if (args_len > ARGS_LEN) {
				fprintf(stderr, "lprm: Command line too long!\n");
				exit(1);
			} /* if */
			strcat(args, " ");
			strcat(args, username);
		}
		else {
			args_len += strlen(*argv) + 1;
			if (args_len > ARGS_LEN) {
				fprintf(stderr, "lprm: Command line too long!\n");
				exit(1);
			} /* if */
			strcat(args, " ");
			strcat(args, *argv);
		} /* else */
	} /* while argc */
		
	
	/*
	 * Do a lookup in the printcap file if necessary
	 */
	if (!server)
		if (!(server = lp_printcap_server_lookup(printer))) {
			fprintf(stderr, "No server, %s, and no printer, %s, in printcap file!\n", 
					server, printer);
			usage();
		} /* if */
	
	
	/*
	 * Initialize tcp
	 */
	if (lp_tcp_startup()) {
		fprintf(stderr, "lprm: Couldn't initalize tcp/ip\n");
		exit(1);
	} /* if */
	
	
	/*
	 * Open socket
	 */
	if ((sockfd = lp_tcp_open(server)) < 0) {
		lp_tcp_shutdown();
		fprintf(stderr, "lprm: Couldn't open connection to %s\n", server);
		exit(1);
	} /* if */
	
	
	/*
	 * Build request
	 */
	sprintf(request, "%c%s %s%s\n", LPD_REMOVE_JOB, printer, username, args);


	/*
	 * Send request
	 */
	if (send(sockfd, request, strlen(request), 0) != (int)strlen(request)) {
		closesocket(sockfd);
		lp_tcp_shutdown();
		fprintf(stderr, "lprm: Error making request\n");
		exit(1);
	} /* if */
	
	
	/*
	 * Print output
	 */
	while(1) {
		memset((void *)buf, 0, 133);
		len = recv(sockfd, buf, 132, 0);
		if (len <= 0)
			break;
		printf("%s", buf);
	} /* while */
	
	/*
	 * Clean up
	 */
	closesocket(sockfd);
	lp_tcp_shutdown();
	exit(0);
} /* main() */


