/***************************************************************************
  Windows Sockets Client Application Support Module

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.  

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/
/*
  MODULE: WS_CHILD.C  (child window functions)
*/

//----------------------
#include "ws_glob.h"
#include "WS_ftp.H"
//----------------------
#include <dos.h>
#include <ctype.h>
//----------------------

#ifdef WIN32
#include <io.h>
#endif

BOOL bCanMKD,bCanRMD,bCanREN,bCanDELE,bIsQVT,bIsNCSA,bIs5000,bIsDual;
BOOL bHELP=FALSE;
int maxhfextent = 0;
int maxhdextent = 0;

// lgk new function to return the width of a text string in a given window
// and if greater than the horiz point reset the horiz extent

void check_scroll(hwnd,txt,var)
HWND hwnd;
char *txt;
int *var;
{
// ok first get the client area to calculate max width
RECT MyRect;
int width = 0;
HDC hdc;
BOOLEAN rv = FALSE;
int tlen = strlen(txt);
SIZE mysize;

   GetClientRect(hwnd, (LPRECT)&MyRect);
   ClientToScreen(hwnd, (LPPOINT)&MyRect.left);
   ClientToScreen(hwnd, (LPPOINT)&MyRect.right);

   // now that we have these values subtract them to get the width
   width = (int)(MyRect.right - MyRect.left);
//   DoPrintf("text is %s len is %d",txt,tlen);
//   DoPrintf("Window Width is %d",width);

   // now get the size of the text
   hdc = GetDC(hwnd);
   rv = GetTextExtentPoint(hdc,(LPCTSTR)txt,tlen,&mysize);
   ReleaseDC(hwnd,hdc);
   if (rv == FALSE)
    DoPrintf("ERROR: get text extent failed ecode = %d",GetLastError());
  else {
//        DoPrintf("Got size for text %s of %d ",txt,(int)mysize.cx);
//        DoPrintf("var for max extent = %d ",*var);
       if (((int)mysize.cx > *var) && ((int)mysize.cx > width))
          {
//           DoPrintf("Resetting horiz extent");
           SendMessage(hwnd,LB_SETHORIZONTALEXTENT,(int)mysize.cx,0l);
           *var = (int)mysize.cx;
          }
  }
}

 // lgk new routine to get local search string

char *localsearchstring()
  {
	   unsigned char szBuf[120];
	   WORD cbText;

	   *(WORD *) szBuf = sizeof(szBuf) -1; // sets the buffer size

	   cbText = (WORD)SendMessage(hLdirBox,
	             EM_GETLINE,(WPARAM)0,(DWORD)(LPSTR)szBuf);
	   szBuf[cbText] = '\0';
	   return szBuf;
  }
 
  /* ---------------------------------------------------*/

  int CreateSubWindows(HWND hParent,HANDLE hInst)
{
  hLbxLDir = CreateWindow(
    "LISTBOX", NULL,
    LBS_STANDARD | WS_VSCROLL | WS_HSCROLL | WS_VISIBLE | WS_CHILD | LBS_EXTENDEDSEL |
    LBS_NOTIFY,
    (7*nWndx)/4,(31*nWndy)/8, (74*nWndx)/4, (50*nWndy)/8,
    hParent, (HMENU)LST_LDIRS, hInst,  NULL);

  hLbxLFiles = CreateWindow(
    "LISTBOX", NULL,
    LBS_STANDARD | WS_VSCROLL | WS_HSCROLL | WS_VISIBLE | WS_CHILD | LBS_EXTENDEDSEL |
    LBS_NOTIFY,
    (7*nWndx)/4,(83*nWndy)/8, (74*nWndx)/4, (70*nWndy)/8,
    hParent, (HMENU)LST_LFILES, hInst,  NULL);

  hLbxRDir = CreateWindow(
    "LISTBOX", NULL,
    LBS_STANDARD | WS_VSCROLL | WS_HSCROLL | WS_VISIBLE | WS_CHILD | LBS_EXTENDEDSEL |
    LBS_NOTIFY,
    (136*nWndx)/4,(31*nWndy)/8, (74*nWndx)/4, (50*nWndy)/8,
    hParent, (HMENU)LST_RDIRS, hInst,  NULL);

  hLbxRFiles = CreateWindow(
    "LISTBOX", NULL,
    LBS_STANDARD | WS_VSCROLL | WS_HSCROLL | WS_VISIBLE | WS_CHILD | LBS_EXTENDEDSEL |
    LBS_NOTIFY,
    (136*nWndx)/4,(83*nWndy)/8, (74*nWndx)/4, (70*nWndy)/8,
    hParent, (HMENU)LST_RFILES, hInst,  NULL);

  hBtnLCWD = CreateWindow(
    "BUTTON", "ChgDir",
    WS_CHILD | WS_VISIBLE,
    (84*nWndx)/4,(32*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_LCHANGE, hInst,  NULL);

  hBtnLMKD = CreateWindow(
    "BUTTON", "MkDir",
    WS_CHILD | WS_VISIBLE,
    (84*nWndx)/4,(46*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_LMKDIR, hInst,  NULL);
  
  hBtnLRMD = CreateWindow(
    "BUTTON", "RmDir",
    WS_CHILD | WS_VISIBLE,
    (84*nWndx)/4,(60*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_LRMDIR, hInst,  NULL);

// lgk new box for directory selection
  hLdirBox = CreateWindow(
    "EDIT", NULL,
     WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER,
    (84*nWndx)/4,(83*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)TXT_LDIRSEL, hInst,  NULL);

  hBtnLDisplay = CreateWindow(
    "BUTTON", "View",
    WS_CHILD | WS_VISIBLE,
    (84*nWndx)/4,(106*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_LDISPLAY, hInst,  NULL);
  hBtnLREN = CreateWindow(
    "BUTTON", "Rename",
    WS_CHILD | WS_VISIBLE,
    (84*nWndx)/4,(120*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_LRENAME, hInst,  NULL);
  hBtnLDEL = CreateWindow(
    "BUTTON", "Delete",
    WS_CHILD | WS_VISIBLE,
    (84*nWndx)/4,(134*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_LDELETE, hInst,  NULL);

  hBtnRCWD = CreateWindow(
    "BUTTON", "ChgDir",
    WS_CHILD | WS_VISIBLE,
    (213*nWndx)/4,(32*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_RCHANGE, hInst,  NULL);
  hBtnRMKD = CreateWindow(
    "BUTTON", "MkDir",
    WS_CHILD | WS_VISIBLE,
    (213*nWndx)/4,(46*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_RMKDIR, hInst,  NULL);
  hBtnRRMD = CreateWindow(
    "BUTTON", "RmDir",
    WS_CHILD | WS_VISIBLE,
    (213*nWndx)/4,(60*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_RRMDIR, hInst,  NULL);
  hRdirBox = CreateWindow(
    "EDIT", NULL,
     WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL | WS_BORDER,
    (213*nWndx)/4,(83*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)TXT_RDIRSEL, hInst,  NULL);
  hBtnRDisplay = CreateWindow(
    "BUTTON", "View",
    WS_CHILD | WS_VISIBLE,
    (213*nWndx)/4,(106*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_RDISPLAY, hInst,  NULL);
  hBtnRREN = CreateWindow(
    "BUTTON", "Rename",
    WS_CHILD | WS_VISIBLE,
    (213*nWndx)/4,(120*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_RRENAME, hInst,  NULL);
  hBtnRDEL = CreateWindow(
    "BUTTON", "Delete",
    WS_CHILD | WS_VISIBLE,
    (213*nWndx)/4,(134*nWndy)/8, (27*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_RDELETE, hInst,  NULL);

  hBtnLtoR = CreateWindow(
    "BUTTON", "-->",
    WS_CHILD | WS_VISIBLE,
    (116*nWndx)/4,(118*nWndy)/8, (14*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_LOCAL_TO_REMOTE, hInst,  NULL);
  hBtnRtoL = CreateWindow(
    "BUTTON", "<--",
    WS_CHILD | WS_VISIBLE,
    (116*nWndx)/4,(101*nWndy)/8, (14*nWndx)/4, (14*nWndy)/8,
    hParent, (HMENU)BTN_REMOTE_TO_LOCAL, hInst,  NULL);

  hBtnConnect = CreateWindow(
    "BUTTON", "Connect",
    WS_CHILD | WS_VISIBLE,
    (4*nWndx)/4,(188*nWndy)/8, (34*nWndx)/4, (10*nWndy)/8,
    hParent, (HMENU)BTN_CONNECT, hInst,  NULL);
  hBtnClose = CreateWindow(
    "BUTTON", "Close",
    WS_CHILD | WS_VISIBLE,
    (38*nWndx)/4,(188*nWndy)/8, (34*nWndx)/4, (10*nWndy)/8,
    hParent, (HMENU)BTN_CLOSE, hInst,  NULL);
 
 // lgk move this button over and add new abort button
  hBtnAbort = CreateWindow(
   "BUTTON", "Abort",
    WS_CHILD | WS_VISIBLE,
    (72*nWndx)/4,(188*nWndy)/8, (34*nWndx)/4, (10*nWndy)/8,
    hParent, (HMENU)BTN_ABORT, hInst,  NULL);

  hBtnLong = CreateWindow(
    "BUTTON", "LongDir",
    WS_CHILD | WS_VISIBLE,
    (106*nWndx)/4,(188*nWndy)/8, (34*nWndx)/4, (10*nWndy)/8,
    hParent, (HMENU)BTN_LONG, hInst,  NULL);

  hBtnOption= CreateWindow(
    "BUTTON", "Options",
    WS_CHILD | WS_VISIBLE,
    (140*nWndx)/4,(188*nWndy)/8, (34*nWndx)/4, (10*nWndy)/8,
    hParent, (HMENU)BTN_OPTION, hInst, NULL);
  hBtnAbout = CreateWindow(
    "BUTTON", "About",
    WS_CHILD | WS_VISIBLE,
    (174*nWndx)/4,(188*nWndy)/8, (34*nWndx)/4, (10*nWndy)/8,
    hParent, (HMENU)BTN_ABOUT, hInst,  NULL);
  hBtnExit = CreateWindow(
    "BUTTON", "Exit",
    WS_CHILD | WS_VISIBLE,
    (208*nWndx)/4,(188*nWndy)/8, (34*nWndx)/4, (10*nWndy)/8,
    hParent, (HMENU)BTN_EXIT, hInst,  NULL);

  hTxtLDir = CreateWindow(
    "STATIC", NULL,
    WS_CHILD | WS_VISIBLE | SS_LEFTNOWORDWRAP,
    (9*nWndx)/4,(18*nWndy)/8, (100*nWndx)/4, (8*nWndy)/8,
    hParent, (HMENU)TXT_LDIRECTORY, hInst,  NULL);
/*
  hTxtRHost = CreateWindow(
    "STATIC", NULL,
    WS_CHILD | WS_VISIBLE | SS_LEFTNOWORDWRAP,
    (138*nWndx)/4,(7*nWndy)/8, (100*nWndx)/4, (8*nWndy)/8,
    hParent, TXT_HOSTNAME, hInst,  NULL);
*/
  hTxtRDir = CreateWindow(
    "STATIC", NULL,
    WS_CHILD | WS_VISIBLE | SS_LEFTNOWORDWRAP,
    (138*nWndx)/4,(18*nWndy)/8, (100*nWndx)/4, (8*nWndy)/8,
    hParent, (HMENU)TXT_RDIRECTORY, hInst,  NULL);

  hTxtStatus = CreateWindow(
    "STATIC", NULL,
    WS_CHILD | WS_VISIBLE | SS_LEFT,
    (10*nWndx)/4,(167*nWndy)/8, (218*nWndx)/4, (8*nWndy)/8,
    hParent, (HMENU)TXT_STATUS, hInst,  NULL);

  hTxtStatus1 = CreateWindow(
    "STATIC", NULL,
    WS_CHILD | WS_VISIBLE | SS_LEFT,
    (10*nWndx)/4,(175*nWndy)/8, (218*nWndx)/4, (8*nWndy)/8,
    hParent, (HMENU)TXT_STATUS, hInst,  NULL);

  hTxtLBytes = CreateWindow(
    "STATIC", NULL,
    WS_CHILD | WS_VISIBLE | SS_RIGHT,
    (10*nWndx)/4,(155*nWndy)/8, (40*nWndx)/4, (8*nWndy)/8,
    hParent, (HMENU)TXT_STATUS, hInst,  NULL);

  hTxtRBytes = CreateWindow(
    "STATIC", NULL,
    WS_CHILD | WS_VISIBLE | SS_RIGHT,
    (198*nWndx)/4,(155*nWndy)/8, (40*nWndx)/4, (8*nWndy)/8,
    hParent, (HMENU)TXT_STATUS, hInst,  NULL);

  hRBascii=CreateWindow(
    "BUTTON", "ASCII",
    WS_CHILD | WS_VISIBLE | BS_RADIOBUTTON,
    (58*nWndx)/4,(155*nWndy)/8,(39*nWndx)/4,(10*nWndy)/8,
    hParent, (HMENU)RB_ASCII, hInst, NULL);
  hRBbinary=CreateWindow(
    "BUTTON","Binary",
    WS_CHILD | WS_VISIBLE | BS_RADIOBUTTON,
    (103*nWndx)/4,(155*nWndy)/8,(39*nWndx)/4,(10*nWndy)/8,
    hParent, (HMENU)RB_BINARY, hInst, NULL);
  hRBl8=CreateWindow(
    "BUTTON","L 8",
    WS_CHILD | WS_VISIBLE | BS_RADIOBUTTON,
    (148*nWndx)/4,(155*nWndy)/8,(39*nWndx)/4,(10*nWndy)/8,
    hParent, (HMENU)RB_L8, hInst, NULL);

  hScroll=CreateWindow(
    "SCROLLBAR",NULL,WS_CHILD | WS_VISIBLE |SBS_VERT, // SBS_LEFTALIGN
    (228*nWndx)/4,(167*nWndy)/8,(10*nWndx)/4,(16*nWndy)/8,
    hParent, (HMENU)SCRLWND, hInst,NULL);

 EnableWindow(hBtnAbort,FALSE);
 EnableWindow(hBtnConnect,TRUE);
 EnableWindow(hBtnClose,FALSE);

  return(TRUE);
}


HPEN hPenDark;
HPEN hPenLight;

void BoxIt(HDC hDC,int left,int top,int width,int height,BOOL flag)
{
  if(flag) SelectObject(hDC,hPenDark); else SelectObject(hDC,hPenLight);
  MoveToEx(hDC,(left*nWndx)/4,((top+height)*nWndy)/8,NULL);
  LineTo(hDC,(left*nWndx)/4,(top*nWndy)/8);
  LineTo(hDC,((left+width)*nWndx)/4,(top*nWndy)/8);
  if(flag) SelectObject(hDC,hPenLight); else SelectObject(hDC,hPenDark);
  LineTo(hDC,((left+width)*nWndx)/4,((top+height)*nWndy)/8);
  LineTo(hDC,(left*nWndx)/4,((top+height)*nWndy)/8);
}

void DoMainPaint(HWND hWnd)
{
  HDC         hDC;   // handle for the display device
  PAINTSTRUCT ps;    // holds PAINT information
  HBRUSH      hBrush;

  memset(&ps, 0x00, sizeof(PAINTSTRUCT));
  hDC = BeginPaint(hWnd, &ps);

  hBrush=CreateSolidBrush(RGB(192,192,192));
  hPenDark=CreatePen(PS_SOLID,1,RGB(128,128,128));
  hPenLight=CreatePen(PS_SOLID,1,RGB(224,224,224));
//
  SelectObject(hDC,hBrush);
  SelectObject(hDC,GetStockObject(ANSI_VAR_FONT));
  SetBkColor(hDC,RGB(192,192,192));
//
  BoxIt(hDC,4,2,109,149,TRUE);
  BoxIt(hDC,133,2,109,149,TRUE);
//
  BoxIt(hDC,7,5,103,10,TRUE);
  TextOut(hDC,(9*nWndx)/4,(7*nWndy)/8,"Local PC info",13);
  BoxIt(hDC,136,5,103,10,TRUE);
  TextOut(hDC,(138*nWndx)/4,(7*nWndy)/8,"Remote host info",16);
//              5     27
  BoxIt(hDC,4,154,238,31,TRUE);  // file transfer types
//              9     1
  BoxIt(hDC,7,166,232,18,FALSE); // status text box
  BoxIt(hDC,7,17,103,10,FALSE);
  BoxIt(hDC,136,17,103,10,FALSE);
// Inform Windows painting is complete
  EndPaint(hWnd, &ps);
  DeleteObject(hBrush);
  DeleteObject(hPenLight);
  DeleteObject(hPenDark);
}

int GetLocalDirForWnd(HWND hWnd)
{
  char *searchstring = localsearchstring();
  char tempstring[120];
  
#ifdef WIN32 
  struct _finddata_t ffblk;
  #define findnext(a) _findnext(a)
  #define ff_name name
  #define ff_attrib attrib
#else
  unsigned int nIndex;
#ifdef _MSC_
  #define ff_attrib attrib
  #define ff_name name
  #define findnext(a) _dos_findnext(a)
  struct _find_t ffblk;
#else
  struct ffblk ffblk;
#endif  
#endif
  int nDone;
  long fhandle;

   maxhdextent = 0;
   maxhfextent = 0;  
   strcpy(tempstring,searchstring);

  // get the local directory name
  // DLG_LDIRECTORY (directory name)
  getcwd(szString,180);
  SendMessage(hTxtLDir,WM_SETTEXT,0,(LPARAM)szString);
  // DLG_LDIRS      (directory list box)
  SendMessage(hLbxLDir,LB_RESETCONTENT,0,0);
  // default is 5 chars for dirve names
  SendMessage(hLbxLDir,LB_SETHORIZONTALEXTENT,5*9,0l);
  fhandle =_findfirst("*.*",&ffblk);
  
  if (fhandle != -1)
   nDone = 0;
  else nDone = 1;

  // first go through all dirs
  while (!nDone)  {
    if(ffblk.attrib & 0x10 && strcmp(ffblk.name,".")!=0)
      {
       SendMessage(hLbxLDir,LB_ADDSTRING,0,(LONG)ffblk.name);
       check_scroll(hLbxLDir,(LONG)ffblk.name,&maxhdextent);
      }

    nDone = _findnext(fhandle,&ffblk);
  }
  _findclose(fhandle);

  // add drives to the list box
  SendMessage(hLbxLDir, LB_DIR,0x4000 | 0x8000, (LPARAM) ((LPSTR) "*"));

  // DLG_LFILES     (file list box)
   // lgk do not change this as it is adding drives
   // lgk 7/94 new code for horiz scroll bars
  SendMessage(hLbxLFiles,LB_RESETCONTENT,0,0);
  SendMessage(hLbxLFiles,LB_SETHORIZONTALEXTENT,0,0l);
 // lgk new code here to use search string if filled in
 if (strlen(tempstring) == 0)
  fhandle =_findfirst("*.*",&ffblk);
 else fhandle =_findfirst(tempstring,&ffblk);

 if (fhandle != -1)
   nDone = 0;
  else nDone = 1;

 while (!nDone)  {
    if(!(ffblk.attrib & 0x10)) {
      strcpy(szString,ffblk.name);

      // lgk 10/94 comment out code here if on nt that is changing stuff
      // to lower case which causes problem when going to unix
#ifndef WIN32      
      for(nIndex=0;nIndex<strlen(szString);nIndex++)
        szString[nIndex]=tolower(szString[nIndex]);
#endif
      SendMessage(hLbxLFiles,LB_ADDSTRING,0,(LONG)szString);
    // lgk 7/94 new code for horiz scroll bars
     check_scroll(hLbxLFiles,(LONG)szString,&maxhfextent);
    }
    nDone = _findnext(fhandle,&ffblk);
  }
  _findclose(fhandle);
  SendMessage(hLdirBox,EM_SETMODIFY,0,0);
  return 0;
}

#define MAXLINES 59
char statuslines[60][81];
int statusptr=0;
int statusscroll=1;

void ScrollStatus(int value) {
  statusscroll += value;
  if(statusscroll<1)
    statusscroll=1;
  else if(statusscroll>statusptr)
    statusscroll=statusptr;
  else {
    SetWindowText(hTxtStatus1,statuslines[statusscroll]);
    SetWindowText(hTxtStatus,statuslines[statusscroll-1]);
  }

}

void SetStatus(LPSTR string) {
  int i;

  if(statusptr>(MAXLINES-1))
    for(i=0;i<MAXLINES;i++)
      strcpy(statuslines[i],statuslines[i+1]);

  strncpy(statuslines[statusptr],string,80);
  statuslines[statusptr][80]=0;

  SetWindowText(hTxtStatus1,statuslines[statusptr]);
  if(statusptr>0)
    SetWindowText(hTxtStatus,statuslines[statusptr-1]);
  statusscroll=statusptr;
  if(statusptr<MAXLINES) statusptr++;
}
