/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater;

import com.sun.tools.tzupdater.CompatibilityKeeper;
import com.sun.tools.tzupdater.DataConfiguration;
import com.sun.tools.tzupdater.Logger;
import com.sun.tools.tzupdater.Messages;
import com.sun.tools.tzupdater.TzRuntimeException;
import com.sun.tools.tzupdater.TzupdaterException;
import com.sun.tools.tzupdater.Utils;
import com.sun.tools.tzupdater.Verifier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TimezoneUpdater {
    private static final String ZIP_SUFFIX = ".zip";
    private static final String COMPAT_SUFFIX = ".compat";
    private static final String TEST_SUFFIX = ".test";
    private static final int BUFSIZE = 8192;
    private final String vendor = System.getProperty("java.vendor");
    private final String jreVersion = System.getProperty("java.version");
    private final String javaHome = System.getProperty("java.home");
    private boolean helpOnly;
    private boolean showVersionOnly;
    private boolean verificationOnly;
    private boolean performUpdate;
    private boolean forceUpdate;
    private boolean keepCompatibility;

    public TimezoneUpdater(String[] stringArray, PrintStream printStream) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-h") || string.equals("--help")) {
                this.helpOnly = true;
                return;
            }
            if (string.equals("-V") || string.equals("--version")) {
                this.showVersionOnly = true;
                bl = true;
                continue;
            }
            if (string.equals("-t") || string.equals("--test")) {
                this.verificationOnly = true;
                continue;
            }
            if (string.equals("-u") || string.equals("--update")) {
                this.performUpdate = true;
                continue;
            }
            if (string.equals("-f") || string.equals("--force")) {
                this.performUpdate = true;
                this.forceUpdate = true;
                continue;
            }
            if (string.equals("-bc") || string.startsWith("--backwardcompat")) {
                this.keepCompatibility = true;
                continue;
            }
            if (string.equals("-v") || string.equals("--verbose")) {
                bl = true;
                continue;
            }
            System.out.println(Messages.printf("unknown.flag", string));
            System.out.println(Messages.printf("usage"));
            throw new TzRuntimeException();
        }
        if (this.verificationOnly) {
            this.forceUpdate = false;
        }
        if (this.performUpdate) {
            if (this.showVersionOnly || this.verificationOnly) {
                this.helpOnly = true;
            }
        } else if (this.keepCompatibility && !this.verificationOnly || !this.showVersionOnly && !this.verificationOnly) {
            this.helpOnly = true;
        }
        Logger.init(bl, printStream);
    }

    public void run() throws IOException {
        if (this.helpOnly) {
            System.out.println(Messages.printf("usage"));
            return;
        }
        String string = Utils.toZiDirName(this.javaHome);
        if (string == null) {
            throw new TzRuntimeException(Messages.printf("no.zi"));
        }
        String string2 = Utils.getTzID(string);
        if (!this.showVersionOnly) {
            Logger.println(Messages.printf("java.home", this.javaHome));
            Logger.println(Messages.printf("java.vendor", this.vendor));
            Logger.println(Messages.printf("java.version", this.jreVersion));
        } else {
            Logger.println("tzupdater version 1.0.0-b03");
        }
        DataConfiguration dataConfiguration = DataConfiguration.getDataConfiguration(this.vendor, this.jreVersion);
        Logger.println(Messages.printf("jre.tzdata.version", string2));
        if (dataConfiguration == null) {
            throw new TzRuntimeException(Messages.printf("no.tzdata", this.vendor, this.jreVersion));
        }
        Logger.println(Messages.printf("tool.tzdata.version", dataConfiguration.getTzID()));
        if (this.showVersionOnly) {
            return;
        }
        if (this.verificationOnly) {
            this.verify(dataConfiguration);
            return;
        }
        this.update(string, string2, dataConfiguration);
        Logger.println(Messages.printf("state.complete"));
    }

    private void update(String string, String string2, DataConfiguration dataConfiguration) throws IOException {
        Object object;
        File file;
        File file2;
        String string3 = dataConfiguration.getTzID();
        if (!this.forceUpdate) {
            int n = string2.compareTo(string3);
            if (n == 0) {
                throw new TzRuntimeException(Messages.printf("tzdata.version.same"));
            }
            if (n > 0) {
                throw new TzRuntimeException(Messages.printf("tzdata.version.later"));
            }
        }
        if (!(file2 = (file = new File(string)).getParentFile()).canWrite()) {
            throw new TzRuntimeException(Messages.printf("not.writable", file2.getAbsolutePath()));
        }
        File file3 = TimezoneUpdater.getUniqueFile(string, string3);
        String string4 = dataConfiguration.getArchiveName();
        if (!this.verificationOnly) {
            try {
                this.extract(file3, string4 + ZIP_SUFFIX);
            }
            catch (IOException iOException) {
                this.remove(file3);
                throw iOException;
            }
        }
        List list = null;
        if (this.keepCompatibility && (object = CompatibilityKeeper.forID(string4 + COMPAT_SUFFIX)) != null) {
            Logger.print(Messages.printf("state.compat"));
            ((CompatibilityKeeper)object).keepCompatible(file3);
            list = ((CompatibilityKeeper)object).getExcludeList();
            Logger.println(Messages.printf("state.done"));
        }
        Logger.print(Messages.printf("state.renaming"));
        object = TimezoneUpdater.getUniqueFile(string, string2);
        if (!file.renameTo((File)object)) {
            this.remove(file3);
            Logger.println(Messages.printf("state.failed"));
            throw new TzRuntimeException(Messages.printf("error.cannot.rename", file, object));
        }
        if (!file3.renameTo(file)) {
            Logger.println(Messages.printf("state.failed"));
            Logger.error(Messages.printf("error.cannot.rename", file3, file));
            Logger.print(Messages.printf("state.restoring"));
            if (((File)object).renameTo(file)) {
                this.remove(file3);
                Logger.print(Messages.printf("state.done"));
            } else {
                Logger.println();
                Logger.error(Messages.printf("error.cannot.restore", file));
            }
            throw new TzRuntimeException();
        }
        Logger.println(Messages.printf("state.done"));
        Logger.print(Messages.printf("state.validating.new"));
        if (!Verifier.run(string4 + TEST_SUFFIX, list)) {
            Logger.println(Messages.printf("state.failed"));
            Logger.error(Messages.printf("state.validation.failed"));
            Logger.print(Messages.printf("state.restoring"));
            if (file.renameTo(file3)) {
                this.remove(file3);
                if (((File)object).renameTo(file)) {
                    Logger.println(Messages.printf("state.done"));
                } else {
                    Logger.error(Messages.printf("error.cannot.restore", file));
                }
            } else {
                Logger.error(Messages.printf("error.cannot.rename", file, file3));
            }
            throw new TzRuntimeException();
        }
        Logger.println(Messages.printf("state.done"));
    }

    private void extract(File file, String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new TzupdaterException(string + " not fount");
        }
        this.extract(file, inputStream);
    }

    private void extract(File file, InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        Logger.print(Messages.printf("state.extracting"));
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>(64);
        byte[] byArray = new byte[8192];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            object2 = new File(file, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (!((File)object2).mkdirs()) {
                    Logger.println(Messages.printf("state.failed"));
                    throw new IOException(Messages.printf("error.cannot.mkdir", object2));
                }
                arrayList.add(zipEntry);
            } else {
                try {
                    object = new FileOutputStream((File)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.println(Messages.printf("state.failed"));
                    throw fileNotFoundException;
                }
                this.copy(zipInputStream, (OutputStream)object, zipEntry.getSize(), byArray);
                ((OutputStream)object).close();
                ((File)object2).setLastModified(zipEntry.getTime());
            }
            zipInputStream.closeEntry();
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            zipEntry = (ZipEntry)object2.next();
            object = new File(file, zipEntry.getName());
            ((File)object).setLastModified(zipEntry.getTime());
        }
        zipInputStream.close();
        Logger.println(Messages.printf("state.done"));
    }

    private void verify(DataConfiguration dataConfiguration) throws IOException {
        CompatibilityKeeper compatibilityKeeper;
        String string = dataConfiguration.getArchiveName();
        List list = null;
        if (this.keepCompatibility && (compatibilityKeeper = CompatibilityKeeper.forID(string + COMPAT_SUFFIX)) != null) {
            compatibilityKeeper.keepCompatible(null);
            list = compatibilityKeeper.getExcludeList();
        }
        Logger.println(Messages.printf("state.validating"));
        if (!Verifier.run(string + TEST_SUFFIX, list)) {
            Logger.println();
            throw new TzRuntimeException(Messages.printf("state.validation.failed"));
        }
        Logger.println(Messages.printf("state.validation.complete"));
    }

    private void copy(InputStream inputStream, OutputStream outputStream, long l, byte[] byArray) throws IOException {
        int n;
        while (l > 0L && (n = inputStream.read(byArray, 0, Math.min((int)l, byArray.length))) > 0) {
            outputStream.write(byArray, 0, n);
            l -= (long)n;
        }
    }

    private void remove(File file) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.remove(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    private static File getUniqueFile(String string, String string2) {
        File file = new File(string + "_" + string2);
        if (file.exists()) {
            int n = 1;
            while ((file = new File(string + "_" + string2 + "_" + n++)).exists()) {
            }
        }
        return file;
    }

    public static void main(String[] stringArray) {
        try {
            TimezoneUpdater timezoneUpdater = new TimezoneUpdater(stringArray, null);
            timezoneUpdater.run();
            return;
        }
        catch (TzupdaterException tzupdaterException) {
            throw tzupdaterException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null) {
                Logger.error(string);
            }
            System.exit(1);
            return;
        }
    }
}

