//////////////////////////////////////////////////////////////////////////////////
// Project Name:   [ CDD Class Library - CDD.lib ]
// Source File:    [ CDXStarField Implementation ]
// Author:         [ Bil Simser - bsimser@home.com ]
// Revision:       [ 1.99a ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"
#include <time.h>

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXStarField::CDXStarField(CDXScreen *pScreen)
{
	m_Screen = pScreen;
	m_NumStars = 200;
	m_StarVelocity = 2;
	m_Top = 0;
	m_Left = 0;
	m_Width = m_Screen->GetWidth();
	m_Right = m_Width;
	m_Height = m_Screen->GetHeight();
	m_Bottom = m_Height;
	m_CenterX = m_Width / 2;
	m_CenterY = m_Height / 2;
	m_StarMode = THREED;
	m_Towards = TRUE;
	m_Colored = TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXStarField::~CDXStarField()
{
}

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField Create
//////////////////////////////////////////////////////////////////////////////////
void CDXStarField::Create()
{
	CreateStars();
	CalcPosition();
}

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField Update
//////////////////////////////////////////////////////////////////////////////////
void CDXStarField::Update(BOOL bErase)
{
	if(bErase)
		ClearStars();
	CalcPosition();
}

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField CreateStars
//////////////////////////////////////////////////////////////////////////////////
void CDXStarField::CreateStars()
{
	srand((unsigned)time(NULL));
	for(int i=0; i<m_NumStars; i++)
	{
		switch(m_StarMode)
		{
		case THREED:
			m_Stars[i].m_X = rand()%m_Width - m_Width / 2;
			m_Stars[i].m_Y = rand()%m_Height - m_Height / 2;
			m_Stars[i].m_Z = rand()%255;
			m_Stars[i].m_Color = rand()%255;
			break;

		case HORIZONTAL:
			m_Stars[i].m_X = rand()%m_Width;
			m_Stars[i].m_Y = rand()%(m_Bottom-m_Top) + m_Top;
			m_Stars[i].m_Z = rand()%255;
			if(!m_Colored)
			{
				if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
					m_Stars[i].m_Color = 244;
				else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
					m_Stars[i].m_Color = 243;
				else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
					m_Stars[i].m_Color = 242;
				else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
					m_Stars[i].m_Color = 241;
				else
					m_Stars[i].m_Color = 240;
			}
			else
				m_Stars[i].m_Color = 255;
			break;

		case VERTICAL:
			m_Stars[i].m_X = rand()%(m_Right - m_Left) + m_Left;
			m_Stars[i].m_Y = rand()%m_Height;
			m_Stars[i].m_Z = rand()%255;
			if(!m_Colored)
			{
				if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
					m_Stars[i].m_Color = 244;
				else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
					m_Stars[i].m_Color = 243;
				else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
					m_Stars[i].m_Color = 242;
				else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
					m_Stars[i].m_Color = 241;
				else
					m_Stars[i].m_Color = 240;
			}
			else
				m_Stars[i].m_Color = 255;
			break;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField CalcPosition
//////////////////////////////////////////////////////////////////////////////////
void CDXStarField::CalcPosition()
{
	int newx, newy;

	m_Screen->m_lpDDSBack->Lock();

	for(int i=0; i<m_NumStars; i++)
	{
		switch(m_StarMode)
		{
		case THREED:
			if((m_Stars[i].m_Z > 0) && (m_Stars[i].m_Z < 256))
			{
				newx = ((m_Stars[i].m_X << 7) / m_Stars[i].m_Z) + m_CenterX;
				newy = ((m_Stars[i].m_Y << 7) / m_Stars[i].m_Z) + m_CenterY;
				if((newx > m_Left) && (newx < m_Right) && 
					(newy > m_Top) && (newy < m_Bottom))
				{
					if(!m_Colored)
					{
						if(m_Flashing)
							m_Stars[i].m_Color = rand()%255;
						else
						{
							if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
								m_Stars[i].m_Color = 244;
							else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
								m_Stars[i].m_Color = 243;
							else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
								m_Stars[i].m_Color = 242;
							else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
								m_Stars[i].m_Color = 241;
							else
								m_Stars[i].m_Color = 240;
						}
					}
					m_Screen->m_lpDDSBack->PutPixel(newx, newy, m_Stars[i].m_Color);
					m_Stars[i].m_OldX = newx;
					m_Stars[i].m_OldY = newy;
					if(m_Towards)
						m_Stars[i].m_Z -= m_StarVelocity;
					else
						m_Stars[i].m_Z += m_StarVelocity;
				}
				else
				{
					m_Stars[i].m_X = rand()%m_Width - m_Width / 2;
					m_Stars[i].m_Y = rand()%m_Height - m_Height / 2;
					m_Stars[i].m_Color = rand()%255;
					if(m_Towards)
						m_Stars[i].m_Z = 255;
					else
						m_Stars[i].m_Z = rand()%255;
				}
			}
			else
			{
				m_Stars[i].m_X = rand()%m_Width - m_Width / 2;
				m_Stars[i].m_Y = rand()%m_Height - m_Height / 2;
				m_Stars[i].m_Color = rand()%255;
				if(m_Towards)
					m_Stars[i].m_Z = 255;
				else
					m_Stars[i].m_Z = rand()%255;
			}
			break;

		case HORIZONTAL:
			if(m_Flashing && !m_Colored)
				m_Stars[i].m_Color = rand()%255;
			if(m_Towards)
			{
				if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
					m_Stars[i].m_X -= 4 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
					m_Stars[i].m_X -= 3 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
					m_Stars[i].m_X -= 2 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
					m_Stars[i].m_X -= 1 + m_StarVelocity;
				else
					m_Stars[i].m_X -= m_StarVelocity;

				if(m_Stars[i].m_X < m_Left)
				{
					m_Stars[i].m_X = m_Right + rand()%50;
					m_Stars[i].m_Y = rand()%(m_Bottom - m_Top) + m_Top;
					m_Stars[i].m_Z = rand()%255;
					if(!m_Colored)
					{
						if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
							m_Stars[i].m_Color = 244;
						else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
							m_Stars[i].m_Color = 243;
						else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
							m_Stars[i].m_Color = 242;
						else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
							m_Stars[i].m_Color = 241;
						else
							m_Stars[i].m_Color = 240;
					}
					else
						m_Stars[i].m_Color = rand()%255;
				}
			}
			else
			{
				if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
					m_Stars[i].m_X += 4 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
					m_Stars[i].m_X += 3 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
					m_Stars[i].m_X += 2 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
					m_Stars[i].m_X += 1 + m_StarVelocity;
				else
					m_Stars[i].m_X += m_StarVelocity;

				if(m_Stars[i].m_X > m_Right)
				{
					m_Stars[i].m_X = m_Left - rand()%50;
					m_Stars[i].m_Y = rand()%(m_Bottom - m_Top) + m_Top;
					m_Stars[i].m_Z = rand()%255;
					if(!m_Colored)
					{
						if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
							m_Stars[i].m_Color = 244;
						else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
							m_Stars[i].m_Color = 243;
						else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
							m_Stars[i].m_Color = 242;
						else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
							m_Stars[i].m_Color = 241;
						else
							m_Stars[i].m_Color = 240;
					}
					else
						m_Stars[i].m_Color = rand()%255;
				}
			}

			if((m_Stars[i].m_X > m_Left) && (m_Stars[i].m_X < m_Right) && 
				(m_Stars[i].m_Y > m_Top) && (m_Stars[i].m_Y < m_Bottom))
			{
				m_Screen->m_lpDDSBack->PutPixel(m_Stars[i].m_X, m_Stars[i].m_Y, m_Stars[i].m_Color);
			}
			break;

		case VERTICAL:
			if(m_Flashing && !m_Colored)
				m_Stars[i].m_Color = rand()%255;
			if(m_Towards)
			{
				if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
					m_Stars[i].m_Y -= 4 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
					m_Stars[i].m_Y -= 3 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
					m_Stars[i].m_Y -= 2 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
					m_Stars[i].m_Y -= 1 + m_StarVelocity;
				else
					m_Stars[i].m_Y -= m_StarVelocity;

				if(m_Stars[i].m_Y < m_Top)
				{
					m_Stars[i].m_X = rand()%(m_Left - m_Right) + m_Left;
					m_Stars[i].m_Y = m_Bottom + rand()%20;
					m_Stars[i].m_Z = rand()%255;
					if(!m_Colored)
					{
						if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
							m_Stars[i].m_Color = 244;
						else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
							m_Stars[i].m_Color = 243;
						else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
							m_Stars[i].m_Color = 242;
						else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
							m_Stars[i].m_Color = 241;
						else
							m_Stars[i].m_Color = 240;
					}
					else
						m_Stars[i].m_Color = rand()%255;
				}
			}
			else
			{
				if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
					m_Stars[i].m_Y += 4 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
					m_Stars[i].m_Y += 3 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
					m_Stars[i].m_Y += 2 + m_StarVelocity;
				else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
					m_Stars[i].m_Y += 1 + m_StarVelocity;
				else
					m_Stars[i].m_Y += m_StarVelocity;

				if(m_Stars[i].m_Y > m_Bottom)
				{
					m_Stars[i].m_X = rand()%(m_Right - m_Left) + m_Left;
					m_Stars[i].m_Y = m_Top - rand()%20;
					m_Stars[i].m_Z = rand()%255;
					if(!m_Colored)
					{
						if(m_Stars[i].m_Z >= 0 && m_Stars[i].m_Z < 50)
							m_Stars[i].m_Color = 244;
						else if(m_Stars[i].m_Z >= 50 && m_Stars[i].m_Z < 100)
							m_Stars[i].m_Color = 243;
						else if(m_Stars[i].m_Z >= 100 && m_Stars[i].m_Z < 150)
							m_Stars[i].m_Color = 242;
						else if(m_Stars[i].m_Z >= 150 && m_Stars[i].m_Z < 200)
							m_Stars[i].m_Color = 241;
						else
							m_Stars[i].m_Color = 240;
					}
					else
						m_Stars[i].m_Color = rand()%255;
				}
			}

			if((m_Stars[i].m_X > m_Left) && (m_Stars[i].m_X < m_Right) && 
				(m_Stars[i].m_Y > m_Top) && (m_Stars[i].m_Y < m_Bottom))
			{
				m_Screen->m_lpDDSBack->PutPixel(m_Stars[i].m_X, m_Stars[i].m_Y, m_Stars[i].m_Color);
			}
			break;
		}
	}

	m_Screen->m_lpDDSBack->UnLock();
}

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField ClearStars
//////////////////////////////////////////////////////////////////////////////////
void CDXStarField::ClearStars()
{
	m_Screen->m_lpDDSBack->Fill(0);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXStarField SetNumberofStars
//////////////////////////////////////////////////////////////////////////////////
void CDXStarField::SetNumberofStars(int iStars)
{
	if(iStars != m_NumStars)
	{
		m_NumStars = iStars;
		if(m_NumStars > MAXSTARS)
			m_NumStars = MAXSTARS;
		if(m_NumStars < 0)
			m_NumStars = 0;
	}
}
