# $Id: Makefile,v 5.20 1992/07/28 16:12:44 eggert Exp $
# Copyright (C) 1982, 1988, 1989 Walter Tichy
# Copyright 1990, 1991, 1992 by Paul Eggert
#   Distributed under license by the Free Software Foundation, Inc.
#
# This file is part of RCS.
#
# RCS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# RCS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with RCS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Report problems and direct all questions to:
#
#    rcs-bugs@cs.purdue.edu
#

# default target
default : all

# See README for more information on the configuration section.
# ----- start of configuration section -----
# nmake makefile definitions for MS-DOS and OS/2 (Microsoft C or Quick C)

#	$Id: nmake.mkh,v 1.8 1992/07/28 16:12:44 eggert Exp $

BINDIR = ..\bin

CC = cl -nologo
BIND = bind -nologo
BINDN = -n DOSLOADMODULE DOSGETPROCADDR DOSFREEMODULE

!IF "$(OS)" == "os2"
CC_286 = -G2
CC_D = -D__OS2__=1
LDLIBS = ms\rcs.def -Lp -link $(LDFLAGS)
LINK = cl -nologo
!ELSE
CC_286 =
CC_D = -D__MSDOS__=1 -Dbad_creat0=1 -Dbad_chmod_close=1
LDLIBS =
LINK = link /nologo $(LDFLAGS) $(OTHER_OBJECT)
!ENDIF

!IF "$(DEBUG)" == "Y"
CC_DEBUG = -Zi -Od
LD_DEBUG = /CO
!ELSE
CC_DEBUG = -Gs -Ocegit
LD_DEBUG =
!ENDIF

!IF "$(EM)" == "Y"
CC_EM = -EM
!ENDIF

!IF "$(QUICK)" == "Y"
CC_QC = -qc
!ENDIF

CC_MODEL = S

CFLAGS = -A$(CC_MODEL) $(CC_286) -Ims -D__MSC__=1 $(CC_D) $(CC_DEBUG) $(CC_EM) $(CC_QC) -Zp

INSTALL = copy

LDFLAGS = $(LD_DEBUG)/ST:16384/NOE

# You may have to change the following line; there's no standard.
LIB = \msvc\lib\$(s)

LOGIN_FLAGS =

OTHER_OBJECT = getcwdsl.obj login$(OS).obj spawnvpq.obj $(LIB)setargv.obj

REMOVE = -del

# makefile definitions for MS-DOS and OS/2

#	$Id: ms.mkh,v 1.7 1992/07/28 16:12:44 eggert Exp $

# empty string to avoid makefile misparsing of \ at line end with buggy makes
s =

TESTPREFIX = ms\$(s)

o = .obj
x = .exe

conf.h : ms\conf.h
	copy ms\conf.h .
	echo /* */ >> $@

login$(OS)$(o) : ms\login$(OS).c
	$(CC) $(CFLAGS) $(LOGIN_FLAGS) -c ms\login$(OS).c

dirent$(o) : ms\dirent.c
	$(CC) $(CFLAGS) -c ms\dirent.c

getcwdsl$(o) : ms\getcwdsl.c
	$(CC) $(CFLAGS) -c ms\getcwdsl.c

spawnvpq$(o) : ms\spawnvpq.c
	$(CC) $(CFLAGS) -c ms\spawnvpq.c

utime$(o) : ms\utime.c
	$(CC) $(CFLAGS) $(LOGIN_FLAGS) -c ms\utime.c

# On non-Unix hosts you must manually create and edit conf.h from conf.heg.

# ----- end of configuration section -----
# You shouldn't have to change anything past this point.


# Avoid brain damage in some versions of 'make'.
SHELL = /bin/sh

# all commands
RCSCOMMANDS = ci$(x) co$(x) ident$(x) merge$(x) \
	rcs$(x) rcsclean$(x) rcsdiff$(x) rcsmerge$(x) rlog$(x)

all : $(RCSCOMMANDS)

install : all
	$(INSTALL) ci$(x) $(DESTBINDIR)
	$(INSTALL) co$(x) $(DESTBINDIR)
	$(INSTALL) ident$(x) $(DESTBINDIR)
	$(INSTALL) merge$(x) $(DESTBINDIR)
	$(INSTALL) rcs$(x) $(DESTBINDIR)
	$(INSTALL) rcsclean$(x) $(DESTBINDIR)
	$(INSTALL) rcsdiff$(x) $(DESTBINDIR)
	$(INSTALL) rcsmerge$(x) $(DESTBINDIR)
	$(INSTALL) rlog$(x) $(DESTBINDIR)

# Install RCS and (if applicable) GNU diff before running these tests.
# To test RCS before installing it, see README.
RCSTEST = PATH=$(BINDIR):$(DIFFPREFIX).:$$PATH sh $(TESTPREFIX)rcstest
installtest :
	$(RCSTEST)
installdebug :
	$(RCSTEST) -v

clean :
	$(REMOVE) a.* *$(o) conf.h conf.err $(RCSCOMMANDS) rcsvers.c


rcsvers.c : ../Version
	( \
		echo '#include "rcsbase.h"' && \
		echo 'char const RCS_version_string[] = "'"`cat $?`"'";' \
	) >$@

ci = ci$(o) rcslex$(o) rcssyn$(o) rcsgen$(o) rcsedit$(o) rcskeys$(o) rcsmap$(o) \
	rcsrev$(o) rcsutil$(o) rcsvers$(o) rcsfnms$(o) partime$(o) maketime$(o) rcskeep$(o) \
	rcsfcmp$(o) $(OTHER_OBJECT)
ci$(x) : $(ci)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

co = co$(o) rcslex$(o) rcssyn$(o) rcsgen$(o) rcsedit$(o) rcskeys$(o) rcsmap$(o) \
	rcsrev$(o) rcsutil$(o) rcsvers$(o) rcsfnms$(o) partime$(o) maketime$(o) rcskeep$(o) \
	$(OTHER_OBJECT)
co$(x) : $(co)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

ident = ident$(o) rcsmap$(o) $(OTHER_OBJECT)
ident$(x) : $(ident)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

merge = merge$(o) merger$(o) rcsfnms$(o) rcslex$(o) \
	rcsmap$(o) rcsrev$(o) rcssyn$(o) rcsutil$(o) rcsvers$(o) \
	rcskeep$(o) rcskeys$(o) $(OTHER_OBJECT)
merge$(x) : $(merge)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

rlog = rlog$(o) rcslex$(o) rcsmap$(o) rcssyn$(o) rcsrev$(o) rcsutil$(o) rcsvers$(o) \
	partime$(o) maketime$(o) rcsfnms$(o) rcskeep$(o) rcskeys$(o) $(OTHER_OBJECT)
rlog$(x) : $(rlog)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

rcs = rcs$(o) rcslex$(o) rcssyn$(o) rcsrev$(o) rcsutil$(o) rcsvers$(o) rcsgen$(o) \
	rcsedit$(o) rcskeys$(o) rcsmap$(o) rcsfnms$(o) rcskeep$(o) $(OTHER_OBJECT)
rcs$(x) : $(rcs)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

rcsclean = rcsclean$(o) rcsedit$(o) rcsfcmp$(o) rcsfnms$(o) rcsgen$(o) rcskeys$(o) dirent$(o) \
	rcslex$(o) rcsmap$(o) rcsrev$(o) rcssyn$(o) rcsutil$(o) rcsvers$(o) rcskeep$(o) \
	$(OTHER_OBJECT)
rcsclean$(x) : $(rcsclean)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

rcsdiff = rcsdiff$(o) rcsutil$(o) rcsvers$(o) rcsfnms$(o) rcsmap$(o) rcsrev$(o) rcssyn$(o) \
	rcslex$(o) maketime$(o) partime$(o) rcskeep$(o) rcskeys$(o) $(OTHER_OBJECT)
rcsdiff$(x) : $(rcsdiff)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

rcsmerge = rcsmerge$(o) merger$(o) rcsutil$(o) rcsvers$(o) rcsfnms$(o) rcsmap$(o) rcsrev$(o) \
	rcssyn$(o) rcslex$(o) rcskeep$(o) rcskeys$(o) $(OTHER_OBJECT)
rcsmerge$(x) : $(rcsmerge)
!IF "$(OS)" == "os2"
	$(LINK) $($@) $(LDLIBS)
	$(BIND) $@ $(BINDN)
!ELSE
	$(LINK) @ms\$*.rsp,$*,,$(LDLIBS);
!ENDIF

SOURCE=	ci.c co.c ident.c maketime.c merge.c merger.c partime.c rcs.c \
	rcsclean.c rcsdiff.c rcsedit.c rcsfcmp.c rcsfnms.c rcsgen.c \
	rcskeep.c rcskeys.c rcslex.c rcsmap.c rcsmerge.c rcsrev.c rcssyn.c \
	rcsutil.c rlog.c rcsvers.c
OBJECT=	ci$(o) co$(o) ident$(o) maketime$(o) merge$(o) merger$(o) partime$(o) rcs$(o) \
	rcsclean$(o) rcsdiff$(o) rcsedit$(o) rcsfcmp$(o) rcsfnms$(o) rcsgen$(o) \
	rcskeep$(o) rcskeys$(o) rcslex$(o) rcsmap$(o) rcsmerge$(o) rcsrev$(o) rcssyn$(o) \
	rcsutil$(o) rlog$(o) rcsvers$(o)

lint : conf.h
	$(LINT) $(CC_D) -DRCS_lint=1 $(SOURCE)

conf_h = conf.h
$(OBJECT) : $(conf_h) rcsbase.h
