/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994
                      Callback Example

    FILE:       callp.c

    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application

    FUNCTIONS:  Fibonacci() -

    COMMENTS:   This sample program generates a Fibonacci number by
                static callback.
   
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>    
#include "call.h"    // header file generated by MIDL compiler

short Fibonacci(short n)
{
    short nsub1, nsub2;

    printf("Fibonacci() called with value %d\n", n);
    if ((n == 0) || (n == 1))
        return(1);
    else {
        nsub1 = n - 1;
        nsub2 = n - 2;
        return(Fibonacci2(nsub1) + Fibonacci2(nsub2));
    }
}

void Shutdown(void)
{
    RPC_STATUS status;

    printf("calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }
    
    printf("calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end file callp.c */
