/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994
                         Cluuid Example

    FILE:       cluuidp.c

    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application

    FUNCTIONS:  HelloProc() - prints "hello, world" or other string
                HelloProc2() - prints string backwards

    COMMENTS:   This sample program demonstrates how to supply
                multiple implementations of the remote procedure
                specified in the interface. It also demonstrates
                how the client selects among the implementations
                by providing a client object uuid.

                The server calls RpcObjectSetType to associate a
                client object uuid with the object uuid in the
                Object Registry Table. The server initializes a
                manager entry point vector (manager epv) and
                then calls RpcRegisterIf to associate the interface
                uuid and the object uuid with the manager epv in the
                Interface Registry Table.

                When the client makes a remote procedure call,
                the client object uuid is mapped to the object uuid
                in the Object Registry Table. The resulting
                object uuid and the interface uuid are mapped to
                a manager entry point vector in the Interface
                Registry Table.

                By default, in this example, the server registers
                two implementations of the "hello, world" function
                HelloProc and HelloProc2.  The HelloProc2
                implementation is associated with the object uuid
                "11111111-1111-1111-1111-111111111111". When
                the client makes a procedure call with a null
                uuid, the client's request is mapped to the
                original HelloProc.  When the client makes a
                procedure call with the client object uuid
                "11111111-1111-1111-1111-11111111111", the
                client's request is mapped to HelloProc2 (which
                prints the string in reverse).

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "cluuid.h"    // header file generated by MIDL compiler

void HelloProc(unsigned char * pszString)
{
    printf("%s\n", pszString);
}

void HelloProc2(unsigned char * pszString)
{
    printf("%s\n", strrev(pszString));
}

void Shutdown(void)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end of file cluuidp.c */
