/* Copyright (C) 2000 MySQL AB & MySQL Finland AB & TCX DataKonsult AB
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* This code is generated by gen_lex_hash.cc that seeks for a perfect
hash function */

#include "lex.h"

static uint16 char_table[] = {
153,24,105,199,48,135,95,57,251,203,31,42,45,143,243,36,
201,169,88,159,184,47,64,154,10,142,118,189,96,84,79,166,
236,34,138,82,13,60,50,254,72,106,41,177,108,100,5,164,
90,215,214,7,170,61,131,97,187,182,225,228,246,30,116,55,
122,18,156,98,181,9,1,4,99,70,171,239,52,232,202,125,
210,75,26,128,80,56,207,137,237,191,168,134,85,140,94,113,
28,18,156,98,181,9,1,4,99,70,171,239,52,232,202,125,
210,75,26,128,80,56,207,137,237,191,168,197,114,196,198,238,
124,258,241,86,66,208,83,3,49,221,62,67,27,77,219,51,
174,87,93,253,223,178,211,165,163,218,109,209,242,8,233,200,
183,152,222,92,185,132,146,17,78,180,73,53,145,91,58,220,
255,12,21,148,136,63,216,110,71,133,46,252,102,235,151,192,
229,68,23,69,65,123,245,195,188,158,81,16,15,130,234,212,
29,155,162,157,205,161,6,190,240,74,38,120,43,76,217,186,
230,39,121,206,150,149,54,175,89,14,117,107,248,35,176,115,
101,227,20,112,111,32,103,139,204,19,173,167,44,160,25,172
};


static uchar unique_length[] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,3,1,2,0,
0,5,5,13,9,7,6,6,6,7,1,4,5,12,5,7,
8,3,12,10,6,7,4,5,0,5,1,0,0,0,0,0,
0,5,5,13,9,7,6,6,6,7,1,4,5,12,5,7,
8,3,12,10,6,7,4,5,0,5,1,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};


static uint16 my_function_table[] = {
32767,32767,32767,204,32767,32767,32767,32767,5,193,32767,32767,
4,32767,32767,32767,32767,32767,32767,260,32767,32767,32767,32767,
32767,32767,32767,32767,0,32767,32767,32767,32767,32767,32767,32767,
32767,399,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,243,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,178,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,285,32767,6,293,
32767,288,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,38,32767,32767,32767,32767,74,32767,32767,32767,
32767,32767,66,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,284,32767,32767,138,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,359,32767,32767,32767,57,32767,
32767,32767,32767,244,32767,32767,32767,386,32767,32767,32767,32767,
32767,32767,92,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,60,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,292,32767,32767,32767,32767,32767,32767,32767,316,32767,
32767,32767,67,32767,32767,32767,32767,32767,1,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,337,32767,21,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,216,32767,32767,
32767,200,32767,32767,32767,32767,32767,32767,32767,32767,32767,100,
32767,104,32767,32767,32767,32767,32767,249,32767,32767,32767,32767,
32767,32767,32767,32767,32767,144,32767,32767,32767,32767,32767,32767,
80,32767,32767,32767,32767,51,32767,228,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,143,32767,
32767,32767,305,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,146,32767,32767,32767,32767,32767,32767,
163,32767,32767,32767,32767,177,32767,32767,32767,32767,32767,32767,
64,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,327,32767,32767,32767,32767,32767,
180,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,218,32767,32767,395,32767,32767,32767,32767,32767,32767,
32767,182,32767,32767,32767,392,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,123,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,70,32767,32767,396,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,355,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,126,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,278,32767,32767,157,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,27,32767,32767,32767,32767,32767,32767,32767,320,32767,32767,
32767,32767,351,32767,220,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,354,32767,32767,28,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,304,
32767,32767,32767,46,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,222,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,179,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
272,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,239,
32767,32767,32767,32767,32767,35,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,368,32767,174,32767,32767,
32767,32767,32767,32767,32767,55,32767,207,246,32767,32767,32767,
32767,32767,32767,32767,32767,371,32767,290,32767,32767,32767,45,
378,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
37,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,289,32767,32767,114,
32767,32767,32767,32767,32767,116,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,360,32767,32767,
32767,32767,32767,32767,32767,115,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,277,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,348,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,117,32767,32767,32767,186,32767,394,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,53,
32767,32767,122,32767,32767,32767,32767,298,32767,32767,32767,32767,
32767,77,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,43,192,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
112,32767,32767,32767,296,32767,32767,389,234,32767,32767,32767,
32767,32767,32767,291,32767,32767,32767,32767,325,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,295,275,32767,
32767,32767,32767,86,311,181,32767,269,32767,32767,332,32767,
32767,297,342,32767,32767,32767,363,32767,32767,32767,32767,32767,
32767,32767,32767,281,32767,32767,32767,276,32767,321,202,32767,
32767,32767,32767,32767,32767,273,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,286,32767,267,32767,307,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,274,32767,32767,
32767,32767,32767,32767,32767,32767,369,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,308,32767,32767,32767,
32767,32767,196,32767,32767,18,32767,32767,32767,32767,32767,197,
384,32767,83,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,121,32767,
32767,32767,32767,32767,32767,328,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,364,32767,32767,319,32767,199,32767,32767,254,
32767,32767,32767,32767,72,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,103,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,229,32767,345,32767,32767,265,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,253,32767,135,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,353,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,75,32767,56,398,32767,32767,32767,32767,32767,
32767,32767,149,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,166,198,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,85,32767,32767,32767,32767,258,120,
32767,32767,32767,32767,32767,32767,99,32767,303,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,381,32767,32767,
32767,32767,32767,32767,32767,162,32767,357,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,136,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,142,214,32767,32767,32767,32767,
32767,32767,32767,32767,32767,54,79,32767,211,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,233,32767,32767,
32767,32767,32767,32767,32767,32767,25,32767,13,32767,127,32767,
235,32767,32767,32767,32767,32767,32767,32767,32767,24,376,32767,
32767,32767,32767,32767,32767,32767,32767,209,32767,32767,29,32767,
32767,32767,32767,32767,32767,32767,32767,32767,370,32767,32767,375,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,334,326,141,32767,32767,32767,32767,341,373,32767,32767,
400,32767,32767,32767,32767,32767,32767,106,32767,397,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,23,32767,32767,
32767,32767,32767,32767,32767,406,22,32767,31,32767,32767,32767,
32767,32767,352,32767,212,32767,81,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,306,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,301,32767,68,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,152,32767,32767,203,32767,
32767,32767,32767,32767,32767,26,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,171,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
227,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,65,32767,32767,32767,32767,32767,32767,32767,32767,32767,
58,32767,32767,32767,32767,32767,367,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,187,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,238,32767,32767,282,32767,32767,32767,32767,32767,
32767,32767,32767,32767,206,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,165,32767,32767,32767,
362,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,124,
32767,347,32767,32767,32767,309,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,302,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,48,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
223,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
270,40,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,390,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,263,32767,32767,32767,32767,32767,32767,241,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,237,32767,32767,32767,32767,32767,160,32767,
32767,32767,32767,184,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,391,32767,32767,32767,32767,338,32767,32767,32767,232,
32767,32767,310,32767,349,32767,236,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,313,32767,32767,261,32767,
32767,366,32767,32767,32767,32767,32767,32767,330,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,159,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,213,32767,32767,129,130,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,294,32767,32767,32767,32767,383,
32767,32767,32767,32767,32767,32767,32767,32767,133,32767,32767,32767,
32767,32767,32767,139,33,32767,32767,140,32767,32767,32767,32767,
32767,132,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,231,404,32767,32767,32767,32767,32767,32767,39,32767,32767,
78,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,331,
2,32767,32767,32767,61,32767,32767,32767,32767,32767,134,32767,
32767,32767,172,32767,15,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,374,32767,32767,32767,118,32767,32767,
32767,32767,32767,32767,32,32767,32767,32767,32767,201,32767,32767,
32767,32767,32767,32767,32767,335,32767,32767,32767,32767,32767,32767,
10,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,3,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,195,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,84,32767,
245,32767,32767,32767,32767,32767,32767,32767,131,32767,97,339,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,17,32767,145,32767,32767,259,32767,20,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,194,32767,32767,
210,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
8,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,89,32767,32767,32767,156,32767,32767,32767,32767,32767,41,
32767,32767,32767,169,32767,32767,32767,32767,32767,168,224,32767,
32767,32767,108,32767,32767,32767,401,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,324,32767,101,32767,32767,32767,264,
32767,32767,323,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,379,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,365,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,125,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
191,32767,32767,32767,32767,287,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,87,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,242,32767,
32767,32767,32767,32767,32767,315,32767,32767,32767,32767,32767,32767,
32767,32767,32767,343,32767,32767,32767,32767,32767,32767,32767,32767,
32767,344,32767,32767,32767,32767,32767,32767,32767,32767,19,32767,
32767,387,32767,32767,32767,402,32767,32767,32767,32767,32767,32767,
155,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
42,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,82,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,176,32767,32767,32767,110,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,251,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,107,32767,32767,32767,32767,32767,346,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,12,32767,32767,
32767,32767,32767,32767,32767,32767,62,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,188,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,94,
32767,32767,32767,32767,32767,32767,71,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,175,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,44,32767,32767,32767,32767,52,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
47,32767,32767,380,32767,32767,32767,32767,32767,252,7,32767,
32767,14,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,102,
32767,167,32767,32767,32767,32767,32767,50,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,137,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,9,219,32767,32767,32767,32767,32767,32767,
32767,32767,32767,279,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,314,151,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,109,32767,32767,32767,221,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,225,32767,164,266,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,73,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
170,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,173,95,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,250,32767,32767,96,32767,32767,32767,32767,
32767,32767,32767,32767,32767,11,32767,147,32767,128,32767,32767,
32767,32767,32767,333,32767,32767,32767,32767,32767,32767,32767,32767,
32767,158,32767,76,32767,32767,32767,32767,385,32767,32767,32767,
403,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,161,32767,153,32767,32767,32767,32767,32767,32767,
268,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,329,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,154,32767,32767,
32767,32767,32767,63,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,350,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,372,312,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,356,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,377,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,105,32767,32767,32767,226,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,88,32767,32767,
32767,32767,255,32767,32767,32767,32767,256,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,408,32767,32767,32767,32767,32767,
32767,32767,32767,32767,230,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,405,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,340,32767,32767,32767,32767,
98,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,150,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,283,32767,
32767,32767,32767,190,32767,32767,32767,32767,32767,32767,32767,32767,
32767,91,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
148,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
59,32767,32767,32767,32767,32767,32767,32767,240,32767,32767,32767,
32767,36,32767,32767,32767,32767,32767,32767,32767,32767,32767,248,
32767,32767,32767,32767,32767,32767,32767,32767,382,32767,32767,32767,
32767,32767,32767,32767,113,32767,32767,32767,32767,32767,32767,32767,
32767,32767,336,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,208,280,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,16,32767,32767,
32767,32767,32767,93,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,388,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,185,32767,32767,32767,34,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,358,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,393,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,189,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,247,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,262,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
217,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,183,32767,32767,32767,32767,32767,32767,
32767,32767,407,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,90,32767,30,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,69,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,205,49,32767,32767,32767,32767,32767,32767,32767,299,32767,
32767,32767,32767,32767,32767,32767,32767,257,32767,32767,32767,32767,
317,32767,32767,32767,32767,32767,32767,32767,32767,322,32767,32767,
111,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,300,32767,32767,32767,215,32767,32767,32767,
32767,32767,32767,32767,318,361,32767,32767,32767,32767,32767,32767,
32767,32767,32767,32767,32767,32767,32767,32767,32767,32767,119,32767,
32767,271,32767,32767,32767,32767,32767
};


/* start_value=2610463L;  best_t1=8358376L;  best_t2=860646L;  best_type=2; */ /* mode=4111  add=8 type: 0 */

inline SYMBOL *get_hash_symbol(const char *s,unsigned int length,bool function)
{
  ulong idx = 2610463+char_table[(uchar) *s];
  SYMBOL *sim;
  const char *start=s;
  int i=unique_length[(uchar) *s++];
  if (i > (int) length) i=(int) length;
  while (--i > 0)
    idx= (idx ^ (char_table[(uchar) *s++] + (idx << 8)));
  idx=my_function_table[(idx & 8388607) % 4111];
  if (idx >= 286)
  {
    if (!function || idx >= 32767) return (SYMBOL*) 0;
    sim=sql_functions + (idx - 286);
  }
  else
    sim=symbols + idx;
  if ((length != sim->length) || lex_casecmp(start,sim->name,length))
    return  (SYMBOL *)0;
  return sim;
}
