/*
 *  This file contains some simple routines to simplify Tcl programming.
 *
 *  To just use the procedures, source misc.tcl.  To pick up the macros, do an
 *  #include <misc.tpp>
 */
#ifndef _MISC_TCL_
#define _MISC_TCL_


/*
 *  isEmpty
 *
 *  Returns a boolean value representing whether or not the given string is
 *  empty.
 */

#define IsEmpty(str) 0 == [string compare str {}]
#ifndef NO_PROCS
proc isEmpty {testString} {
    return [expr {IsEmpty($testString)}]
}
#endif


/*
 *  isntEmpty
 *
 *  Returns a boolean value representing whether or not the given string is
 *  empty.
 */

#define IsntEmpty(str) [string compare str {}]
#ifndef NO_PROCS
proc isntEmpty {testString} {
    return IsntEmpty($testString)
}
#endif


/*
 *  libFile
 *
 *  Returns a string consisting of the complete pathname of the given file in
 *  the default library directory.
 */

#define LibFile(flnm) [system path -absolute [info library] flnm]
#ifndef NO_PROCS
proc libFile {fileName} {
    return LibFile($fileName)
}
#endif


/*
 *  localFile
 *
 *  Returns a string consisting of the complete pathname of the given file
 *  name in the same directory as the executing script.
 */

#define LocalFile(flnm) [system path [file dirname [info script]] flnm]
#ifndef NO_PROCS
proc localFile {fileName} {
    return LocalFile($fileName)
}
#endif
#endif  /*  _MISC_TCL_  */
