/*
 *  $Id: stateMachine.tpp,v 1.1 1993/12/07 22:03:37 Barlow Exp $
 *
 *********************************************************************************
 *                                                                               *
 *                               Copyright  1992                                *
 *                         Digital Equipment Corporation                         *
 *                             All Rights Reserved.                              *
 *                                                                               *
 *  Unpublished rights reserved under the copyright laws of the United States.   *
 *  The software contained on this media is proprietary to and embodies the      *
 *  confidential technology of Digital Equipment Corporation.  Possession, use,  *
 *  duplication or dissemination of the software and media is authorized only    *
 *  pursuant to a valid written license from Digital Equipment Corporation.      *
 *                                                                               *
 *  RESTRICTED RIGHTS LEGEND:  Use, duplication, or disclosure by the U.S.       *
 *  Government is subject to restrictions as set forth in Subparagraph           *
 *  (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.        *
 *                                                                               *
 *********************************************************************************
 *
 *
 *  Facility:
 *
 *      General
 *
 *
 *  Abstract:
 *
 *      This file implements a generic state machine class.
 *
 *
 *  Author:
 *
 *      Doug Barlow
 *
 *
 *  Date:
 *
 *      7-OCT-1992
 *
 *
 *  Revision History:
 *
 *      $Log: stateMachine.tpp,v $
# Revision 1.1  1993/12/07  22:03:37  Barlow
# Initial revision
#
# Revision 1.1  1993/12/03  01:04:25  Barlow
# Initial revision
#
# Revision 1.1  1993/12/01  20:36:55  Barlow
# Initial revision
#
 *
 */

/*
 *  Compilation options                                                      %options%
 *
 *      Option name                     Description
        -----------                     --------------------------------------------*/
#ifndef _STATEMACHINE_TCL_
#define _STATEMACHINE_TCL_
#ifdef mips
#undef mips                             /*  We don't want to have to deal with wierdness.  */
#endif
#ifdef vax
#undef vax                              /*  These things shouldn't turn into 1's in cpp.  */
#endif


/*
 *  Include files                                                           %includes%
 *
 *       Include File                   Description
         ------------                   --------------------------------------------*/
#ifndef MISC_TCL
#ifndef NO_PROCS
#define NO_PROCS
#include <misc.Tpp>
#undef NO_PROCS
#else
#include <misc.Tpp>
#endif
#endif
source LibFile(oops.tcl)


/*
 *  Local definitions                                                        %defines%
 *
 *      Local Symbol Name               Description
        -----------------               --------------------------------------------*/


/*
 *  Global symbols                                                           %globals%
 *
 *  Global Symbol Name                  Description
    ------------------                  --------------------------------------------*/


/*
 *  Macro definitions                                                         %macros%
 *
 *      Macro Name                      Description
        ----------                      --------------------------------------------*/



oClass stateMachine {
    
    stateMachine {lambda} {
        global oThis
#ifdef _DEBUG
        puts "Initializing state machine $oThis to state $lambda."
#endif
        oSet $oThis theState $lambda    //  Initialize the member 'theState' to the declared lambda.
        oSend $lambda enter
    }

    ~stateMachine {} {
        global oThis
#ifdef _DEBUG
        puts "Terminating state machine $oThis."
#endif
        oSend [oGet $oThis theState] exit
    }

    declare {event {args {}}} {
        global oThis
        set oldState [oGet $oThis theState]
#ifdef _DEBUG
        puts "Event detected on state machine $oThis: $event $args"
#endif
        set newState [eval [concat oSend $oldState $event $args]]
        if {[string compare $oldState $newState ]} {
#ifdef _DEBUG
            puts "Transitioning state machine $oThis from state $oldState to $newState."
#endif
            oSend $oldState exit
            oSend $newState enter
            oSet $oThis theState $newState
        }
    }
}

oClass state {
    enter {} {}
    exit {} {}
}

#endif
/*  end stateMachine.Tcl  */
