/*
 * stdarg.h
 *  This source code is offered for use in the public domain. You may
 *  use, modify or distribute it freely.
 *
 *  This code is distributed in the hope that it will be useful but
 *  WITHOUT ANY WARRANTY. ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
 *  DISCLAMED. This includes but is not limited to warranties of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef _STDARG_H_
#define _STDARG_H_

/*
 * Don't do any of this stuff for the resource compiler.
 */
#ifndef RC_INVOKED

/* 
 * I was told that Win NT likes this.
 */
#ifndef _VA_LIST_DEFINED
#define _VA_LIST_DEFINED
#endif

#ifndef	_VA_LIST
#define _VA_LIST
typedef struct {
  char *__base;			/* Pointer to first integer register. */
  int __offset;			/* Byte offset of args so far. */
} __gnuc_va_list;
typedef __gnuc_va_list va_list;
#endif

#ifdef	__GNUC__


#define va_start(pvar, firstarg)				\
  (__builtin_next_arg (firstarg),				\
   (pvar) = *(__gnuc_va_list *) __builtin_saveregs ())
#define va_end(__va)	((void) 0)

/* Values returned by __builtin_classify_type.  */

enum {
  __no_type_class = -1,
  __void_type_class,
  __integer_type_class,
  __char_type_class,
  __enumeral_type_class,
  __boolean_type_class,
  __pointer_type_class,
  __reference_type_class,
  __offset_type_class,
  __real_type_class,
  __complex_type_class,
  __function_type_class,
  __method_type_class,
  __record_type_class,
  __union_type_class,
  __array_type_class,
  __string_type_class,
  __set_type_class,
  __file_type_class,
  __lang_type_class
};
/* Get the size of a type in bytes, rounded up to an integral number
   of words.  */

#define __va_tsize(__type)  \
  (((sizeof (__type) + __extension__ sizeof (long long) - 1)   \
    / __extension__ sizeof (long long)) * __extension__ sizeof (long long))

#define va_arg(__va, __type)						\
(*(((__va).__offset += __va_tsize (__type)),				\
   (__type *)(void *)((__va).__base + (__va).__offset			\
	      - (((__builtin_classify_type (* (__type *) 0)		\
		   == __real_type_class) && (__va).__offset <= (6 * 8))	\
		 ? (6 * 8) + 8 : __va_tsize (__type)))))

#else
/* defintion for MS C */


extern void * __builtin_va_start(va_list, ...);

#ifdef	_CFRONT
#define __builtin_isfloat(a) __builtin_alignof(a)
#endif

#define va_start(list, v) __builtin_va_start(list, v, 1)
#define va_end(list)
#define va_arg(list, mode) \
    ( *(        ((list).__offset += ((int)sizeof(mode) + 7) & -8) , \
        (mode *)((list).__base + (list).__offset - \
                    ((__builtin_isfloat(mode) && (list).__offset <= (6 * 8)) ? \
                        (6 * 8) + 8 : ((int)sizeof(mode) + 7) & -8) \
                ) \
       ) \
    )
#endif
#endif /* Not RC_INVOKED */
#endif /* not _STDARG_H_ */
