@ECHO OFF
SET Destination=%1
IF NOT EXIST %destination%\AQM.EXE GOTO Err_NoDestination
IF NOT EXIST %destination%\Service\AQMSVC.EXE GOTO Err_BadDestination

IF NOT EXIST RELTEST.EXE GOTO Err_BadSource

REM Dispatch depending on what RELTEST finds:
REM	0 means AQM 3.0x is installed
REM	4 means AQM 2.3D is installed
REM	8 means No version is installed
REM
RELTEST
IF ERRORLEVEL 8 GOTO SetupInstall
IF ERRORLEVEL 4 GOTO Err_MustClean
IF ERRORLEVEL 0 GOTO DoUpgrade

:SetupInstall
SETUP.EXE
GOTO ExitUpgrade

:Err_MustClean
ECHO.
ECHO This version of AQM cannot be installed over a previous (V2.3D or earlier)
ECHO version of AQM.  Please refer to the enclosed instructions for removing
ECHO the old version or call Argent Software for support (860) 489-5553.
GOTO ExitUpgrade

:DoUpgrade

NET STOP "Argent Queue Manager"

ECHO.
ECHO Please make sure there are NO RUNNING jobs.
ECHO   Abort any executing jobs.

PAUSE
ECHO Copying file AQM.EXE
COPY AQM.EXE %Destination%\ || GOTO Err_GUIRunning
ECHO Copying file Launcher.EXE
COPY Launcher.EXE %Destination%\Service || GOTO Err_JobRunning
ECHO Copying file AQMSVC.EXE
COPY AQMSVC.EXE %Destination%\Service || GOTO Err_ServiceRunning
ECHO Copying file AQMAPI.DLL
COPY AQMAPI.DLL %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file AQMERR.DLL
COPY AQMERR.DLL %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file CCFILE.EXE
COPY CCFILE.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file FILEAGE.EXE
COPY FILEAGE.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file BCL.EXE
COPY BCL.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file BCL.CMD
COPY BCL.CMD %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file BEEP.EXE
COPY BEEP.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file BURNCPU.EXE
COPY BURNCPU.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file CC.EXE
COPY CC.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file SCANFILE.EXE
COPY SCANFILE.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file SHOW_SEC.EXE
COPY SHOW_SEC.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file SLEEP.EXE
COPY SLEEP.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QCANCEL.EXE
COPY QCANCEL.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QCLOSE.EXE
COPY QCLOSE.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QCREATE.EXE
COPY QCREATE.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QDELETE.EXE
COPY QDELETE.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QMODIFY.EXE
COPY QMODIFY.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QOPEN.EXE
COPY QOPEN.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QSHOW.EXE
COPY QSHOW.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QSTART.EXE
COPY QSTART.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QSTOP.EXE
COPY QSTOP.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QSUBMIT.EXE
COPY QSUBMIT.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file QSYSTEM.EXE
COPY QSYSTEM.EXE %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file AQM.HLP
COPY AQM.HLP %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file DEINSTAL.TXT
COPY DEINSTAL.TXT %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file JOB1.CMD
COPY JOB1.CMD %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file JOB2.CMD
COPY JOB2.CMD %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file LOOPER.CMD
COPY LOOPER.CMD %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file TEST1.BCL
COPY TEST1.BCL %Destination%\ || GOTO Err_KitIncomplete
ECHO Copying file README.TXT
COPY README.TXT %Destination%\ || GOTO Err_KitIncomplete

ECHO AQM has been successfully upgraded.

NET START "Argent Queue Manager"

ECHO The new Argent Queue Manager service has been started for you.
GOTO ExitUpgrade	

:Err_ServiceRunning
ECHO The AQM service has not been stopped.
ECHO Please stop the AQM service and try again.
GOTO ExitUpgrade

:Err_JobRunning
ECHO There are executing jobs running under AQM.
ECHO All jobs must be completed or aborted before upgrading.
ECHO.
ECHO If available use PVIEW to terminate any LAUNCHER processes.


GOTO ExitUpgrade

:Err_GUIRunning
GOTO ExitUpgrade

:Err_KitIncomplete
:Err_BadSource
ECHO AQM kit is incomplete.  File(s) missing.
ECHO Please contact Argent Software for support - (860) 489-5553
GOTO ExitUpgrade
:Bad_Destination
ECHO AQM installation not found at %Destination%
ECHO Please specify the first parameter as the path to the currently
ECHO installed AQM.
ECHO 		Example:  C:\AQM
ECHO If AQM is not installed, please use SETUP.EXE
GOTO ExitUpgrade

:Err_NoDestination
ECHO The first parameter must be the current installation directory of AQM
ECHO 		Example:  C:\AQM
ECHO If AQM is not installed, please use SETUP.EXE
GOTO ExitUpgrade

:ExitUpgrade
