Attribute VB_Name = "MainModule"
Option Explicit
Public CurrentZipFile$, unzipdir$
Public DontWait As Boolean                 ' Flag to not call WaitMessage during program termination

Type POINTAPI
    x As Long
    y As Long
End Type

Type MSG
    hWnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Declare Sub DragAcceptFiles Lib "shell32.dll" (ByVal hWnd As Long, ByVal fAccept As Long)
Public Declare Sub DragFinish Lib "shell32.dll" (ByVal hDrop As Long)
Public Declare Function DragQueryFile Lib "shell32.dll" Alias "DragQueryFileA" (ByVal hDrop As Long, ByVal UINT As Long, ByVal lpStr As String, ByVal ch As Long) As Long
Public Declare Function PeekMessage Lib "USER32" Alias "PeekMessageA" (lpMsg As MSG, ByVal hWnd As Long, ByVal wMsgFilterMin As Long, ByVal wMsgFilterMax As Long, ByVal wRemoveMsg As Long) As Long
Public Declare Function WaitMessage Lib "USER32" ()

Public Const PM_NOREMOVE = &H0
Public Const PM_NOYIELD = &H2
Public Const PM_REMOVE = &H1
Public Const WM_CLOSE = &H10
Public Const WM_QUIT = &H12
Public Const WM_DROPFILES = &H233

'****************************************************************
' This is the main routine for the program.  It will display
' the unzip form and then enter a message loop so we
' can process drag and drop file messages.
'****************************************************************
Private Sub Main()
    
    Unzipform.Show
    
    ' This must be the last line! Nothing gets called after this
    WatchForFiles
End Sub

'This watches for all WM_DROPFILES messages
Public Sub WatchForFiles()

    Dim FileDropMessage As MSG         ' Msg Type
    Dim fileDropped As Boolean              ' True if Files where dropped
    Dim hDrop As Long                          ' Pointer to the dropped file structure
    Dim FileName As String * 256           ' the dropped filename
    Dim numOfDroppedFiles As Long      ' the number of dropped files
    Dim curFile As Long                         ' the current file number
    Dim ret As Long                               ' Return code
       
    DontWait = False
    
    ' loop to keep checking for files
    ' NOTE : Do any code you want to execute before this loop
    Do
        
        ' 01/14/99 - AHY - Added a call to the WaitMessage system function.
        '                          This will prevent the task from constantly looping and
        '                          thus utilize 100% of the CPU.  The task will wait at this
        '                          point until a message is posted into it's queue.  This will
        '                          work for all applications that do not do background processing.
        '                          Those apps well need additional logic in this routine.
        If DontWait = False Then
           ret = WaitMessage
        End If
        If DontWait = False Then
           DontWait = PeekMessage(FileDropMessage, 0, WM_QUIT, WM_QUIT, PM_NOREMOVE Or PM_NOYIELD)
           If DontWait = False Then
              DontWait = PeekMessage(FileDropMessage, 0, WM_CLOSE, WM_CLOSE, PM_NOREMOVE Or PM_NOYIELD)
           End If
        End If

        ' Check for a WM_DROPFILE message in our queue
        ' Other messages will remain in the queue and be processed by DoEvents.
        fileDropped = PeekMessage(FileDropMessage, 0, WM_DROPFILES, WM_DROPFILES, PM_REMOVE Or PM_NOYIELD)

        ' If a file was dropped, then do the processing.
        If fileDropped Then
            'get the pointer to the dropped file structure
            hDrop = FileDropMessage.wParam
            
            ' This code can be used to process multiple files.  However, we are only going
            ' to process the first file that was dropped.
            
            'get the total number of files
            'numOfDroppedFiles = DragQueryFile(hDrop, True, FileName, 255)
         
            'For curFile = 1 To numOfDroppedFiles
                'get the file name
                'ret = DragQueryFile(hDrop, curFile - 1, FileName, 255)

                ' do loop processing here
            'Next curFile
            
            ret = DragQueryFile(hDrop, 0, FileName, 255)

            'we are now done with the structure, tell windows to discard it
            DragFinish (hDrop)

            ' Clear out the listview just in case...
            Unzipform.lvwFiles.ListItems.Clear
            
            ' Set the global file name variable and open the file
            CurrentZipFile = FileName
            
            If OpenZipFile = 0 Then

                ' Update status bar ???
                'If vbzipnum > 0 Then Print "Number of files: " + Str$(vbzipnum)

                Unzipform.Actions.Enabled = True
                Unzipform.CloseArchive.Enabled = True
           Else
                ' message box ???
                CurrentZipFile = ""
                Unzipform.Actions.Enabled = False
                Unzipform.CloseArchive.Enabled = False
            End If
        End If

        ' Process events other than a file drop (this is the normal VB message proc)
        DoEvents
     Loop
End Sub
