Attribute VB_Name = "VBUnzBas"
Option Explicit

'-----------------------------------------------------
' Code to interface with unzip32.dll
' Contributed to the Info-Zip project by Mike Le Voi (mlevoi@modemss.brisnet.org.au)
'                                                                 (http://modemss.brisnet.org.au/~mlevoi)
'
' Modified by Alan Young (ayoung@teleport.com) for unzip GUI front end
'
'-----------------------------------------------------

' argv
Private Type ZIPnames
    s(0 To 99) As String
End Type

' Callback large "string" (sic)
Private Type CBChar
    ch(32800) As Byte
End Type

' Callback small "string" (sic)
Private Type CBCh
    ch(256) As Byte
End Type

' DCL structure
Private Type DCLIST
    ExtractOnlyNewer As Long
    SpaceToUnderscore As Long
    PromptToOverwrite As Long
    fQuiet As Long
    ncflag As Long
    ntflag As Long
    nvflag As Long
    nUflag As Long
    nzflag As Long
    ndflag As Long
    noflag As Long
    naflag As Long
    nZIflag As Long
    C_flag As Long
    fPrivilege As Long
    Zip As String
    ExtractDir As String
End Type

' Userfunctions structure
Private Type USERFUNCTION
    DllPrnt As Long
    DLLSND As Long
    DLLREPLACE As Long
    DLLPASSWORD As Long
    DLLMESSAGE As Long
    DLLSERVICE As Long
    TotalSizeComp As Long
    TotalSize As Long
    CompFactor As Long
    NumMembers As Long
    cchComment As Integer
End Type

' Unzip32.dll version structure
Private Type UZPVER
    structlen As Long
    flag As Long
    beta As String * 10
    date As String * 20
    zlib As String * 10
    Unzip(1 To 4) As Byte
    zipinfo(1 To 4) As Byte
    os2dll As Long
    windll(1 To 4) As Byte
End Type

' This assumes unzip32.dll is in your \windows\system directory or in
' the same directory as the executable
''' Function changed name as of version 5.40 of the library
'Private Declare Function windll_unzip Lib "unzip32.dll" _
'    (ByVal ifnc As Long, ByRef ifnv As ZIPnames, _
'     ByVal xfnc As Long, ByRef xfnv As ZIPnames, _
'     dcll As DCLIST, Userf As USERFUNCTION) As Long
Private Declare Function Wiz_SingleEntryUnzip Lib "unzip32.dll" _
    (ByVal ifnc As Long, ByRef ifnv As ZIPnames, _
     ByVal xfnc As Long, ByRef xfnv As ZIPnames, _
     dcll As DCLIST, Userf As USERFUNCTION) As Long

Private Declare Sub UzpVersion2 Lib "unzip32.dll" _
    (uzpv As UZPVER)

' Private structures
Dim MYDCL As DCLIST
Dim MYUSER As USERFUNCTION

' Global structures
Global ZIPDLLVersionInfo As UZPVER
Global vbzipnum As Long, vbzipmes As String
Global vbzipinf As String
Global vbzipnam As ZIPnames, vbxnames As ZIPnames
Global crlf$

' Puts a function pointer in a structure
Function FnPtr(ByVal lp As Long) As Long
    FnPtr = lp
End Function

'Callback for unzip32.dll
 Public Sub ReceiveDllMessage(ByVal ucsize As Long, _
    ByVal csiz As Long, _
    ByVal cfactor As Integer, _
    ByVal mo As Integer, _
    ByVal dy As Integer, _
    ByVal yr As Integer, _
    ByVal hh As Integer, _
    ByVal mm As Integer, _
    ByVal c As Byte, _
    ByRef fname As CBCh, _
    ByRef meth As CBCh, _
    ByVal crc As Long, _
    ByVal fCrypt As Byte)

    Dim xx As Long
    Dim FileIndex As Long, DirIndex As Long, ExtensionIndex As Long
    Dim strout As String * 80, s0$, s1$
    Dim Item As ListItem

    ' always put this in callback routines!
    On Error Resume Next
    strout = Space(80)
'    If vbzipnum = 0 Then
'        Mid$(strout, 1, 50) = "Filename:"
'        Mid$(strout, 53, 4) = "Size"
'        Mid$(strout, 62, 4) = "Date"
'        Mid$(strout, 71, 4) = "Time"
'        vbzipmes = strout + crlf
'        strout = Space(80)
'    End If
    
    ' Get the name of the file and create a new listview item for it
    s0 = ""
    For xx = 0 To 255
        If fname.ch(xx) = 0 Then xx = 99999 Else s0 = s0 & Chr$(fname.ch(xx))
    Next xx
     
    ' Split the filename up into parts
    GetDirExt s0, FileIndex, DirIndex, ExtensionIndex
    ' Get the base name and extension
    If FileIndex = 0 Then
         s1 = s0
    Else
         s1 = Mid$(s0, FileIndex)
    End If
    
     ' Add list item
     Set Item = Unzipform.lvwFiles.ListItems.Add(, , s1)
        
      ' Add file type
      ' (This will need to scan the registry to get the type name. TODO...)
      's1 = Mid$(s0, ExtensionIndex)
      'If s1 = "" Then
      '   Item.SubItems(_) = "Unknown"
      'Else
      '   Item.SubItems(_) = s1
      'End If
      
      ' Add Modified
      Item.SubItems(1) = right$("0" + Trim$(Str$(mo)), 2) + "/" + _
                                   right$("0" + Trim$(Str$(dy)), 2) + "/" + _
                                   right$("0" + Trim$(Str$(yr)), 2) + " " + _
                                   right$(Str$(hh), 2) + ":" + _
                                   right$("0" + Trim$(Str$(mm)), 2)
      
      ' Add uncompressed size
      'Item.SubItems(2) = CStr(.Length \ 1000) & " KB"
      Item.SubItems(2) = Str$(ucsize)
      
      ' Add Ratio
      Item.SubItems(3) = Str$(cfactor) + "%"
      
      ' Add compressed size
       Item.SubItems(4) = Str$(csiz)

      ' Add path
      If FileIndex > 0 Then
         s1 = Mid$(s0, 1, FileIndex - 1)
         Item.SubItems(5) = s1
      Else
         Item.SubItems(5) = ""
      End If
          
     ' Compression Method
     s0 = ""
     For xx = 0 To 255
         If meth.ch(xx) = 0 Then xx = 99999 Else s0 = s0 + Chr(meth.ch(xx))
     Next xx
     Item.SubItems(6) = s0
     
    vbzipnum = vbzipnum + 1
    
End Sub

'Callback for unzip32.dll
 Public Sub ReceiveDllMessage2(ByVal ucsize As Long, _
    ByVal csiz As Long, _
    ByVal cfactor As Integer, _
    ByVal mo As Integer, _
    ByVal dy As Integer, _
    ByVal yr As Integer, _
    ByVal hh As Integer, _
    ByVal mm As Integer, _
    ByVal c As Byte, _
    ByRef fname As CBCh, _
    ByRef meth As CBCh, _
    ByVal crc As Long, _
    ByVal fCrypt As Byte)

    vbzipnum = vbzipnum + 1
    
End Sub



' Callback for unzip32.dll
Function DllPrnt(ByRef fname As CBChar, ByVal x As Long) As Long
    Dim s0$, xx As Long

    ' always put this in callback routines!
    On Error Resume Next
    s0 = ""
    For xx = 0 To x
        If fname.ch(xx) = 0 Then
           xx = 99999
        Else
           If (fname.ch(xx) <> 13) And (fname.ch(xx) <> 10) Then
              s0 = s0 + Chr(fname.ch(xx))
          End If
        End If
    Next xx
    vbzipinf = vbzipinf + s0 + Chr$(13) + Chr$(10)
    DllPrnt = 0
End Function

' Callback for unzip32.dll
Function DllPass(ByRef s1 As Byte, x As Long, _
    ByRef s2 As Byte, _
    ByRef s3 As Byte) As Long

    ' always put this in callback routines!
    On Error Resume Next
    ' not supported - always return 1
    DllPass = 1
End Function

' Callback for unzip32.dll
Function DllRep(ByRef fname As CBChar) As Long
    Dim s0$, xx As Long

    ' always put this in callback routines!
    On Error Resume Next
    DllRep = 100 ' 100=do not overwrite - keep asking user
    s0 = ""
    For xx = 0 To 255
        If fname.ch(xx) = 0 Then xx = 99999 Else s0 = s0 + Chr(fname.ch(xx))
    Next xx
    xx = MsgBox("Overwrite " + s0 + "?", vbYesNoCancel, "VBUnzip - File already exists")
    If xx = vbNo Then Exit Function
    If xx = vbCancel Then
        DllRep = 104 ' 104=overwrite none
        Exit Function
    End If
    DllRep = 102 ' 102=overwrite 103=overwrite all
End Function

Public Function OpenZipFile() As Long
         Dim mess%, dirs%, numf&, numx&
         Dim rc As Long
         
         ' Init global message variables
         vbzipinf = ""
         vbzipnum = 0
    
        ' Select unzip options
        mess = 1  ' 1=list contents of zip 0=extract
        dirs = 1     ' 1=honour zip directories
    
        ' Select all filenames for inclusion processing
        vbzipnam.s(0) = vbNullString
        numf = 0
    
        ' Select no filenames for exclusion processing
        vbxnames.s(0) = vbNullString
        numx = 0
            
        ' Maybe parse directory into here.  It doesn' t seem to be needed
        unzipdir = ""
    
        ' Call unzip routine
        rc = VBUnzip(CurrentZipFile, _
                            mess, _
                            unzipdir, _
                            dirs, _
                            1, _
                            0, _
                            0, _
                            0, _
                            0, _
                            0, _
                            0, _
                           numf, _
                           numx _
          )

        OpenZipFile = rc
End Function

' ASCIIZ to String
Function szTrim(szString As String) As String
    Dim pos As Integer, ln As Integer

    pos = InStr(szString, Chr$(0))
    ln = Len(szString)
    Select Case pos
        Case Is > 1
            szTrim = Trim(left(szString, pos - 1))
        Case 1
            szTrim = ""
        Case Else
            szTrim = Trim(szString)
    End Select
End Function

' Subroutine to test a ZIP file
Sub VBTestZip(filename As String, _
        NumberOfZipFilesToProcess As Long, _
        NumberOfFilesExtracted As Long _
       )
    
    Dim DLLCallReturnCode As Long

    ' Copy the options to the structure that will be passed to the DLL routine
    ' Zip filename - MUST BE VALIDATED BEFORE CALLING THE DLL!
    MYDCL.Zip = filename        ' ZIP file name
    
    ' 0=extract files, 1=only list the contents
    MYDCL.nvflag = 1

    ' Extraction directory, NULL if extracting to current directory
    MYDCL.ExtractDir = vbNullChar

    ' 1=honour directories
    MYDCL.ndflag = 1

    ' 1=prompt to overwrite required
    MYDCL.PromptToOverwrite = 1

    ' 1=overwrite files
    MYDCL.noflag = 0

    ' 1=extract only newer files
    ' Not sure why there are two flags for this...
    MYDCL.nUflag = 0
    MYDCL.ExtractOnlyNewer = 0

   ' 1=Zip Info Verbose
    MYDCL.nZIflag = 0

    ' 1=Case insensitivity, 0=Case Sensitivity
    MYDCL.C_flag = 0

    ' 1=Restore ACLs (NTFS only), 2=priv (??? need to check doc)
    MYDCL.fPrivilege = 1

    ' 1=Test zip file integrity
    MYDCL.ntflag = 1

    ' These options are not set via the current VB call interface
    MYDCL.fQuiet = 0                ' 2=no messages 1=less 0=all
    MYDCL.ncflag = 0                ' 1=write to stdout
    MYDCL.nzflag = 0                ' 1=display zip file comment
    MYDCL.naflag = 0                ' 1=convert CR to CRLF
    MYDCL.SpaceToUnderscore = 0     ' 1=convert space to underscore

    ' Set Callback addresses
    ' Do not change
    MYUSER.DllPrnt = FnPtr(AddressOf DllPrnt)
    MYUSER.DLLSND = 0& ' not supported
    MYUSER.DLLREPLACE = FnPtr(AddressOf DllRep)
    MYUSER.DLLPASSWORD = FnPtr(AddressOf DllPass)
    MYUSER.DLLMESSAGE = FnPtr(AddressOf ReceiveDllMessage2)
    MYUSER.DLLSERVICE = 0& ' not coded yet :)
    
    ' Setup storage space (C Structure).
    ' This will be filled with the Zip DLL version information
    ' Do not change
    With ZIPDLLVersionInfo
        .structlen = Len(ZIPDLLVersionInfo)
        .beta = Space$(9) & vbNullChar
        .date = Space$(19) & vbNullChar
        .zlib = Space$(9) & vbNullChar
    End With
    
    ' Get version information of unzip32.dll
    Call UzpVersion2(ZIPDLLVersionInfo)
    'Debug.Print "DLL Date: " & szTrim(ZIPDLLVersionInfo.date)
    'Debug.Print "Zip Info: " & Hex$(ZIPDLLVersionInfo.zipinfo(1)) + "." + Hex$(ZIPDLLVersionInfo.zipinfo(2)) + Hex$(ZIPDLLVersionInfo.zipinfo(3))
    'Debug.Print "DLL Version: " & Hex$(ZIPDLLVersionInfo.windll(1)) + "." + Hex$(ZIPDLLVersionInfo.windll(2)) + Hex$(ZIPDLLVersionInfo.windll(3))
    
    ' Go for it!
      DLLCallReturnCode = Wiz_SingleEntryUnzip( _
                                        NumberOfZipFilesToProcess, _
                                        vbzipnam, _
                                        NumberOfFilesExtracted, _
                                        vbxnames, _
                                        MYDCL, _
                                        MYUSER _
                                    )
    
    If DLLCallReturnCode <> 0 Then MsgBox DLLCallReturnCode
    
End Sub

' Unzip a file
'Sub VBUnzip(filename As String, _

Function VBUnzip(filename As String, _
        OnlyListFileContents As Integer, _
        ExtractDirectory As String, _
        PreserveDirectoryStructure As Integer, _
        PromptToOverwrite As Integer, _
        OverwriteFiles As Integer, _
        ExtractOnlyNewer As Integer, _
        ZipInfoVerbosity As Integer, _
        CaseSensitive As Integer, _
        RestoreACLs As Integer, _
        TestZipIntegrity As Integer, _
        NumberOfZipFilesToProcess As Long, _
        NumberOfFilesExtracted As Long _
       ) As Long

    Dim DLLCallReturnCode As Long

    ' Copy the options to the structure that will be passed to the DLL routine
    ' Zip filename - MUST BE VALIDATED BEFORE CALLING THE DLL!
    MYDCL.Zip = filename        ' ZIP file name
    
    ' 0=extract files, 1=only list the contents
    MYDCL.nvflag = OnlyListFileContents

    ' Extraction directory, NULL if extracting to current directory
    MYDCL.ExtractDir = ExtractDirectory

    ' 1=honour directories
    MYDCL.ndflag = PreserveDirectoryStructure

    ' 1=prompt to overwrite required
    MYDCL.PromptToOverwrite = PromptToOverwrite

    ' 1=overwrite files
    MYDCL.noflag = OverwriteFiles

    ' 1=extract only newer files
    ' Not sure why there are two flags for this...
    MYDCL.nUflag = ExtractOnlyNewer
    MYDCL.ExtractOnlyNewer = ExtractOnlyNewer

   ' 1=Zip Info Verbose
    MYDCL.nZIflag = ZipInfoVerbosity

    ' 1=Case insensitivity, 0=Case Sensitivity
    MYDCL.C_flag = CaseSensitive

    ' 1=Restore ACLs (NTFS only), 2=priv (??? need to check doc)
    MYDCL.fPrivilege = RestoreACLs

    ' 1=Test zip file integrity
    MYDCL.ntflag = 0

    ' These options are not set via the current VB call interface
    MYDCL.fQuiet = 0                ' 2=no messages 1=less 0=all
    MYDCL.ncflag = 0                ' 1=write to stdout
    MYDCL.nzflag = 0                ' 1=display zip file comment
    MYDCL.naflag = 0                ' 1=convert CR to CRLF
    MYDCL.SpaceToUnderscore = 0     ' 1=convert space to underscore

    ' Set Callback addresses
    ' Do not change
    MYUSER.DllPrnt = FnPtr(AddressOf DllPrnt)
    MYUSER.DLLSND = 0& ' not supported
    MYUSER.DLLREPLACE = FnPtr(AddressOf DllRep)
    MYUSER.DLLPASSWORD = FnPtr(AddressOf DllPass)
    MYUSER.DLLMESSAGE = FnPtr(AddressOf ReceiveDllMessage)
    MYUSER.DLLSERVICE = 0& ' not coded yet :)
    
    ' Setup storage space (C Structure).
    ' This will be filled with the Zip DLL version information
    ' Do not change
    With ZIPDLLVersionInfo
        .structlen = Len(ZIPDLLVersionInfo)
        .beta = Space$(9) & vbNullChar
        .date = Space$(19) & vbNullChar
        .zlib = Space$(9) & vbNullChar
    End With
    
    ' Get version information of unzip32.dll
    Call UzpVersion2(ZIPDLLVersionInfo)
    'Debug.Print "DLL Date: " & szTrim(ZIPDLLVersionInfo.date)
    'Debug.Print "Zip Info: " & Hex$(ZIPDLLVersionInfo.zipinfo(1)) + "." + Hex$(ZIPDLLVersionInfo.zipinfo(2)) + Hex$(ZIPDLLVersionInfo.zipinfo(3))
    'Debug.Print "DLL Version: " & Hex$(ZIPDLLVersionInfo.windll(1)) + "." + Hex$(ZIPDLLVersionInfo.windll(2)) + Hex$(ZIPDLLVersionInfo.windll(3))
    
    ' Go for it!
      DLLCallReturnCode = Wiz_SingleEntryUnzip( _
                                        NumberOfZipFilesToProcess, _
                                        vbzipnam, _
                                        NumberOfFilesExtracted, _
                                        vbxnames, _
                                        MYDCL, _
                                        MYUSER _
                                    )
    
    'If DLLCallReturnCode <> 0 Then MsgBox DLLCallReturnCode
        
    'Debug.Print "--------------"
    'Debug.Print MYUSER.cchComment
    'Debug.Print MYUSER.TotalSizeComp
    'Debug.Print MYUSER.TotalSize
    'Debug.Print MYUSER.CompFactor
    'Debug.Print MYUSER.NumMembers
    'Debug.Print "--------------"

    VBUnzip = DLLCallReturnCode
End Function


