/*@H************************ < COMPRESS utility> ****************************
*   $@(#) compusi.dos,v 4.3d 90/01/18 03:00:00 don Release ^                *
*                                                                           *
*   compress : compusi.dos <MsDos support functions>                        *
*                          <AtariST and Amiga support functions>            *
*                          <Turbo C v2.0 support functions>                 *
*   port by  : Donald J. Gloistein                                          *
*                                                                           *
*   Source, Documentation, Object Code:                                     *
*   released to Public Domain. This code is ported from compress v4.0       *
*   release joe.                                                            *
*                                                                           *
*---------------------------  Module Description  --------------------------*
*   Ms and Pc Dos dependent code.                                           *
*                                                                           *
*   Separated out for ease of writing the main module.                      *
*                                                                           *
*--------------------------- Implementation Notes --------------------------*
*                                                                           *
*   compiled with : compress.h compress.fns                                 *
*   linked with   : compress.obj compapi.obj                                *
*   problems:                                                               *
*                                                                           *
*   To use, copy or rename this file to compusi.c and recompile.            *
*   Set the defines in compress.h to reflect the status of your compiler's  *
*   runtime library, allocation type for malloc()'s, and memory models if   *
*   applicable, and your library function call for malloc() and free().     *
*                                                                           *
*                                                                           *
*---------------------------      Author(s)        -------------------------*
*     Initials ---- Name ---------------------------------                  *
*      DjG          Donald J. Gloistein                                     *
*                   Plus many others, see rev.hst file for full list        *
*      Dal          Dale A. Schumacher (Sozobon C port)                     *
*      LvR          Lyle V. Rains, many thanks for improved implementation  *
*                   of the compression and decompression routines.          *
*************************************************************************@H*/

#include <stdio.h>
#include <malloc.h>
#include "compress.h" /* contains the rest of the include file declarations */

#define _ffree free
#define _fmalloc malloc
/* For those who don't have it in libc.a */

#ifdef NO_STRCHR
char *strchr(s, c)
char *s;
int c;
{
    while ( *s) {
        if (*s == (char)c)
            return(s);
        else
            s++;
    }
    return(NULL);
}
#endif

#ifdef NO_REVSEARCH
char *strrpbrk(str1,str2)
char *str1;   /*string to be searched */
char *str2;   /*chars to search for */
{
    register char *p;
    register int count = 0;

    while (*str1){
        str1++;
        count++;
    }
    str1--;
    while (count--) {
        p = str2;
        do {
            if (*str1 == *p)
                return(str1);
        } while (*p++);
        str1--;
    }
    return (NULL);
}
#endif

char *get_program_name(ptr)
char *ptr;
{
    char *cp,*temp;

    if ((cp = strchr(ptr,' '))!= NULL)    /* to allow for os/2 argv[0] */
        *cp = '\0';
    cp = name_index(ptr);
    if ((temp = strchr(cp,'.')) != NULL)
        *temp = '\0';

    setbinary(stdin);        /* MSDOS & compiler dependent, mode defaults*/
    setbinary(stdout);       /* to text stdin/out--see compress.h*/
                             
/* DjG Don't assume for the OS, force lower case */
    for (temp = cp;*temp; temp++)
        *temp = tolower(*temp);

    if(strncmp(cp,"uncomp",6) == 0) {
        do_decomp = 1;
    }
    else
    if(strncmp(cp, "zcat",4) == 0) {
        keep = TRUE;
        zcat_flg = do_decomp = 1;
    }
    return (cp);
}

char *name_index(ptr)
char *ptr;
{
    char *p;

    p = strrpbrk(ptr,"\\/:");
    return ((p)?++p:ptr);
}

int is_z_name(ptr)       /* checks if it is already a z name */
char *ptr;
{
    int len = (int)strlen(ptr) -1;
    return ((ptr[len] == 'z' || ptr[len] == 'Z'));
}

int make_z_name(ptr)
char *ptr;
{
    char *ep,*temp;

    temp = name_index(ptr);           /* get right most delimiter */
    if ( (ep = strchr(temp,'.'))!=NULL ) {   /* has an extension */
        if (strlen(ep) > 3) {
            endchar[0] = ep[3];
            ep[3] = 'Z';
        }
        else
            strcat(ep,"Z");
    }
    else
        strcat(ptr,".Z");
    return TRUE;
}
void unmake_z_name(ptr)
char *ptr;
{
    register int len = (int)strlen(ptr)-1;

    if ((ptr[len] == 'Z' || ptr[len] == 'z') && *endchar)
        ptr[len] = endchar[0];
    else
        ptr[len] = '\0';
}

#ifndef NOSIGNAL
#ifdef ISOS2
             /* this is for Microsoft C v5.1 to compile and be bound */
             /* for use with os/2.  The signal function is different */
             /* between protected and real mode                      */
             /* Since we exit, there is no need for SIG_ACK and      */
             /* resetting the handler. But later code may want it    */
SIGTYPE onintr ( )
{
    signal(SIGINT,SIG_IGN);  /* lets make sure no other interupts happen */
    if (!zcat_flg && !keep_error){
        fclose(stdout);
        unlink ( ofname );
    }
    exit ( ERROR );
}

SIGTYPE oops ( )    /* wild pointer -- assume bad input */
{
    signal(SIGINT,SIG_IGN);
    if ( do_decomp == 1 )
        fprintf ( stderr, "%s: corrupt input: %s\n",prog_name,ifname);
    if (!zcat_flg && !keep_error){
        fclose(stdout);
        unlink ( ofname );
    }
    exit ( ERROR );
}
#else        /* for non bound applications */
SIGTYPE onintr ( )
{

    if (!zcat_flg && !keep_error){
        fclose(stdout);
        unlink ( ofname );
    }
    exit ( ERROR );
}

SIGTYPE oops ( )    /* wild pointer -- assume bad input */
{
    if ( do_decomp == 1 )
        fprintf ( stderr, "%s: corrupt input: %s\n",prog_name,ifname);
    if (!zcat_flg && !keep_error){
        fclose(stdout);
        unlink ( ofname );
    }
    exit ( ERROR );
}
#endif
#endif

#ifdef MWC
struct utimbuf {time_t a,b;};
#endif
#ifdef __TURBOC__
struct ftime utimbuf;
#endif
#ifdef SOZOBON
#ifndef S_IFREG
#define S_IFREG         (S_IREAD | S_IWRITE)
#endif
#endif

int test_file(ifname)  /* test for a good file name and no links */
char *ifname;          /* returns 0 for good file ERROR for bad  */
{
    struct stat statbuf;
    if (stat(ifname, &statbuf)) {       /* Get stat on input file */
        perror(ifname);
        return(ERROR);
    }else if ((statbuf.st_mode & S_IFMT/*0170000*/) != S_IFREG/*0100000*/) {
        fprintf(stderr, "%s -- not a regular file: unchanged",ifname);
        return(ERROR);
        }
/* take out the following, it is a no operation on dos systems */
/* left the code in, in case some dos like systems use it      */
/* define USE_LINKS if your computer uses links                */
#ifndef USE_LINKS
    else if (statbuf.st_nlink > 1) {
        fprintf(stderr, "%s -- has %d other links: unchanged",ifname,
            statbuf.st_nlink - 1);
        return(ERROR);
    }
#endif
   return (0);
}

void copystat(ifname, ofname)
char *ifname, *ofname;
{
    struct stat statbuf;
	int mode;
#ifndef __TURBOC__
	time_t timep[2];
#endif

    fclose(stdout);
    if (stat(ifname, &statbuf)) {       /* Get stat on input file */
        perror(ifname);
        return;
    }
    if (exit_stat == NOSAVING && (!force)) { /* No compression: remove file.Z */
        if(!quiet)
            fprintf(stderr, " -- no savings -- file unchanged");
    }
    else if (exit_stat == NOMEM){
        if (!quiet)
            fprintf(stderr, " -- file unchanged");
        if (!do_decomp)
            exit(ERROR);
        else
            return;   /* otherwise will unlink outfile */
    }
    else if (exit_stat == OK) {    /* ***** Successful Compression ***** */
        mode = statbuf.st_mode & 07777;
        if (chmod(ofname, mode))        /* Copy modes */
	    perror(ofname);
#ifdef __TURBOC__      /* does not have utime */
        getftime(fileno(stdin),&utimbuf);
        freopen(ofname,READ_FILE_TYPE,stdout);
        setftime(fileno(stdout),&utimbuf);
        fclose(stdout);
#else
#ifdef SOZOBON
        utime(ofname, &(statbuf.st_mtime));
#endif
        timep[0] = statbuf.st_atime;
        timep[1] = statbuf.st_mtime;
        utime(ofname, (struct utimbuf *)timep);   /* Update last accessed and modified times */
#endif
	if (!keep){
            fclose(stdin);
            if (unlink(ifname)) /* Remove input file */
                perror(ifname);
            if(!quiet)
                fprintf(stderr, " -- replaced with %s", ofname);
        }
        else{
            if(!quiet)
                fprintf(stderr, " -- compressed to %s", ofname);
        }
        return;     /* Successful return */
    }

    /* Unsuccessful return -- one of the tests failed */
    fclose(stdout);
    if (unlink(ofname))
        perror(ofname);
}

#ifndef COMPVER
#ifdef MSDOS
#define COMPVER "Msdos"
#else
#define COMPVER "Generic"
#endif
#endif

#ifdef COMP40
#define RESET "Adaptive Reset"
#else
#define RESET "No Adaptive Reset"
#endif

void version()
{
#ifdef DEBUG
    fprintf(stderr, "%s\nOptions: %s %s DEBUG MAXBITS = %d\n",rcs_ident,COMPVER,
        RESET,MAXBITS);
#else
    fprintf(stderr, "%s\nOptions: %s %s MAXBITS = %d\n",rcs_ident,COMPVER,
    RESET,MAXBITS);
#endif
}

ALLOCTYPE FAR *emalloc(x,y)
unsigned int x;
int y;
{
    ALLOCTYPE FAR *p;
    p = (ALLOCTYPE FAR *)ALLOCATE(x,y);
    return(p);
}
void efree(ptr)
ALLOCTYPE FAR *ptr;
{
    FREEIT(ptr);
}
