/* File: $RCSfile: malloc_md.h,v $ */

/* the following items may need to be configured for a particular machine */

/* alignment requirement for machine (in bytes) */
#ifdef __alpha
#define NALIGN  8
#else
#define NALIGN  4
#endif

/* size of an integer large enough to hold a character pointer */
typedef int Size;

/*
 * CURBRK returns the value of the current system break, i.e., the system's
 * idea of the highest legal address in the data area.  It is defined as
 * a macro for the benefit of systems that have provided an easier way to
 * obtain this number (such as in an external variable)
 */

#define CURBRK  curbrk

/*
 * note that it is assumed that CURBRK remembers the last requested break to
 * the nearest byte (or at least the nearest word) rather than the nearest page
 * boundary.  If this is not true then the following BRK macro should be
 * replaced with one that remembers the break to within word-size accuracy.
 */

#define BRK(x)  brk_md(x)


/* END of machine dependent portion */

#define MAGIC_FREE      0x548a934c
#define MAGIC_BUSY      0xc139569a

#define NBUCKETS        18

struct qelem {
        struct qelem *q_forw;
        struct qelem *q_back;
};

struct overhead {
        struct qelem    ov_adj;         /* adjacency chain pointers */
        struct qelem    ov_buk;         /* bucket chain pointers */
	int		ov_magic;
        Size            ov_length;
};

/*
 * The following macros depend on the order of the elements in struct overhead
 */
#define TOADJ(p)        ((struct qelem *)(p))
#define FROMADJ(p)      ((struct overhead *)(p))
#define FROMBUK(p)      ((struct overhead *)( (char *)p - sizeof(struct qelem)))
#define TOBUK(p)        ((struct qelem *)( (char *)p + sizeof(struct qelem)))

#ifdef MALLOC
/*
 * return to the system memory freed adjacent to the break
 * default is Off
 */
static char endfree = 0;

/* A Fibonacci sequence of relatively small bucket sizes. */
static Size mlsizes[] = {    0,    56,    96,   152,   248,    400,
			   648,  1048,  1696,  2744,  4440,   7184,
			 11624, 18808, 30432, 49240, 79672, 128912};

/* head of adjacency chain */
static struct qelem adjhead = { &adjhead, &adjhead };

/* head of bucket chains */
static struct qelem buckets[NBUCKETS] = {
        &buckets[0],  &buckets[0],      &buckets[1],  &buckets[1],
        &buckets[2],  &buckets[2],      &buckets[3],  &buckets[3],
        &buckets[4],  &buckets[4],      &buckets[5],  &buckets[5],
        &buckets[6],  &buckets[6],      &buckets[7],  &buckets[7],
        &buckets[8],  &buckets[8],      &buckets[9],  &buckets[9],
        &buckets[10], &buckets[10],     &buckets[11], &buckets[11],
        &buckets[12], &buckets[12],     &buckets[13], &buckets[13],
        &buckets[14], &buckets[14],     &buckets[15], &buckets[15],
        &buckets[16], &buckets[16],     &buckets[17], &buckets[17]
};

static void (*mlabort)() = {0};

#else
extern char endfree;
extern struct qelem adjhead, buckets[NBUCKETS];
extern Size mlsizes[NBUCKETS];
extern void (*mlabort)();
extern void insque(struct qelem *, struct qelem *);
extern void remque(struct qelem *);
extern void mllcerr();
extern int brk_md(Size);
#endif



#ifdef debug
# define ASSERT(p,q)    if (!(p))  {assert (&p);}
#else
# define ASSERT(p,q)
#endif
