/*
** Copyright (C) 1991, 1992 by
** Digital Equipment Corporation, Maynard, Mass.
**
** This software is furnished under a license and may be used and copied
** only  in  accordance  with  the  terms  of such  license and with the
** inclusion of the above copyright notice. This software or  any  other
** copies thereof may not be provided or otherwise made available to any
** other person. No title to and ownership of  the  software  is  hereby
** transferred.
**
** The information in this software is subject to change without  notice
** and  should  not be  construed  as  a commitment by Digital Equipment
** Corporation.
**
** Digital assumes no responsibility for the use or  reliability  of its
** software on equipment which is not supplied by Digital.
**
*/

#define DCE_TRUE     1
#define DCE_FALSE    0


/*
** DC21x40 HW accesses
*/

typedef enum
    {
    DCE_USE_PCI_BIOS,
    DCE_USE_PCI_MECHANISM1,
    DCE_USE_PCI_MECHANISM2
    } DCE_HW_accesses;


/*
** DC21040 - SIA modes
*/

typedef enum 
    {
    DCE_TP_FULL_DUPLEX_MODE,
    DCE_AUI_MODE,
    DCE_BNC_MODE,
    DCE_TP_MODE,
    DCE_AUTODETECT_MODE,
    DCE_TP_IGNORE_LINKTEST_POS_MODE,
    DCE_TP_IGNORE_LINKTEST_NEG_MODE
    } DCE_DC21040_sia_mode_t;


/*
** DC21140 - serial modes
*/

typedef enum 
    {
    DCE_10MB_MODE,
    DCE_10MB_FULL_DUPLEX_MODE,
    DCE_100MB_MODE,
    DCE_100MB_FULL_DUPLEX_MODE
    } DCE_DC21140_serial_mode_t;


/*
** Cache Alignment
*/

typedef enum 
    {
    DCE_CACHE_ILLEGAL = 0,
    DCE_CACHE_8 = 1,
    DCE_CACHE_16 = 2,
    DCE_CACHE_32 = 3
    } DCE_cache_alignment_t;

/*
** TX FIFO Threshold for 100MB
*/

typedef enum 
    {
    DCE_10MB_THRESHOLD_72 = 0,
    DCE_10MB_THRESHOLD_96,
    DCE_10MB_THRESHOLD_128,       
    DCE_10MB_THRESHOLD_160      
    } DCE_10MB_threshold_t;


#define DCE_NULL_PCI_HANDLER     0

/* 
** HW/SW CRC calculation
*/

typedef enum 
    {
    DCE_SW_CRC_ALWAYS = 0,
    DCE_SW_CRC_NEVER
    } DCE_crc_calc_t;


typedef struct 
   {
   ulong                     board_num;
   char                      *board_id;
   uint                      vector;
   ulong                     iobase;
   ulong                     ioend;
   ulong                     cfgbase;
   ulong                     DC21040_probe_val;
   ulong                     DC21140_probe_val;
   ulong                     DC21040_cfid_probe_val;
   ulong                     DC21140_cfid_probe_val;
   uint                      major_num;
   uint                      rx_bufs_to_post;
   uint                      rx_pkts_queued_thresh_hi;
   uint                      rx_pkts_queued_thresh_lo;
   uint                      uniform_card_model;
   DCE_DC21040_sia_mode_t    DC21040_sia_mode;
   DCE_DC21140_serial_mode_t DC21140_serial_mode;
   uint                      bus_arbitration;
   uint                      burst_length;
   DCE_cache_alignment_t     cache_alignment;       
   uint                      pass_bad_frames;
   uint                      backoff_cntr;
   DCE_10MB_threshold_t      threshold;
   uint                      back_pressure;
   uint                      capture_effect_enable;
   uint                      parity_error_response;
   uint                      latency_timer;
   uint                      pci_handle;
   DCE_crc_calc_t            crc_calc;
   } DCE_board_config_t;
    
