/*
 * Copyright Digital Products, Inc.. All Rights Reserved. 
 *
 * Outfilter
 *
 * This filter reads an ASCII banner page from its standard input, converts
 * linefeeds to carriage return/line feed and handles STOP/START signals
 * from the print system 
 *
 */ 
#include <stdio.h>
#include <signal.h>
#include <fcntl.h>

main(argc,argv)
int argc;
char *argv[];
{
int	c ;
int	pid ;
int	fcntl_flags ;

	pid = getpid() ;

	


#ifdef DEBUG
	fprintf( stderr, "\n\n<<<out filter start pid: %d args:\n", pid ) ;

	fcntl_flags = fcntl( fileno( stdout ), F_GETFL, 0 ) ;

	fprintf( stderr, "fcntl = %010o O_NDELAY = %s NONBLOCK = %s\n",
			fcntl_flags,
			(fcntl_flags & O_NDELAY) ? "ON" : "OFF",
			(fcntl_flags & O_NONBLOCK) ? "ON" : "OFF"
	) ;

	fcntl_flags = fcntl( fileno( stdout ), F_SETFL, 0 ) ;

	while (--argc) {

		fprintf( stderr, "\t'%s'\n", *argv++ ) ;
	}

	fprintf( stderr, "\nout DATA:\n" ) ;

#endif
	while ( (c = getchar()) != EOF) {

		if ( c == '\n' ) {
			putchar( '\r' ) ;
			putchar( '\n' ) ;
			continue ;
		}

		if ( c == '\031' ) {

			c = getchar() ;

			if ( c == '\n' ) {
				putchar( '\r' ) ;
				putchar( '\n' ) ;
				continue ;
			}

			if ( c == '\001' ) {

#ifdef DEBUG
				fprintf( stderr, "\nSTOP\n" ) ;
#endif
				fflush( stdout ) ;

				(void) kill(getpid(), SIGSTOP);
#ifdef DEBUG
				fprintf( stderr, "\nSTART\n" ) ;
#endif
				continue ;
			}

			putchar( '\031' ) ;
			putchar( c ) ;
/*			fprintf( stderr, "\nFalse stop\n" ) ; */
			continue ;
		}

		if ( putc(c, stdout) == EOF ) {
			perror( "OUT error" ) ;
			break ;
		}

/* 		putc( c, stderr ); */
	}

#ifdef DEBUG
	fprintf( stderr, "END out filter end pid: %d\n", pid ) ;
#endif

	exit( 0 ) ;
}
