/*
 *
 *     Module Name: p_stack.h
 *         Version: 1.00
 *   Original Date: September 14 1993
 *          Author: Ehrich Grein
 *        Language:
 * Compile Options:
 * Compile defines:
 *       Libraries:
 *    Link Options:
 *
 *    Entry Points:
 *
 * Description.
 * =======================================================================
 * This defines the structure (a long) and the protocol bitmaps for
 * defining the active protocols in a netprint unit.
 *
 *
 * Edit Date/Ver   Edit Description
 * ==============  =======================================================
 *   9-14-93         EPG  Created
 *
 */


#ifndef _P_STACK_H
#define _P_STACK_H
                                          /*MSB                            LSB*/
                                          /* v                              v */
#define PROTOCOL_NOVEL_NETWARE 0x00000001 /* 00000000000000000000000000000001 */
#define PROTOCOL_APPLETALK     0x00000002 /* 00000000000000000000000000000010 */
#define PROTOCOL_BANYAN_VINES  0x00000004 /* 00000000000000000000000000000100 */
#define PROTOCOL_TCP_IP        0x00000008 /* 00000000000000000000000000001000 */
#define PROTOCOL_DEC_LAT       0x00000010 /* 00000000000000000000000000010000 */

/* The following variables will be declared and setup in streams/startup.c */
/* There they will be initialized using defines from config.h to determine */
/* the value they will hold.                                               */
/*     long  perm_protocols      This will contain a bit map using the     */
/*                               above values to show what protocols will  */
/*                               allways be active for this particular     */
/*                               unit.                                     */
/*                                                                         */
/*     long  available_protocols This will contain a bit map using the     */
/*                               above vaules to show what protocols are   */
/*                               available for use in this unit.           */
/*                                                                         */
/*     int16 number_active_protocols - This is the max number of protocols */
/*                                     allowed to be active at any one.    */
/*                                                                         */

/* This is the structure stored in configuration memory to hold  */
/* the protocols that are currently active in the Net Print unit */
typedef struct
{ 
  unsigned int protocol;
} protocol_stack_config_t;

#endif
