/* 
 * Copyright Digital Products, Inc.. All Rights Reserved. 
 *
 * DPI_FPRINT.C - This program receives print data and writes the data to
 * a file.
 */


#include <stdio.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/*
 * Globals
 */ 

char	*prog_name ;

char	*tty_arg ;
char	*host_arg ;
char	*port_arg ;
int	port_num ;

struct sockaddr_in	 saddr;

int	tty_fd ;
int	print_fd ;

char	buf[512] ;
int	read_size ;
int	write_size ;


void	sigpipe_handler() ;

/*
 * Name:        main
 *
 * Function:    Main entry point of this program.
 */ 

main( argc, argv )
int	argc;
char	*argv[];
{

	prog_name = argv[0] ;

	if ( argc < 2  ) {

		usage() ;
	}


	tty_arg = argv[1] ;
	host_arg = argv[2] ;
	port_arg = argv[3] ;

	fprintf( stderr,
		 "tty = %s host = %s port = %s\n",
		 tty_arg,
		 host_arg,
		 port_arg
	) ;

	port_num = atoi( port_arg ) ;

	signal( SIGPIPE, sigpipe_handler ) ;

	open_tty() ;

	read_size = read( tty_fd, buf, 512 ) ;

	if ( read_size < 0 ) {
		perror( "read1" ) ;
	}

	open_printer() ;

	while( 1 ) {

		while( 1 ) {

			write_size = write( print_fd, buf, read_size ) ;

			if ( write_size <= 0 ) {

				perror( "write" ) ;
				close( print_fd ) ;

				open_printer() ;
				continue ;
			}

			read_size = read( tty_fd, buf, 512 ) ;

			if ( read_size <= 0 ) {
				break ;
			}

		}

		close( tty_fd ) ;
		close( print_fd ) ;

		printf( "Tty closed, reopening\n" ) ;

		open_tty() ;

		read_size = read( tty_fd, buf, 512 ) ;

		if ( read_size < 0 ) {
			perror( "read2" ) ;
		}

		sleep( 5 ) ;
		open_printer() ;
	}
}


open_tty() {

	fprintf( stderr, "opening tty: %s\n", tty_arg ) ;

	tty_fd = open( tty_arg, O_RDONLY ) ;

	if ( tty_fd < 0 ) {

		perror( "can't open tty" ) ;
		exit( 1 ) ;
	}
}
	


/*
 * Name:        open_printer
 *
 * Function:    Opens a file to be used as the destination for the print
 *              data. 
 */ 

int open_printer() {
extern int errno ;

        static int doc_no = 1;
        char filename[32];

	fprintf( stderr,
		 "connecting host: %s port: %s\n",
		 host_arg, port_arg ) ;

        sprintf (filename, "PRN_DATA.%d", doc_no++); 

        print_fd = open (filename, O_CREAT | O_RDWR, 0777);
        if (print_fd == -1)
        {
            perror ("Print Data open file failed.");
            exit (1);
        }

	fprintf(stderr, "connected\n" ) ;
}


get_host_data() 
{

struct hostent		 *host_ptr;

	if ( ( host_ptr = gethostbyname( host_arg ) ) == NULL ) {
		fprintf( stderr, "can't find host %s\n", host_arg ) ;

	}

	bzero( (char *) &saddr, sizeof(saddr));
	saddr.sin_family	= AF_INET;
	saddr.sin_port		= htons(port_num);

	bcopy( host_ptr->h_addr, (char *)&saddr.sin_addr, host_ptr->h_length ) ;
}


usage() {

	fprintf( stderr,
		"usage: %s <tty or pipe> <host> <port>\n",
		 prog_name
	) ;

	exit( 1 ) ;
}



void sigpipe_handler() {

	fprintf( stderr, "SIGPIPE\n" ) ;
}
