/*
 * Copyright Digital Products, Inc.. All Rights Reserved. 
 *
 * psfilter
 *
 * This filter is capable of distinguishing between ASCII, Postscript and PCL.
 * Postscript and PCL jobs are sent to the printer "as is". ASCII is 
 * translated as follows: CR is added to all LF. 
 */ 

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include "recognize.h"

#define SIZEOF_XMIT_BUF 1024

char	xmit_buf[SIZEOF_XMIT_BUF];
char	upper_buf[SIZEOF_XMIT_BUF];

void	sig_handler() ;
extern int recognize(/* char *xmit_buf */);
extern int make_uppercase (/* char *src_buf, int buf_len, char *dest_buf */);



main(argc,argv)
int argc;
char *argv[];
{
int	chars=0;
int	type=0, initial=1;
	
#ifdef DEBUG
        fprintf(stderr," entering infilter\n");

	while (argc--) {

		fprintf( stderr, "\t'%s'\n", *argv++ ) ;
	}
#endif

	signal( SIGPIPE, sig_handler ) ;
	signal( SIGHUP, sig_handler ) ;
	signal( SIGINT, sig_handler ) ;

	while ((chars = getbuf()) > 0)
	{
		if (initial)
		{
			make_uppercase(xmit_buf, chars, upper_buf);

			type = recognize(upper_buf);

			if (type == ASCII_JOB)
				pspreamble();
			else if (type != POSTSCRIPT_JOB)
				exit(1);

			initial = 0;
		}

		putbuf(chars, type);
	}


	putchar(4);
#ifdef DEBUG
        fprintf(stderr," exiting infilter\n");
#endif
	exit( 0 ) ;
}


int getbuf()

{

int	c, count=0;

	while ((count < SIZEOF_XMIT_BUF) && (c = getchar()) != EOF) 
        {
		xmit_buf[count++] = c;
	}

	return(count);

}


int putbuf(chars, type)
int	chars;
int	type;

{
int	i=0, j, col=0;

	if (type == POSTSCRIPT_JOB)
	{
		for (i = 0; i < chars; i++)
			putchar(xmit_buf[i]);
	}
	else if (type == ASCII_JOB)
	{
		for (i = 0; i < chars; i++)
		{

			if (xmit_buf[i] == '\t')
			{
				for (j=0; j+col<8;j++)
					putchar(' ');

				col = 0;
			}
			else
			{
				putchar(xmit_buf[i]);
				if ((xmit_buf[i] >= 32) && (xmit_buf[i] <= 127))
					col = (col + 1) % 8;
				else
					col = 0;
			}

		}


	}
}



void sig_handler() {

;
}

dump(buf)
char *buf;
{
int i;

for (i=0; i < strlen(buf); i++)
   putchar(buf[i]);
}


pspreamble()

{
	char buf[80];

	sprintf (buf, "/printloop{{currentfile cvlit =string readline not {exit} if\n");
	dump(buf);

	sprintf (buf, "show currentpoint exch pop\n");
	dump(buf);

	sprintf (buf, "10.5 sub dup 36 le {pop showpage 72 730 moveto}\n");
	dump(buf);

	sprintf (buf, "{72 exch moveto} ifelse} loop showpage}\n");
	dump(buf);

	sprintf (buf, "bind def /Courier findfont 11 scalefont setfont\n");
	dump(buf);

	sprintf (buf, "72 730 moveto printloop\n");
	dump(buf);

#ifdef DEBUG
	sprintf(buf, "This confirms that the file was produced by infilter.\n");
	dump(buf);
#endif
}
