
/************************************************************/
/*  PCL keywords-->>                                        */
/*                                                          */
/*  To be declared a match, character immed after keyword   */
/*  must be an ascii numeric digit.                         */
/************************************************************/

char *pcl_keyword[NUM_PCL_ENTRIES] =
{
    "&L",    /* paper src, size, orientation, etc. */
    "*B",    /* set raster mode, xfer raster, etc. */
    "*C",    /* font cmds, etc.     */
    "*R",    /* raster graphics cmd */
    "&F",    /* macro cmds, etc     */
    "&K",    /* horiz motion idx    */
    "(S",    /* pointsize, pitch, typeface, etc. */
    "&A",    /* position, margins, via row & col, decipts, etc. */
    "*P",    /* vert, horiz position via dots */
    "*T"     /* graphic resolution */
};





/*********************************/
/*  PostScript keywords, weight  */
/*********************************/

/************************************************/
/*  weights assigned to the ps keywords.        */
/*  Bigger numbers mean more likely it is ps    */
/*  A 1 means normal keyword, not extremely     */
/*  special or meaningful                       */
/************************************************/

/* PS Level one */
PS_KEYWORD_TYPE post_keyword [NUM_PS_ENTRIES] =
{
    {"%!PS-ADOBE",       10},
    {"%%CREATOR",        10},
    {"%%TITLE",          10},
    {"CURRENTFILE",      10},
    {"DICT",             1 },
    {"DEF",              1 },
    {"MOVETO",           1 },
    {"FINDFONT",         1 },
    {"SETFONT",          1 },
    {"SHOWPAGE",         1 },
    {"PIXELSNAP",        10},
    {"LINETO",           1 },
    {"NEWPATH",          1 },
    {"SETGRAY",          1 },
    {"CLOSEPATH",        1 },
    {"STRINGWIDTH",      1 },
    {"DSTACK",           1 },
    {"ESTACK",           1 },
    {"OSTACK",           1 },
    {"DEFINEFONT",       10},
    {"STATUSDICT",       10},
    {"STROKEPATH",       10},
    {"FONTDIRECTORY",    10},
    {"COURIER-BOLD",     1 },
    {"COURIER-OBLIQUE",  1 },
    {"HELVETICA-BOLD",   1 },
    {"SETLINEWIDTH",     10},
    {"SERVERDICT",       10},
    {"TIMES-ITALIC",     1 },
    {"TIMES-ROMAN",      1 },
    {"USERDICT",         10}
};


#ifdef support_ps_level2

/* PS Level two */
PS2_KEYWORD_TYPE post_keyword [NUM_PS2_ENTRIES] =
{
    {"%!PS-ADOBE-3",            10},
    {"COLORIMAGE",              10},
    {"CURRENTBLACKGENERATION",  10},
    {"CURRENTCACHEPARAMS",      10},
    {"CURRENTCMYKCOLOR",        1 },
    {"CURRENTCOLOR",            1 },  /* COVERS 5 DIF CURRENTCOLOR OPERATORS*/
    {"CURRENTDEVPARAMS",        1 },
    {"CURRENTGLOBAL",           1 },
    {"CURRENTGSTATE",           1 },
    {"CURRENTHALFTONE",         1 },
    {"CURRENTOBJECTFORMAT",     10},
    {"CURRENTOVERPRINT",        1 },
    {"CURRENTPACKING",          1 },
    {"CURRENTPAGEDEVICE",       1 },
    {"CURRENTSHARED",           1 },
    {"CURRENTSTROKEADJUST",     1 },
    {"CURRENTSYSTEMPARAMS",     1 },
    {"CURRENTUNDERCOLORREMOVAL",1 },
    {"CURRENTUSERPARAMS",       1 },
    {"DEFINESOURCE",            1 },
    {"DEFINEUSEROBJECT",        1 },
    {"DELETEFILE",              10},
    {"EXECFORM",                10},
    {"EXECUSEROBJECT",          10},
    {"FILENAMEFORALL",          1 },
    {"FILEPOSITION",            1 },
    {"FINDENCODING",            1 },
    {"FINDRESOURCE",            1 },
    {"GCHECK",                  10},
    {"GLOBALDICT",              1 },
    {"GLOBALFONTDIRECTORY",     1 },
    {"GLYPHSHOW",               1 }
    {"GSTATE",                  1 }
    {"INEOFILL",                1 }
    {"INFILL",                  1 }
    {"INSTROKE",                1 }
    {"INUEOFILL",               1 }
    {"INUFILL",                 1 }
    {"INUSTROKE",               1 }
    {"LANGUAGELEVEL",           1 }
    {"PRINTOBJECT",             1 }
    {"RECTCLIP",                1 }
    {"RECTFILL",                1 }
    {"RECTSTROKE",              1 }
    {"RESOURCEFORALL",          1 }
    {"RESOURCESTATUS",          1 }
    {"ROOTFONT",                1 }
    {"SETBLACKGENERATION",      1 }
    {"SETCACHEDEVICE2",         1 }
    {"SETCACHEPARAMS",          1 }
    {"SETCMYKCOLOR",            1 }
    {"SETCOLOR",                1 } /* covers 5 setcolor operators */
    {"SETDEVPARAMS",            1 }
    {"SETOBJECTFORMAT",         1 }
    {"SETPAGEDEVICE",           1 }
    {"SETSTROKEADJUST",         1 }
    {"SETSYSTEMPARAMS",         1 }
    {"SHAREDICT",               1 }
    {"SHAREDFONTDIRECTORY",     1 }
    {"UNDEFINEFONT",            1 }
    {"UNDEFINERESOURCE",        1 }
    {"UNDEFINEUSEROBJECT",      1 }
    {"VMRECLAIM",               1 }
    {"WRITEOBJECT",             1 }
};

#endif     /*  support_ps_level2 */

