/*
 * Copyright Digital Products, Inc.. All Rights Reserved. 
 *
 * psfilter
 *
 * This filter is capable of distinguishing between ASCII, Postscript and PCL.
 * Postscript and PCL jobs are sent to the printer "as is". ASCII is 
 * translated as follows: CR is added to all LF. 
 */ 

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include "recognize.h"

#define SIZEOF_XMIT_BUF 1024

char	xmit_buf[SIZEOF_XMIT_BUF];
char	upper_buf[SIZEOF_XMIT_BUF];

void	sig_handler() ;
extern int recognize(/* char *xmit_buf */);
extern int make_uppercase (/* char *src_buf, int buf_len, char *dest_buf */);

main(argc,argv)
int argc;
char *argv[];
{
int	chars=0;
int	type=0, initial=1;
	
#ifdef DEBUG
        fprintf(stderr," entering infilter\n");

	while (argc--) {

		fprintf( stderr, "\t'%s'\n", *argv++ ) ;
	}
#endif

	signal( SIGPIPE, sig_handler ) ;
	signal( SIGHUP, sig_handler ) ;
	signal( SIGINT, sig_handler ) ;

	while ((chars = getbuf()) > 0)
	{
		if (initial)
		{
			make_uppercase(xmit_buf, chars, upper_buf);

			type = recognize(upper_buf);

			initial = 0;
		}

		putbuf(chars, type);
	}

        if (type == ASCII_JOB)
        {
		putchar('\f');
        }
        else if (type == PCL_JOB)
        {
		putchar(27);               /* ESC */
		putchar('E');              /* E   */
        }
        else if (type == POSTSCRIPT_JOB)
        {
		putchar(4);                /* EOT */
        }
        else if (type == OTHER_JOB)
        {
		putchar('\f');
        }
 
#ifdef DEBUG
        fprintf(stderr," exiting infilter\n");
#endif
	exit( 0 ) ;
}


int getbuf()

{

int	c, count=0;

	while ((count < SIZEOF_XMIT_BUF) && (c = getchar()) != EOF) 
        {
		xmit_buf[count++] = c;
	}


	return(count);

}


int putbuf(chars, type)
int	chars;
int	type;

{
int	i=0, j, col=0;

	if (type == ASCII_JOB)
	{
		for (i = 0; i < chars; i++)
		{
			if (xmit_buf[i] == '\n')
				putchar('\r');

			putchar(xmit_buf[i]);
		}
	}
	else
	{
		for (i = 0; i < chars; i++)
			putchar(xmit_buf[i]);
	}
}



void sig_handler() {

;
}

