/* 
 * Copyright Digital Products, Inc. 1993. All Rights Reserved. 
 *
 *
 * DPI_PRINT.C This program opens a named pipe and transfers print
 * data to a network socket. 
 */


#include <stdio.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

char	*prog_name ;

char	*tty_arg ;
char	*host_arg ;
char	*port_arg ;
int	port_num ;

struct sockaddr_in	 saddr;

int	tty_fd ;
int	print_fd ;

char	buf[512] ;
int	read_size ;
int	write_size ;


void	sigpipe_handler() ;

main( argc, argv )
int	argc;
char	*argv[];
{

	prog_name = argv[0] ;

	if ( argc != 4 ) {

		usage() ;
	}


	tty_arg = argv[1] ;
	host_arg = argv[2] ;
	port_arg = argv[3] ;

	port_num = atoi( port_arg ) ;

	signal( SIGPIPE, sigpipe_handler ) ;

	open_tty() ;

	read_size = read( tty_fd, buf, 512 ) ;

	if ( read_size < 0 ) {
		perror( "read1" ) ;
	}

	get_host_data() ;

	open_printer() ;

	while( 1 ) {

		while( 1 ) {

			write_size = write( print_fd, buf, read_size ) ;

			if ( write_size <= 0 ) {

				perror( "write" ) ;
				close( print_fd ) ;

				open_printer() ;
				continue ;
			}

			read_size = read( tty_fd, buf, 512 ) ;

			if ( read_size <= 0 ) {
				break ;
			}

		}

		close( tty_fd ) ;
		close( print_fd ) ;

		open_tty() ;

		read_size = read( tty_fd, buf, 512 ) ;

		if ( read_size < 0 ) {
			perror( "read2" ) ;
		}

		sleep( 5 ) ;
		open_printer() ;
	}
}


open_tty() {

	tty_fd = open( tty_arg, O_RDONLY ) ;

	if ( tty_fd < 0 ) {

		perror( "can't open tty" ) ;
		exit( 1 ) ;
	}
}
	


int open_printer() {
extern int errno ;
int tries=1, notify=0;

	while( 1 ) {

		if ( (print_fd = socket(AF_INET, SOCK_STREAM, 0)) <0 ) {
			perror( "can't get socket" );
			exit(-1);
		}

		if ( connect( print_fd,
			     (struct sockaddr *) &saddr, sizeof(saddr) ) < 0) {

                        if (tries % 10 == 0)
			{
                            fprintf( stderr, "%s still trying to connect to %s after %d tries\n", tty_arg, host_arg, tries) ;
			}

                        close( print_fd ) ;
                        tries++;
                        notify++;
			sleep( 5 ) ;
		}
		else {
			if (notify)
			    fprintf(stderr,"Connection established (%s -> %s)\n", tty_arg, host_arg);
			break ;
		}
	}

}

get_host_data() {

struct hostent		 *host_ptr;
int                      i;
char                     *src, *dest;

	if ( ( host_ptr = gethostbyname( host_arg ) ) == NULL ) {
		fprintf( stderr, "can't find host %s\n", host_arg ) ;

	}

	/* bzero( (char *) &saddr, sizeof(saddr));                 */
        src = (char *)&saddr;
        for (i=0; i < sizeof(saddr); i++)
           *src++ = 0;

	saddr.sin_family	= AF_INET;
	saddr.sin_port		= htons(port_num);

	/*  bcopy( host_ptr->h_addr, (char *)&saddr.sin_addr, 
                   host_ptr->h_length ) ;                          */
        src = (char *)host_ptr->h_addr_list[0];
        dest = (char *)&saddr.sin_addr;

        for (i=0; i < host_ptr->h_length; i++)
           *dest++ = *src++;
}


usage() {

	fprintf( stderr,
		"usage: %s <tty or pipe> <host> <port>\n",
		 prog_name
	) ;

	exit( 1 ) ;
}



void sigpipe_handler() {

	fprintf( stderr, "SIGPIPE\n" ) ;
}










