/*
 * Copyright Digital Products, Inc.. All Rights Reserved. 
 *
 * psbanner 
 *
 * This filter reads an ASCII banner page from its standard input, converts
 * it to postscript and handles STOP/START signals from the print system 
 *
 */ 

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>

main(argc,argv)
int argc;
char *argv[];
{
int	c ;
int	pid ;
int	fcntl_flags ;
int	banner_done=0;

	pid = getpid() ;

#ifdef DEBUG
	fprintf( stderr, "\n\n<<<out filter start pid: %d args:\n", pid ) ;

	fcntl_flags = fcntl( fileno( stdout ), F_GETFL, 0 ) ;

	fprintf( stderr, "fcntl = %010o O_NDELAY = %s NONBLOCK = %s\n",
			fcntl_flags,
			(fcntl_flags & O_NDELAY) ? "ON" : "OFF",
			(fcntl_flags & O_NONBLOCK) ? "ON" : "OFF"
	) ;

	fcntl_flags = fcntl( fileno( stdout ), F_SETFL, 0 ) ;

	while (--argc) {

		fprintf( stderr, "\t'%s'\n", *argv++ ) ;
	}

	fprintf( stderr, "\nout DATA:\n" ) ;

#endif
	while ( (c = getchar()) != EOF) {

		if ( c == '\n' ) {
			if (!banner_done)
			{
				pspreamble();
				banner_done = 1;
			}

			putchar( '\r' ) ;
			putchar( '\n' ) ;
			continue ;
		}

		if ( c == '\031' ) {

			c = getchar() ;

			if ( c == '\n' ) {
				putchar( '\r' ) ;
				putchar( '\n' ) ;
				continue ;
			}

			if ( c == '\001' ) {
				if (banner_done)
				{
					putchar( 4 ) ;
					banner_done = 0;
				}

#ifdef DEBUG
				fprintf( stderr, "\nSTOP\n" ) ;
#endif
				fflush( stdout ) ;

				(void) kill(getpid(), SIGSTOP);
#ifdef DEBUG
				fprintf( stderr, "\nSTART\n" ) ;
#endif
				continue ;
			}

			putchar( '\031' ) ;
			putchar( c ) ;
#ifdef DEBUG
			fprintf( stderr, "\nFalse stop\n" ) ;
#endif
			continue ;
		}

		if ((c >= 32 ) && (c <= 127) && (!banner_done))
		{
			pspreamble();
			banner_done = 1;
		}

		if ( putc(c, stdout) == EOF ) {
			perror( "OUT error" ) ;
			break ;
		}

#ifdef DEBUG
		if ((c >= 32 ) && (c <= 127))
 			putc( c, stderr );
#endif
	}

#ifdef DEBUG
	fprintf( stderr, "END out filter end pid: %d\n", pid ) ;
#endif

	exit( 0 ) ;
}




dump(buf)
char *buf;
{
	int i;

	for (i=0; i < strlen(buf); i++)
	   putchar(buf[i]);
}


pspreamble()

{
        char buf[80];

#ifdef DEBUG
	fprintf( stderr, "Sending postscript preamble\n") ;
#endif
        sprintf (buf, "/printloop{{currentfile cvlit =string readline not {exit} if\n");
        dump(buf);

        sprintf (buf, "show currentpoint exch pop\n");
        dump(buf);

        sprintf (buf, "10.5 sub dup 36 le {pop showpage 72 730 moveto}\n");
        dump(buf);

        sprintf (buf, "{72 exch moveto} ifelse} loop showpage}\n");
        dump(buf);

        sprintf (buf, "bind def /Courier findfont 11 scalefont setfont\n");
        dump(buf);

        sprintf (buf, "72 730 moveto printloop\n");
        dump(buf);
}


