
/*
 * tcp_cnfg.h - This file contains the definition for the structure which
 *		holds the configurable parameters for the TCP/IP based
 *		system.
 *
 * History: 
 *
 *    11/19/93 NLL Added Serial Port constants and structures.
 *
 *    11/29/94 RMT Added 57600, 76800, 115200 baud rate initializing and removed *             1200 baud.
 */

/* 
 * The following serial constants were taken from SERL_DEF.H.
 * If they change in SERL_DEFS.H (taken from file dated 2/4/93),
 * those changes should also be copied here.
 */

#define TRUE 1
#define FALSE 0

#define MAX_TCP_PRINTERS 4


/*
 * Serial port baud rate equates.
 */

/* #define BAUD_1200  0x00 */
#define BAUD_2400  0x01
#define BAUD_4800  0x02
#define BAUD_9600  0x03
#define BAUD_19200 0x04
#define BAUD_38400 0x05
#define BAUD_57600 0x06
#define BAUD_76800 0x07
#define BAUD_115200 0x08

/*
 * Serial parity constants.
 */

#define NO_PARITY   0x10
#define ODD_PARITY  0x04
#define EVEN_PARITY 0x00

/*
 * Serial data bit constants.
 */

#define DATA_BITS_5  0x00
#define DATA_BITS_6  0x01
#define DATA_BITS_7  0x02
#define DATA_BITS_8  0x03

/*
 * Serial stop bit constants for 5 bits or 6 - 8 bits.
 */

#define STOP_BITS_5_1      0x00
#define STOP_BITS_5_1_5    0x07
#define STOP_BITS_5_2      0x0F
#define STOP_BITS_6_8_1    0x07
#define STOP_BITS_6_8_1_5  0x08
#define STOP_BITS_6_8_2    0x0F

/*
 * Serial stop bit equates
 */

#define STOP_BITS_1    0x01
#define STOP_BITS_1_5  0x02
#define STOP_BITS_2    0x03

/*
 *
 * This is our own version of Serial configuration type.
 * We have added a filler byte so that all non-character fields
 * start on even boundaries.
 *
 * Note that if the corresponding SERL_CONFIG_TYPE structure (in
 * serl_defs.h) changes, that those changes also need to be made here.
 *
 */

typedef struct
{
    long   baud_rate;          /* baud rate for port (not divisor) */
    char   data_bits;          /* # of data bits (5 - 8) */
    char   stop_bits;          /* see #defines */
    char   parity;             /* see #defines */
    char   filler1;    
    short ready_busy_enabled; /* set if ready busy handshaking enabled */
    short xon_xoff_enabled;   /* set if xon/xoff handshaking enabled */
    unsigned short soj_size;            /* size in bytes of soj string */
    char soj_data[64]; /* Actual eoj message */
    unsigned short eoj_size;            /* size in bytes of eoj string */
    char eoj_data[64]; /* Actual eoj message */
    short version;              /* config version # to show config has changed */
} NSC_SERL_CONFIG_TYPE;

typedef struct tcp_cnfg {
	unsigned long ip_addr;
	unsigned long subnet_mask;
	char forw_bdcast;
	char trailers;
	unsigned long base_port_number;
	char keepalive;
	short mtu;
	char broadcast;
	char sysDescr[80];
	char sysObjectID[33];
	char ether;
	unsigned long default_router_ip;
	char banners;
	char printer_pdl_mask[MAX_TCP_PRINTERS];
	char pwrstatus;
} tcp_cnfg_t;



#define NSC_NUM_SERL_ITEMS 6
/*
typedef void (*NSC_GET_SERIAL_ITEM_FUNCTION) (char *, SERL_CONFIG_TYPE *);
*/
typedef void (*NSC_GET_SERIAL_ITEM_FUNCTION) ();




#define NSC_NUM_LEGAL_BAUD_RATES 8
typedef struct
{
        long baud_rate;
        char baud_code;
} NSC_LEGAL_BAUD_RATE_TYPE;







#define NSC_NUM_DATA_BIT_CHOICES 4
typedef struct
{
        char num_bits;
        char num_bit_code;
} NSC_DATA_BIT_CHOICE;




#define NSC_NUM_STOP_BIT_CHOICES 3
typedef struct
{
        char *num_stop_bits_string;
        char stop_bit_code;
} NSC_STOP_BIT_CHOICE;



#define NUM_PARITY_CHOICES 3
typedef struct
{
        char *parity_string;
        char parity_code;
} NSC_PARITY_CHOICE;

#define NSC_ENABLED_STRING "ENABLED"
#define NSC_DISABLED_STRING "DISABLED"

#define NO_CHAR 'N'
#define YES_CHAR 'Y'

#define NSC_SERIAL_IN  0
#define NSC_SERIAL_OUT 1

#define IN_STRING "IN"
#define OUT_STRING "OUT"
