#! /bin/sh
#
# upd.MC -- Update old Management Client (MC) variables to the current version
#
# @(#)upd.MC	1.3	LPS_UNX_COM	02/19/95
#
# Copyright 1995   Digital Equipment Corporation, Maynard, MA
#
# This script must be "imported" into a running shell via the "." command.
#
# It is assumed that all pertinent MC_xxx variables have already been
# setup before this script is invoked, as well these variables:
#
#    ABORT
#    LPSDEBUG
#    OLDLPSVERSION
#    OSTYPE
#
# The MC_xxx variables should already be set to the "old" values, and all
# ENV_xxx variables should be updated to the new version and available.
###

if [ "$LPSDEBUG" ]
then
    set | egrep "^MC_.*=" > /tmp/MC.vars.before
fi

# Change all variables that should/must be updated regardless of
# the prior version.

#  --none--


# Change all variables that depend on the prior version

case "$OLDLPSVERSION" in
    "40" | "41" | "42") : # All LPS versions prior to V5.0
	#
	# Change all variables that are INDEPENDENT of the platform type
	#

	MC_DESCRIPTION="`getobjdesc MC` for `getobjdesc PS` $MC_PSNAME"

	#
	# Change all variables that are DEPENDENT on the platform type
	#
	if [ $OSTYPE = BSD -o $OSTYPE = OSF1 ]
	then
	    if [ "$MC_LOGFILE" ]
	    then
		MC_ENABLELOG=Yes
	    fi
	fi
	;;

    "50") : # All LPS versions at V5.0
	#
	# There are no changes in any kits in going from 5.0 to 5.1,
	# except for those mentioned in the above section for variables
	# that are new for any platform type.
	#
	;;

    * ) echo
	echo "    Unexpected old LPS version:  \"$OLDLPSVERSION\""
	$ABORT
	;;
esac

if [ "$LPSDEBUG" ]
then
    set | egrep "^MC_.*=" > /tmp/MC.vars.after
fi
