#
# Platform-specific variable settings for Solaris platforms
#

PATH="${PATH}:/var/opt/SUNWmotif/bin:/usr/ucb"

ACCTUNIT=job
BOOTABENTRY='td=${ENV_LPSBOOT}:  bf=${PS_BOOTFILE}:'
DAEMONUID=lp
ECHON="/usr/ucb/echo -n"
LPSACCT=/usr/adm
LPSLOG=/usr/adm/log
MAILPROG=/usr/bin/mailx
MAILOPTS="-i -n"
MAILSTYLE=RFC822
MANROOT=/usr/man
MANSECTYPE=BSD
NEEDACCT=true
NEEDNOBANNER=true
NEEDPCACCT=false
OSNAME=Solaris
OSTYPE=SV4
PCTYPE=SV3
PLATFORM="`/usr/ucb/mach | tr [a-z] [A-Z]`"
PSA="ps -ef"
PSPID="ps -p"
ROOTUID=root
TOPQDIR=/usr/spool/lp/requests
TR=/usr/bin/tr
WHOAMI="`whoami`"
X11APPDEFS=/usr/openwin/lib/app-defaults
X11UIDS=/opt/SUNWmotif/lib/uid

# This LD_LIBRARY_PATH is required to build xlpsrc on SOLARIS systems.
# Without this definition the -lXmu (libXmu.a) library cannot be found.

LD_LIBRARY_PATH="/usr/openwin/lib:${LD_LIBRARY_PATH}"

# Special hack to convert "SunOS 5.x" format to "Solaris 2.x" format
# for the actual operating system version string

ver1=`uname -r | cut -c1`
ver2=`uname -r | cut -c2-`
if [ "$ver1" -ge 5 ]
then
    ver=`expr $ver1 - 5 + 2`
fi
OSVER="${ver}${ver2}"

unset ver1
unset ver2
