#
# Awk script used to parse a PrintServer printer configuration file.
#
# @(#)parsecfg.awk	1.2	LPS_UNX_COM	9/12/94
#
BEGIN {
    if (cfile == "") cfile = "/dev/tty"   # Where community stuff goes
    if (tfile == "") tfile = "/dev/tty"   # Where trap stuff goes
}

/^[ \t]*#/ { next }  # Skip comment lines
/^$/       { next }  #    and blank lines

{
    if ($1 == "community")
    {
	if ($2 == "") next               ; else name   = $2
	if ($3 == "") ipaddr = "0.0.0.0" ; else ipaddr = $3
	if ($4 == "") access = "read"    ; else access = $4

	print name, ipaddr, access > cfile

	if (length(values["COMMUNITIES"]) == 0)   # Only do this once
	{
	    names["COMMUNITIES"]  = "COMMUNITIES"
	    values["COMMUNITIES"] = cfile
	}
    }
    else if ($1 == "trap")
    {
	if ($2 == "" || $3 == "") { next }

	print $2, $3 > tfile

	if (length(values["TRAPS"]) == 0)   # Only do this once
	{
	    names["TRAPS"]  = "TRAPS"
	    values["TRAPS"] = tfile
	}
    }
    else
    {
	name  = $1
	value = $2

	if (name == "password")
	{
	    value = substr(value, 2, length(value)-2)
	}
	else if (name == "syslocation")
	{
	    value = substr($0, 13, 256)
	}
	else if (name == "syscontact")
	{
	    value = substr($0, 12, 256)
	}
	else if (name == "option")
	{
	    if (value == "snmp")
	    {
		name  = "enablesnmp"
		value = "on"
	    }

	    if (value == "image")
	    {
		name  = "enableimage"
		value = "on"
	    }
	}

	if (length(values[name]) > 0)
	{
	    values[name] = values[name] " "
	}
	values[name] = values[name] value
	names[name]  = name

    }
}

END {
    for (i in names)
    {
	# Standard awk doesn't (usually) have a toupper() function, so we
	# must manually do that task here...

	keyword = names[i]	# Default mapping is "straight thru"

	if      (names[i] == "accounting")            keyword = "ACCOUNTING"
	else if (names[i] == "allowdn")               keyword = "ALLOWDN"
	else if (names[i] == "allowip")               keyword = "ALLOWIP"
	else if (names[i] == "denydn")                keyword = "DENYDN"
	else if (names[i] == "denyip")                keyword = "DENYIP"
	else if (names[i] == "enableimage")           keyword = "ENABLEIMAGE"
	else if (names[i] == "enablesnmp")            keyword = "ENABLESNMP"
	else if (names[i] == "snmpenableauthentraps") keyword = "ENABLETRAPS"
	else if (names[i] == "gateway")               keyword = "GATEWAY"
	else if (names[i] == "language")              keyword = "LANGUAGE"
	else if (names[i] == "logging")               keyword = "LOGGING"
	else if (names[i] == "password")              keyword = "PASSWORD"
	else if (names[i] == "printername")           keyword = "PRINTERNAME"
	else if (names[i] == "subnetmask")            keyword = "SUBNETMASK"
	else if (names[i] == "syslocation")           keyword = "SYSLOCATION"
	else if (names[i] == "syscontact")            keyword = "SYSCONTACT"

	printf "PS_%s=\"%s\"\n", keyword, values[names[i]]
    }
}
