/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css;

/**
 * This interface represents elements which are able to compute their
 * base URI.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: ElementWithBaseURI.java,v 1.1 2001/10/17 14:47:26 hillion Exp $
 */
public interface ElementWithBaseURI {
    
    /**
     * Returns this element's base URI. Must be absolute.
     */
    String getBaseURI();
}
