/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css;

import org.w3c.dom.Element;

/**
 * This interface allows an element to be considered as the child
 * of another element without being added to the DOM tree.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: HiddenChildElement.java,v 1.4 2001/10/18 12:30:22 hillion Exp $
 */
public interface HiddenChildElement {
    /**
     * The parent element of this element.
     */
    Element getParentElement();

    /**
     * Sets the parent element of this element.
     */
    void setParentElement(Element elt);

    /**
     * Gets the style of this element.
     */
    CSSOMReadOnlyStyleDeclaration getStyleDeclaration();

    /**
     * Sets the style of this element.
     */
    void setStyleDeclaration(CSSOMReadOnlyStyleDeclaration sd);
}
