/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css.event;

/**
 * This interface must be implemented by the objects that want to be
 * notified of CSS properties changes.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: CSSPropertyChangeListener.java,v 1.1.1.1 2000/10/10 18:37:22 hillion Exp $
 */

public interface CSSPropertyChangeListener {
    /**
     * Called when a CSS property is changed.
     */
    void cssPropertyChange(CSSPropertyChangeEvent evt);
}
