/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css.parser;

import org.w3c.css.sac.Condition;

/**
 * This class provides an implementation of the
 * {@link org.w3c.css.sac.CombinatorCondition} interface.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: DefaultAndCondition.java,v 1.1 2002/02/20 12:53:21 hillion Exp $
 */
public class DefaultAndCondition extends AbstractCombinatorCondition {

    /**
     * Creates a new CombinatorCondition object.
     */
    public DefaultAndCondition(Condition c1, Condition c2) {
	super(c1, c2);
    }

    /**
     * <b>SAC</b>: Implements {@link
     * org.w3c.css.sac.Condition#getConditionType()}.
     */    
    public short getConditionType() {
	return SAC_AND_CONDITION;
    }

    /**
     * Returns a text representation of this object.
     */
    public String toString() {
	return "" + getFirstCondition() + getSecondCondition();
    }
}
