/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css.parser;

/**
 * This class implements the {@link org.w3c.css.sac.ElementSelector} interface.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: DefaultPseudoElementSelector.java,v 1.1 2002/02/20 12:53:21 hillion Exp $
 */
public class DefaultPseudoElementSelector extends AbstractElementSelector {
    /**
     * Creates a new ElementSelector object.
     */
    public DefaultPseudoElementSelector(String uri, String name) {
	super(uri, name);
    }

    /**
     * <b>SAC</b>: Implements {@link
     * org.w3c.css.sac.Selector#getSelectorType()}.
     */
    public short getSelectorType() {
	return SAC_PSEUDO_ELEMENT_SELECTOR;
    }

    /**
     * Returns a representation of the selector.
     */
    public String toString() {
	return ":" + getLocalName();
    }
}
