/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css.svg;

import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractIdentifierFactory;
import org.apache.batik.css.value.ImmutableString;
import org.apache.batik.css.value.ImmutableValue;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSPrimitiveValue;

/**
 * This class provides a factory for the 'text-rendering' property values.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: TextRenderingFactory.java,v 1.2 2000/11/27 05:49:06 hillion Exp $
 */
public class TextRenderingFactory
    extends    AbstractIdentifierFactory
    implements SVGValueConstants {

    /**
     * The identifier values.
     */
    protected final static PropertyMap values = new PropertyMap();
    static {
	values.put(CSS_AUTO_VALUE,               AUTO_VALUE);
	values.put(CSS_GEOMETRICPRECISION_VALUE, GEOMETRICPRECISION_VALUE);
	values.put(CSS_OPTIMIZELEGIBILITY_VALUE, OPTIMIZELEGIBILITY_VALUE);
	values.put(CSS_OPTIMIZESPEED_VALUE,      OPTIMIZESPEED_VALUE);
    }

    /**
     * Creates a new TextRenderingFactory object.
     */
    public TextRenderingFactory(Parser p) {
	super(p);
    }

     /**
     * Returns the name of the property handled.
     */
    public String getPropertyName() {
	return CSS_TEXT_RENDERING_PROPERTY;
    }
    
    /**
     * Returns the property map that contains the possible values.
     */
    protected PropertyMap getIdentifiers() {
	return values;
    }
}
