/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.dom.svg;

import org.apache.batik.css.svg.DefaultSVGCSSContext;

/**
 * This class is the placeholder for SVG application informations.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: DefaultSVGContext.java,v 1.7 2002/02/25 15:05:32 hillion Exp $
 */
public class DefaultSVGContext
    extends    DefaultSVGCSSContext
    implements SVGContext {

    /**
     * The pixel to mm conversion factor.
     */
    protected float pixelToMM;

    /**
     * Return the pixel to millimeters factor.
     */
    public float getPixelToMM() {
        return pixelToMM;
    }

    /**
     * Sets the pixel to millimeters factor.
     */
    public void setPixelToMM(float f) {
        pixelToMM = f;
    }
}
