/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.dom.svg;

import org.apache.batik.dom.AbstractDocument;

import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDefinitionSrcElement;

/**
 * This class implements {@link SVGDefinitionSrcElement}.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: SVGOMDefinitionSrcElement.java,v 1.1 2001/09/10 12:26:07 hillion Exp $
 */
public class SVGOMDefinitionSrcElement
    extends    SVGOMElement
    implements SVGDefinitionSrcElement {

    /**
     * Creates a new SVGOMDefinitionSrcElement object.
     */
    protected SVGOMDefinitionSrcElement() {
    }

    /**
     * Creates a new SVGOMDefinitionSrcElement object.
     * @param prefix The namespace prefix.
     * @param owner The owner document.
     */
    public SVGOMDefinitionSrcElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);

    }

    /**
     * <b>DOM</b>: Implements {@link Node#getLocalName()}.
     */
    public String getLocalName() {
        return SVG_DEFINITION_SRC_TAG;
    }

    /**
     * Returns a new uninitialized instance of this object's class.
     */
    protected Node newNode() {
        return new SVGOMDefinitionSrcElement();
    }
}
