/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.dom.svg;

import org.apache.batik.dom.AbstractDocument;

import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedNumber;
import org.w3c.dom.svg.SVGFEPointLightElement;

/**
 * This class implements {@link SVGFEPointLightElement}.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: SVGOMFEPointLightElement.java,v 1.7 2001/09/10 12:26:08 hillion Exp $
 */
public class SVGOMFEPointLightElement
    extends    SVGOMElement
    implements SVGFEPointLightElement {

    /**
     * Creates a new SVGOMFEPointLightElement object.
     */
    protected SVGOMFEPointLightElement() {
    }

    /**
     * Creates a new SVGOMFEPointLightElement object.
     * @param prefix The namespace prefix.
     * @param owner The owner document.
     */
    public SVGOMFEPointLightElement(String prefix,
                                    AbstractDocument owner) {
        super(prefix, owner);
    }

    /**
     * <b>DOM</b>: Implements {@link Node#getLocalName()}.
     */
    public String getLocalName() {
        return SVG_FE_POINT_LIGHT_TAG;
    }

    /**
     * <b>DOM</b>: Implements {@link SVGFEPointLightElement#getX()}.
     */
    public SVGAnimatedNumber getX() {
        throw new RuntimeException("!!! TODO getX()");
    }

    /**
     * <b>DOM</b>: Implements {@link SVGFEPointLightElement#getY()}.
     */
    public SVGAnimatedNumber getY() {
        throw new RuntimeException("!!! TODO getY()");
    }

    /**
     * <b>DOM</b>: Implements {@link
     * org.w3c.dom.svg.SVGFEPointLightElement#getZ()}.
     */
    public SVGAnimatedNumber getZ() {
        throw new RuntimeException("!!! TODO getZ()");
    }

    /**
     * Returns a new uninitialized instance of this object's class.
     */
    protected Node newNode() {
        return new SVGOMFEPointLightElement();
    }
}
