/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.script;

/**
 * An hight level interface that represents a factory allowing
 * to create instances of a particular <code>Interpreter</code> interface
 * implementation.
 * @author <a href="mailto:cjolif@ilog.fr">Christophe Jolif</a>
 * @version $Id: InterpreterFactory.java,v 1.2 2001/01/24 14:50:56 cjolif Exp $
 */
public interface InterpreterFactory {
    /**
     * This method should create an instance of <code>Interpreter</code>
     * interface implementation.
     */
    public Interpreter createInterpreter();
}
