/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.test;

/**
 * Defines the interface of a <tt>TestReport</tt> produced
 * by a <tt>TestSuite</tt>.
 *
 * @author <a href="mailto:vhardy@apache.lorg">Vincent Hardy</a>
 * @version $Id: TestSuiteReport.java,v 1.1 2001/10/04 08:25:36 vhardy Exp $
 */
public interface TestSuiteReport extends TestReport{
    /**
     * Returns an array of children <tt>TestReports</tt> which
     * may be useful for reports generated by <tt>TestSuite</tt> 
     * instances.
     */
    public TestReport[] getChildrenReports();
}
