/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;

import java.util.Map;
import java.util.HashMap;

import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;

/**
 * Test the ImageTranscoder with the KEY_LANGUAGE transcoding hint.
 *
 * @author <a href="mailto:Thierry.Kormann@sophia.inria.fr">Thierry Kormann</a>
 * @version $Id: LanguageTest.java,v 1.1 2001/10/30 14:19:07 tkormann Exp $ 
 */
public class LanguageTest extends AbstractImageTranscoderTest {

    /**
     * Constructs a new <tt>LanguageTest</tt>.
     */
    /** The URI of the input image. */
    protected String inputURI;

    /** The URI of the reference image. */
    protected String refImageURI;

    /** The preferred language. */
    protected String language;

    /**
     * Constructs a new <tt>LanguageTest</tt>.
     *
     * @param inputURI the URI of the input image
     * @param the URI of the reference image
     * @param language the preferred language
     */
    public LanguageTest(String inputURI, 
			String refImageURI, 
			String language) {
	this.inputURI = inputURI;
	this.refImageURI = refImageURI;
	this.language = language;
    }

    /**
     * Creates the <tt>TranscoderInput</tt>.
     */
    protected TranscoderInput createTranscoderInput() {
	return new TranscoderInput(resolveURL(inputURI).toString());
    }
    
    /**
     * Creates a Map that contains additional transcoding hints.
     */
    protected Map createTranscodingHints() {
	Map hints = new HashMap(7);
	hints.put(ImageTranscoder.KEY_LANGUAGE, language);
	return hints;
    }

    /**
     * Returns the reference image for this test.
     */
    protected BufferedImage getReferenceImage() {
	return createBufferedImage(resolveURL(refImageURI));
    }
}
