import java.io.*;
import java.beans.*;
import com.sun.activation.registries.*;
import javax.activation.*;

public class PrefTest {
    MailcapCommandMap mcf = null;
    String file_name = null;

    public static void main(String args[]){
	PrefTest test = new PrefTest();
	
	if(args.length == 0) {
            System.out.println("usage: PrefTest mailcap");
            System.exit(1);
        }

	test.setFile(args[0]);

	test.doit();

    }

    private void setFile(String fname) {
       file_name = fname;
    }

    private void doit() {

	try {
	    mcf = new MailcapCommandMap(file_name);
	} catch(Exception e){ 
	    e.printStackTrace();
	    System.exit(1);
	}
	CommandInfo cmdinfo[] = mcf.getAllCommands("text/plain");
	
	if(cmdinfo != null) {
	    System.out.println("ALL Commands for text/plain:");
	    for(int i = 0; i < cmdinfo.length; i++){
		System.out.println("Verb: " + cmdinfo[i].getCommandName() +
				  " Class: " + cmdinfo[i].getCommandClass());
	    }
	    System.out.println("done.\n\n\n\n\n\n");
	} else {
	    System.out.println("no commands");
	}
	
	cmdinfo = mcf.getPreferredCommands("text/plain");
	if(cmdinfo != null) {
	    System.out.println("PREFERRED Commands for text/plain:");
	    for(int i = 0; i < cmdinfo.length; i++){
		System.out.println("Verb: " + cmdinfo[i].getCommandName() +
				  " Class: " + cmdinfo[i].getCommandClass());
	    }
	    System.out.println("done.\n\n\n\n\n\n");
	} else {
	    System.out.println("no commands");
	}
	
    }
    
}
