/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.awt;

import com.eteks.awt.PJAFontData;
import com.eteks.awt.PJAFontPeer;
import com.eteks.awt.PJAGraphicsExtension;
import com.eteks.awt.PJAGraphicsManager;
import com.eteks.awt.PJAImage;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.peer.FontPeer;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;

public class PJAGraphics
extends Graphics
implements PJAGraphicsExtension {
    private PJAGraphicsManager manager;
    private PJAFont defaultFont;
    private boolean classColorAccessible;
    private boolean classRectangleAccessible;
    private boolean classFontMetricsAccessible;
    private boolean fontInstantiationEnabled;
    PJAImage image;
    Color color;
    int ARGB;
    int ARGBIndex;
    Color XORColor;
    boolean XORMode;
    int XorRGB;
    PJAFontPeer fontPeer;
    PJAFont font;
    String fontName;
    int fontStyle;
    int fontSize;
    int translateX;
    int translateY;
    PJARectangle userClip;
    PJARectangle clip;
    private static final int COLOR_FACTOR_100 = 143;
    private final int[] TAN_0_TO_45_SHIFT_16;

    private PJAGraphics() {
        int[] nArray = new int[46];
        nArray[1] = 1144;
        nArray[2] = 2289;
        nArray[3] = 3435;
        nArray[4] = 4583;
        nArray[5] = 5734;
        nArray[6] = 6888;
        nArray[7] = 8047;
        nArray[8] = 9210;
        nArray[9] = 10380;
        nArray[10] = 11556;
        nArray[11] = 12739;
        nArray[12] = 13930;
        nArray[13] = 15130;
        nArray[14] = 16340;
        nArray[15] = 17560;
        nArray[16] = 18792;
        nArray[17] = 20036;
        nArray[18] = 21294;
        nArray[19] = 22566;
        nArray[20] = 23853;
        nArray[21] = 25157;
        nArray[22] = 26478;
        nArray[23] = 27818;
        nArray[24] = 29179;
        nArray[25] = 30560;
        nArray[26] = 31964;
        nArray[27] = 33392;
        nArray[28] = 34846;
        nArray[29] = 36327;
        nArray[30] = 37837;
        nArray[31] = 39378;
        nArray[32] = 40951;
        nArray[33] = 42560;
        nArray[34] = 44205;
        nArray[35] = 45889;
        nArray[36] = 47615;
        nArray[37] = 49385;
        nArray[38] = 51202;
        nArray[39] = 53070;
        nArray[40] = 54991;
        nArray[41] = 56970;
        nArray[42] = 59009;
        nArray[43] = 61113;
        nArray[44] = 63287;
        nArray[45] = 65536;
        this.TAN_0_TO_45_SHIFT_16 = nArray;
        this.manager = PJAGraphicsManager.getDefaultGraphicsManager();
        this.classColorAccessible = this.manager.isClassAccessible("java.awt.Color");
        this.classRectangleAccessible = this.manager.isClassAccessible("java.awt.Rectangle");
        this.classFontMetricsAccessible = this.manager.isClassAccessible("java.awt.FontMetrics");
        String string = this.manager.getDefaultFont();
        int n = 0;
        int n2 = 10;
        if (string != null) {
            this.fontPeer = (PJAFontPeer)this.manager.getFontPeer(string, 0, true);
            this.fontInstantiationEnabled = this.manager.isFontInstantiable();
            if (this.fontInstantiationEnabled) {
                this.defaultFont = new PJAFont(string, n, n2);
            }
        }
        this.image = null;
        this.color = this.classColorAccessible ? Color.black : null;
        this.ARGB = -16777216;
        this.ARGBIndex = -1;
        this.XORColor = null;
        this.XORMode = false;
        this.XorRGB = 0;
        this.font = this.defaultFont;
        this.fontName = string;
        this.fontStyle = n;
        this.fontSize = n2;
        this.translateX = 0;
        this.translateY = 0;
        this.userClip = null;
        this.clip = null;
    }

    protected PJAGraphics(PJAImage pJAImage) {
        this();
        this.image = pJAImage;
        this.userClip = new PJARectangle(0, 0, pJAImage.getWidth(), pJAImage.getHeight());
        this.clip = new PJARectangle(0, 0, pJAImage.getWidth(), pJAImage.getHeight());
    }

    private PJAGraphics(PJAImage pJAImage, Color color, int n, int n2, Color color2, boolean bl, int n3, PJAFontPeer pJAFontPeer, PJAFont pJAFont, String string, int n4, int n5, int n6, int n7, PJARectangle pJARectangle, PJARectangle pJARectangle2) {
        this();
        this.image = pJAImage;
        this.color = color;
        this.ARGB = n;
        this.ARGBIndex = n2;
        this.XORColor = color2;
        this.XORMode = bl;
        this.XorRGB = n3;
        this.fontPeer = pJAFontPeer;
        this.font = pJAFont;
        this.fontName = string;
        this.fontStyle = n4;
        this.fontSize = n5;
        this.translateX = n6;
        this.translateY = n7;
        this.userClip = pJARectangle;
        this.clip = pJARectangle2;
    }

    public Graphics create() {
        return new PJAGraphics(this.image, this.color, this.ARGB, this.ARGBIndex, this.XORColor, this.XORMode, this.XorRGB, this.fontPeer, this.font, this.fontName, this.fontStyle, this.fontSize, this.translateX, this.translateY, new PJARectangle(this.userClip), new PJARectangle(this.clip));
    }

    public void translate(int n, int n2) {
        this.translateX += n;
        this.translateY += n2;
        this.userClip.x -= n;
        this.userClip.y -= n2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        int n = color.getRGB() | 0xFF000000;
        if (this.image.getColorModel() != null && this.image.getColorModel() instanceof IndexColorModel && (this.ARGB != n || this.ARGBIndex == -1)) {
            this.ARGBIndex = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n) & 0xFF;
        }
        this.ARGB = n;
    }

    public int getColorRGB() {
        return this.ARGB & 0xFFFFFF;
    }

    public void setColor(int n, int n2, int n3) {
        if (this.classColorAccessible) {
            this.setColor(new Color(n, n2, n3));
        } else {
            this.ARGB = (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF | 0xFF000000;
        }
    }

    private int getBrighterColor(int n) {
        int n2 = (n & 0xFF0000) >>> 16;
        int n3 = (n & 0xFF00) >>> 8;
        int n4 = n & 0xFF;
        n2 = Math.min(PJAGraphics.roundDiv(n2 * 143, 100), 255);
        n3 = Math.min(PJAGraphics.roundDiv(n3 * 143, 100), 255);
        n4 = Math.min(PJAGraphics.roundDiv(n4 * 143, 100), 255);
        return (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF | 0xFF000000;
    }

    private int getDarkerColor(int n) {
        int n2 = (n & 0xFF0000) >>> 16;
        int n3 = (n & 0xFF00) >>> 8;
        int n4 = n & 0xFF;
        n2 = Math.min(PJAGraphics.roundDiv(n2 * 100, 143), 255);
        n3 = Math.min(PJAGraphics.roundDiv(n3 * 100, 143), 255);
        n4 = Math.min(PJAGraphics.roundDiv(n4 * 100, 143), 255);
        return (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF | 0xFF000000;
    }

    public void setPaintMode() {
        this.XORColor = null;
        this.XORMode = false;
        this.XorRGB = 0;
    }

    public void setXORMode(Color color) {
        this.XORColor = color;
        this.XORMode = this.XORColor != null;
        this.XorRGB = this.XORMode ? this.XORColor.getRGB() : 0;
    }

    public void setXORMode(int n, int n2, int n3) {
        if (this.classColorAccessible) {
            this.XORColor = new Color(n, n2, n3);
        }
        this.XORMode = true;
        this.XorRGB = (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    private void checkFontLoading() {
        if (this.fontPeer == null) {
            throw new AWTError("No default font : at least one .pjaf font must be loaded.");
        }
    }

    public FontMetrics getFontMetrics() {
        this.checkFontLoading();
        if (this.font != null) {
            return this.fontPeer.getFontMetrics(this.font);
        }
        if (this.classFontMetricsAccessible) {
            return this.fontPeer.getFontMetrics(this.fontSize);
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.manager.getFontMetrics(this.getPJAFont(font), true);
    }

    public int getFontLeading() {
        this.checkFontLoading();
        return this.fontPeer.getFontData(this.fontSize).getLeading();
    }

    public int getFontAscent() {
        this.checkFontLoading();
        return this.fontPeer.getFontData(this.fontSize).getAscent();
    }

    public int getFontDescent() {
        this.checkFontLoading();
        return this.fontPeer.getFontData(this.fontSize).getDescent();
    }

    public int getFontMaxAscent() {
        this.checkFontLoading();
        return this.fontPeer.getFontData(this.fontSize).getMaxAscent();
    }

    public int getFontMaxDescent() {
        this.checkFontLoading();
        return this.fontPeer.getFontData(this.fontSize).getMaxDescent();
    }

    public int getFontMaxAdvance() {
        this.checkFontLoading();
        return this.fontPeer.getFontData(this.fontSize).getMaxAdvance();
    }

    public int getCharWidth(char c) {
        this.checkFontLoading();
        return this.fontPeer.getFontData(this.fontSize).getCharWidth(c);
    }

    public int getStringWidth(String string) {
        this.checkFontLoading();
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return this.fontPeer.getFontData(this.fontSize).getCharsWidth(cArray, 0, n);
    }

    public Font getFont() {
        this.checkFontLoading();
        return this.font;
    }

    public String getFontName() {
        this.checkFontLoading();
        return this.fontName;
    }

    public int getFontStyle() {
        this.checkFontLoading();
        return this.fontStyle;
    }

    public int getFontSize() {
        this.checkFontLoading();
        return this.fontSize;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.fontPeer = (PJAFontPeer)this.manager.getFontPeer(font.getName(), font.getStyle(), true);
            this.fontSize = font.getSize();
            this.fontStyle = font.getStyle();
            this.fontName = font.getName();
        }
        this.font = this.getPJAFont(font);
    }

    public void setFont(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("Font name can't be null, use \"\" for default");
        }
        if (this.fontInstantiationEnabled) {
            this.setFont(new Font(string, n, n2));
        } else {
            this.fontPeer = (PJAFontPeer)this.manager.getFontPeer(string, n, true);
            this.fontName = string;
            this.fontStyle = n;
            this.fontSize = n2;
            this.font = null;
        }
    }

    private PJAFont getPJAFont(Font font) {
        if (font == null || font instanceof PJAFont) {
            return (PJAFont)font;
        }
        if (this.fontInstantiationEnabled) {
            return new PJAFont(font.getName(), font.getStyle(), font.getSize());
        }
        return null;
    }

    public Rectangle getClipBounds() {
        if (!this.classRectangleAccessible) {
            return null;
        }
        return new Rectangle(this.userClip.x, this.userClip.y, this.userClip.width, this.userClip.height);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.userClip = this.userClip.intersection(new PJARectangle(n, n2, n3, n4));
        this.clip = this.clip.intersection(new PJARectangle(n + this.translateX, n2 + this.translateY, n3, n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.userClip = new PJARectangle(-this.translateX, -this.translateY, this.image.getWidth(), this.image.getHeight());
        this.clip = new PJARectangle(0, 0, this.image.getWidth(), this.image.getHeight());
        this.clipRect(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public void setClip(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        n2 += this.translateY;
        int n7 = n += this.translateX;
        int n8 = n + n3 - 1;
        int n9 = 1;
        if (n5 < 0) {
            n7 = n + n3 - 1;
            n8 = n;
            n9 = -1;
        }
        int n10 = n2;
        int n11 = n2 + n4 - 1;
        int n12 = 1;
        if (n6 < 0) {
            n10 = n2 + n4 - 1;
            n11 = n2;
            n12 = -1;
        }
        PJAImage pJAImage = this.image;
        synchronized (pJAImage) {
            Object object = this.image.getPixelsArray();
            if (object != null) {
                int n13 = this.image.getWidth();
                int n14 = this.image.getHeight();
                if (object instanceof int[]) {
                    int[] nArray = (int[])object;
                    n = n7;
                    while (n <= n8) {
                        n2 = n10;
                        while (n2 <= n11) {
                            if (!this.isClipped(n + n5, n2 + n6) && n >= 0 && n < n13 && n2 >= 0 && n2 < n14) {
                                nArray[n + n5 + (n2 + n6) * n13] = nArray[n + n2 * n13];
                            }
                            n2 += n12;
                        }
                        n += n9;
                    }
                } else {
                    byte[] byArray = (byte[])object;
                    n = n7;
                    while (n <= n8) {
                        n2 = n10;
                        while (n2 <= n11) {
                            if (!this.isClipped(n + n5, n2 + n6) && n >= 0 && n < n13 && n2 >= 0 && n2 < n14) {
                                byArray[n + n5 + (n2 + n6) * n13] = byArray[n + n2 * n13];
                            }
                            n2 += n12;
                        }
                        n += n9;
                    }
                }
            }
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        int n5 = (n3 += this.translateX) - (n += this.translateX);
        int n6 = (n4 += this.translateY) - (n2 += this.translateY);
        PJAImage pJAImage = this.image;
        synchronized (pJAImage) {
            if (n5 == 0) {
                if (n2 < n4) {
                    this.drawVerticalLine(n, n2, n4);
                } else {
                    this.drawVerticalLine(n, n4, n2);
                }
            } else if (n6 == 0) {
                if (n < n3) {
                    this.drawHorizontalLine(n, n3, n2);
                } else {
                    this.drawHorizontalLine(n3, n, n2);
                }
            } else {
                int n7;
                int n8;
                boolean bl = false;
                int n9 = 1;
                int n10 = 1;
                boolean bl2 = false;
                if (Math.abs(n6) > Math.abs(n5)) {
                    n8 = n;
                    n = n2;
                    n2 = n8;
                    n8 = n3;
                    n3 = n4;
                    n4 = n8;
                    n5 = n3 - n;
                    n6 = n4 - n2;
                    bl = true;
                }
                if (n > n3) {
                    n8 = n;
                    n = n3;
                    n3 = n8;
                    n8 = n2;
                    n2 = n4;
                    n4 = n8;
                    n5 = n3 - n;
                    n6 = n4 - n2;
                }
                if (n6 * n5 < 0) {
                    if (n6 < 0) {
                        n10 = -1;
                        n9 = 1;
                    } else {
                        n10 = 1;
                        n9 = -1;
                    }
                    bl2 = true;
                }
                n8 = 2 * (n6 * n10) - n5 * n9;
                int n11 = 2 * n6 * n10;
                int n12 = 2 * (n6 * n10 - n5 * n9);
                int n13 = n;
                int n14 = n2;
                int n15 = n13;
                int n16 = n14;
                if (bl) {
                    n7 = n13;
                    n13 = n14;
                    n14 = n7;
                }
                this.drawPoint(n13, n14);
                n13 = n15;
                n14 = n16;
                while (n13 < n3) {
                    if (n8 <= 0) {
                        n8 += n11;
                    } else {
                        n8 += n12;
                        ++n13;
                        if (bl2) {
                            --n14;
                        }
                    }
                    n15 = ++n13;
                    n16 = ++n14;
                    if (bl) {
                        n7 = n13;
                        n13 = n14;
                        n14 = n7;
                    }
                    this.drawPoint(n13, n14);
                    n13 = n15;
                    n14 = n16;
                }
            }
        }
    }

    private boolean isClipped(int n, int n2) {
        return n < this.clip.x || n >= this.clip.x + this.clip.width || n2 < this.clip.y || n2 >= this.clip.y + this.clip.height;
    }

    private void drawPoint(int n, int n2) {
        Object object;
        if (!this.isClipped(n, n2) && (object = this.image.getPixelsArray()) != null) {
            int n3 = n + n2 * this.image.getWidth();
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                nArray[n3] = this.XORMode ? 0xFF000000 | nArray[n3] ^ this.ARGB ^ this.XorRGB : this.ARGB;
            } else {
                byte[] byArray = (byte[])object;
                if (this.XORMode) {
                    int n4 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), byArray[n3] & 0xFF);
                    int n5 = 0xFF000000 | n4 ^ this.ARGB ^ this.XorRGB;
                    byArray[n3] = (byte)this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n5);
                } else {
                    byArray[n3] = this.ARGBIndex != -1 ? (byte)this.ARGBIndex : (byte)0;
                }
            }
        }
    }

    private void drawHorizontalLine(int n, int n2, int n3) {
        block13: {
            Object object;
            if (n3 < this.clip.y || n3 >= this.clip.y + this.clip.height || (object = this.image.getPixelsArray()) == null) break block13;
            int n4 = n3 * this.image.getWidth();
            int n5 = Math.max(n, this.clip.x) + n4;
            int n6 = Math.min(n2, this.clip.x + this.clip.width - 1) + n4;
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                if (this.XORMode) {
                    int n7 = n5;
                    while (n7 <= n6) {
                        nArray[n7] = 0xFF000000 | nArray[n7] ^ this.ARGB ^ this.XorRGB;
                        ++n7;
                    }
                } else {
                    int n8 = n5;
                    while (n8 <= n6) {
                        nArray[n8] = this.ARGB;
                        ++n8;
                    }
                }
            } else {
                byte[] byArray = (byte[])object;
                if (this.XORMode) {
                    int n9 = n5;
                    while (n9 <= n6) {
                        int n10 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), byArray[n9] & 0xFF);
                        int n11 = 0xFF000000 | n10 ^ this.ARGB ^ this.XorRGB;
                        byArray[n9] = (byte)this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n11);
                        ++n9;
                    }
                } else if (this.ARGBIndex != -1) {
                    int n12 = n5;
                    while (n12 <= n6) {
                        byArray[n12] = (byte)this.ARGBIndex;
                        ++n12;
                    }
                } else {
                    int n13 = n5;
                    while (n13 <= n6) {
                        byArray[n13] = 0;
                        ++n13;
                    }
                }
            }
        }
    }

    private void drawVerticalLine(int n, int n2, int n3) {
        block13: {
            Object object;
            if (n < this.clip.x || n >= this.clip.x + this.clip.width || (object = this.image.getPixelsArray()) == null) break block13;
            int n4 = this.image.getWidth();
            int n5 = n + Math.max(n2, this.clip.y) * n4;
            int n6 = n + Math.min(n3, this.clip.y + this.clip.height - 1) * n4;
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                if (this.XORMode) {
                    int n7 = n5;
                    while (n7 <= n6) {
                        nArray[n7] = 0xFF000000 | nArray[n7] ^ this.ARGB ^ this.XorRGB;
                        n7 += n4;
                    }
                } else {
                    int n8 = n5;
                    while (n8 <= n6) {
                        nArray[n8] = this.ARGB;
                        n8 += n4;
                    }
                }
            } else {
                byte[] byArray = (byte[])object;
                if (this.XORMode) {
                    int n9 = n5;
                    while (n9 <= n6) {
                        int n10 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), byArray[n9] & 0xFF);
                        int n11 = 0xFF000000 | n10 ^ this.ARGB ^ this.XorRGB;
                        byArray[n9] = (byte)this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n11);
                        n9 += n4;
                    }
                } else if (this.ARGBIndex != -1) {
                    int n12 = n5;
                    while (n12 <= n6) {
                        byArray[n12] = (byte)this.ARGBIndex;
                        n12 += n4;
                    }
                } else {
                    int n13 = n5;
                    while (n13 <= n6) {
                        byArray[n13] = 0;
                        n13 += n4;
                    }
                }
            }
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        int n5 = Math.max(n + this.translateX, this.clip.x);
        int n6 = Math.min(n + n3 + this.translateX, this.clip.x + this.clip.width) - 1;
        int n7 = Math.max(n2 + this.translateY, this.clip.y);
        int n8 = Math.min(n2 + n4 + this.translateY, this.clip.y + this.clip.height) - 1;
        if (n5 <= n6 && n7 <= n8) {
            PJAImage pJAImage = this.image;
            synchronized (pJAImage) {
                Object object = this.image.getPixelsArray();
                if (object != null) {
                    int n9 = this.image.getWidth();
                    int n10 = n7 * n9;
                    int n11 = n5 + n10;
                    int n12 = n6 + n10;
                    if (object instanceof int[]) {
                        int[] nArray = (int[])object;
                        if (this.XORMode) {
                            int n13 = n7;
                            while (n13 <= n8) {
                                int n14 = n11;
                                while (n14 <= n12) {
                                    nArray[n14] = 0xFF000000 | nArray[n14] ^ this.ARGB ^ this.XorRGB;
                                    ++n14;
                                }
                                ++n13;
                                n11 += n9;
                                n12 += n9;
                            }
                        } else {
                            int n15 = n7;
                            while (n15 <= n8) {
                                int n16 = n11;
                                while (n16 <= n12) {
                                    nArray[n16] = this.ARGB;
                                    ++n16;
                                }
                                ++n15;
                                n11 += n9;
                                n12 += n9;
                            }
                        }
                    } else {
                        byte[] byArray = (byte[])object;
                        if (this.XORMode) {
                            int n17 = n7;
                            while (n17 <= n8) {
                                int n18 = n11;
                                while (n18 <= n12) {
                                    int n19 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), byArray[n18] & 0xFF);
                                    int n20 = 0xFF000000 | n19 ^ this.ARGB ^ this.XorRGB;
                                    byArray[n18] = (byte)this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n20);
                                    ++n18;
                                }
                                ++n17;
                                n11 += n9;
                                n12 += n9;
                            }
                        } else if (this.ARGBIndex != -1) {
                            int n21 = n7;
                            while (n21 <= n8) {
                                int n22 = n11;
                                while (n22 <= n12) {
                                    byArray[n22] = (byte)this.ARGBIndex;
                                    ++n22;
                                }
                                ++n21;
                                n11 += n9;
                                n12 += n9;
                            }
                        } else {
                            int n23 = n7;
                            while (n23 <= n8) {
                                int n24 = n11;
                                while (n24 <= n12) {
                                    byArray[n24] = 0;
                                    ++n24;
                                }
                                ++n23;
                                n11 += n9;
                                n12 += n9;
                            }
                        }
                    }
                }
            }
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.fillRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawLine(n + n5 / 2, n2, n + n3 - n5 / 2, n2);
        this.drawLine(n, n2 + n6 / 2, n, n2 + n4 - n6 / 2);
        this.drawLine(n + n5 / 2, n2 + n4, n + n3 - n5 / 2, n2 + n4);
        this.drawLine(n + n3, n2 + n6 / 2, n + n3, n2 + n4 - n6 / 2);
        this.drawArc(n, n2, n5, n6, 90, 90);
        this.drawArc(n + n3 - n5, n2, n5, n6, 0, 90);
        this.drawArc(n, n2 + n4 + -n6, n5, n6, 180, 90);
        this.drawArc(n + n3 - n5, n2 + n4 + -n6, n5, n6, 270, 90);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRect(n + n5 / 2, n2, n3 - n5 + 1, n4);
        this.fillRect(n, n2 + n6 / 2 - 1, n5 / 2, n4 - n6);
        this.fillRect(n + n3 - n5 / 2, n2 + n6 / 2 - 1, n5 / 2, n4 - n6);
        this.fillArc(n, n2, n5 - 1, n6 - 1, 90, 90);
        this.fillArc(n + n3 - n5, n2, n5 - 1, n6 - 1, 0, 90);
        this.fillArc(n, n2 + n4 + -n6, n5 - 1, n6 - 1, 180, 90);
        this.fillArc(n + n3 - n5, n2 + n4 + -n6, n5 - 1, n6 - 1, 270, 90);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.ARGB;
        int n6 = this.getBrighterColor(this.ARGB);
        int n7 = this.getDarkerColor(this.ARGB);
        int n8 = this.ARGBIndex;
        int n9 = 0;
        int n10 = 0;
        if (this.image.getColorModel() != null && this.image.getColorModel() instanceof IndexColorModel) {
            n9 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n6);
            n10 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n7);
        }
        this.ARGB = bl ? n6 : n7;
        this.ARGBIndex = bl ? n9 : n10;
        this.drawLine(n, n2, n, n2 + n4);
        this.drawLine(n + 1, n2, n + n3 - 1, n2);
        this.ARGB = bl ? n7 : n6;
        this.ARGBIndex = bl ? n10 : n9;
        this.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        this.drawLine(n + n3, n2, n + n3, n2 + n4 - 1);
        this.ARGB = n5;
        this.ARGBIndex = n8;
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = this.ARGB;
        int n6 = this.getBrighterColor(this.ARGB);
        int n7 = this.getDarkerColor(this.ARGB);
        int n8 = this.ARGBIndex;
        int n9 = 0;
        int n10 = 0;
        if (this.image.getColorModel() != null && this.image.getColorModel() instanceof IndexColorModel) {
            n9 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n6);
            n10 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n7);
        }
        if (!bl) {
            this.ARGB = n7;
            this.ARGBIndex = n10;
        }
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.ARGB = bl ? n6 : n7;
        this.ARGBIndex = bl ? n9 : n10;
        this.drawLine(n, n2, n, n2 + n4 - 1);
        this.drawLine(n + 1, n2, n + n3 - 2, n2);
        this.ARGB = bl ? n7 : n6;
        this.ARGBIndex = bl ? n10 : n9;
        this.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        this.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 2);
        this.ARGB = n5;
        this.ARGBIndex = n8;
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        PJAImage pJAImage = this.image;
        synchronized (pJAImage) {
            this.parseCircleQuarter(n, n2, n3, n4, false, new 1());
        }
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        PJAImage pJAImage = this.image;
        synchronized (pJAImage) {
            this.parseCircleQuarter(n, n2, n3, n4, true, new 2());
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 == 0) {
            return;
        }
        if ((n5 %= 360) < 0) {
            n5 += 360;
        }
        n6 = n6 % 360 == 0 ? 360 : (n6 %= 360);
        int n7 = n6 > 0 ? n5 : (n5 + n6 < 0 ? n5 + n6 + 360 : n5 + n6);
        int n8 = n + this.translateX + n3 / 2;
        int n9 = n2 + this.translateY + n4 / 2;
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        int n10 = this.getBoundingShape(nArray, nArray2, n7, Math.abs(n6), n8, n9, n + this.translateX - 1, n2 + this.translateY - 1, n3 + 2, n4 + 2);
        PJARectangle pJARectangle = this.getBoundingBox(nArray, nArray2, n10).intersection(this.clip);
        PJAImage pJAImage = this.image;
        synchronized (pJAImage) {
            this.parseCircleQuarter(n, n2, n3, n4, false, new 3(pJARectangle, n10, this, nArray, nArray2));
        }
    }

    private int getBoundingShape(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        nArray[0] = n3;
        nArray2[0] = n4;
        Point point = this.getBoundingPointAtAngle(n5, n6, n7, n8, n);
        nArray[1] = point.x;
        nArray2[1] = point.y;
        int n9 = 2;
        int n10 = 0;
        while (n10 < n2) {
            if (n10 + 90 > n2 && (n + n10 - 45) % 360 / 90 == (n + n2 + 45) % 360 / 90) break;
            int n11 = (n + n10) % 360;
            if (n11 > 315 || n11 <= 45) {
                nArray[n9] = n5 + n7;
                nArray2[n9] = n6;
            } else if (n11 > 135 && n11 <= 225) {
                nArray[n9] = n5;
                nArray2[n9] = n6 + n8;
            } else if (n11 > 45 && n11 <= 135) {
                nArray[n9] = n5;
                nArray2[n9] = n6;
            } else {
                nArray[n9] = n5 + n7;
                nArray2[n9] = n6 + n8;
            }
            ++n9;
            n10 += 90;
        }
        Point point2 = this.getBoundingPointAtAngle(n5, n6, n7, n8, (n + n2) % 360);
        if (nArray[n9 - 1] != point2.x || nArray2[n9 - 1] != point2.y) {
            nArray[n9] = point2.x;
            nArray2[n9++] = point2.y;
        }
        return n9;
    }

    private int tanOrCotanShift16(int n) {
        if (n <= 45) {
            return this.TAN_0_TO_45_SHIFT_16[n];
        }
        if (n >= 315) {
            return -this.TAN_0_TO_45_SHIFT_16[360 - n];
        }
        if (n >= 135 && n <= 180) {
            return -this.TAN_0_TO_45_SHIFT_16[180 - n];
        }
        if (n >= 180 && n <= 225) {
            return this.TAN_0_TO_45_SHIFT_16[n - 180];
        }
        if (n >= 45 && n <= 90) {
            return this.TAN_0_TO_45_SHIFT_16[90 - n];
        }
        if (n >= 90 && n <= 135) {
            return -this.TAN_0_TO_45_SHIFT_16[n - 90];
        }
        if (n >= 225 && n <= 270) {
            return this.TAN_0_TO_45_SHIFT_16[270 - n];
        }
        return -this.TAN_0_TO_45_SHIFT_16[n - 270];
    }

    private Point getBoundingPointAtAngle(int n, int n2, int n3, int n4, int n5) {
        if (n5 >= 315 || n5 <= 45) {
            return new Point(n + n3, n2 + (n4 * (65536 - this.tanOrCotanShift16(n5)) >>> 17));
        }
        if (n5 > 45 && n5 < 135) {
            return new Point(n + (n3 * (65536 + this.tanOrCotanShift16(n5)) >>> 17), n2);
        }
        if (n5 >= 135 && n5 <= 225) {
            return new Point(n, n2 + (n4 * (65536 + this.tanOrCotanShift16(n5)) >>> 17));
        }
        return new Point(n + (n3 * (65536 - this.tanOrCotanShift16(n5)) >>> 17), n2 + n4);
    }

    private void drawArcPoint(int[] nArray, int[] nArray2, int n, PJARectangle pJARectangle, int n2, int n3) {
        if (this.contains(nArray, nArray2, n, pJARectangle, n2, n3)) {
            this.drawPoint(n2, n3);
        }
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 == 0) {
            return;
        }
        if ((n5 %= 360) < 0) {
            n5 += 360;
        }
        if (n6 % 360 == 0) {
            this.fillOval(n, n2, n3, n4);
        } else {
            n6 %= 360;
        }
        int n7 = n6 > 0 ? n5 : (n5 + n6 < 0 ? n5 + n6 + 360 : n5 + n6);
        int n8 = n + this.translateX + n3 / 2;
        int n9 = n2 + this.translateY + n4 / 2;
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        int n10 = this.getBoundingShape(nArray, nArray2, n7, Math.abs(n6), n8, n9, n + this.translateX - 1, n2 + this.translateY - 1, n3 + 2, n4 + 2);
        PJARectangle pJARectangle = this.getBoundingBox(nArray, nArray2, n10).intersection(this.clip);
        PJAImage pJAImage = this.image;
        synchronized (pJAImage) {
            this.parseCircleQuarter(n, n2, n3, n4, true, new 4(pJARectangle, n10, this, nArray, nArray2));
        }
    }

    private void drawArcHorizontalLine(int[] nArray, int[] nArray2, int n, PJARectangle pJARectangle, int n2, int n3, int n4) {
        if (n4 >= this.clip.y && n4 < this.clip.y + this.clip.height) {
            int n5 = Math.min(n3, this.clip.x + this.clip.width - 1);
            int n6 = Math.max(n2, this.clip.x);
            while (n6 <= n5) {
                if (this.contains(nArray, nArray2, n, pJARectangle, n6, n4)) {
                    this.drawPoint(n6, n4);
                }
                ++n6;
            }
        }
    }

    public static int roundDiv(int n, int n2) {
        int n3 = n % n2;
        if (Math.abs(n3) * 2 <= Math.abs(n2)) {
            return n / n2;
        }
        if (n * n2 < 0) {
            return n / n2 - 1;
        }
        return n / n2 + 1;
    }

    public static long roundDiv(long l, long l2) {
        long l3 = l % l2;
        if (Math.abs(l3) * 2L <= Math.abs(l2)) {
            return l / l2;
        }
        if (l * l2 < 0L) {
            return l / l2 - 1L;
        }
        return l / l2 + 1L;
    }

    private void parseCircleQuarter(int n, int n2, int n3, int n4, boolean bl, CircleQuarterListener circleQuarterListener) {
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        long l = n3 * n3 / 4;
        long l2 = n4 * n4 / 4;
        long l3 = PJAGraphics.roundDiv((long)n3 * (long)n3 * (long)n4 * (long)n4, 16L);
        int n7 = (n += this.translateX) + n5;
        int n8 = (n2 += this.translateY) + n6;
        int n9 = n3 % 2 == 0 ? 0 : 1;
        int n10 = n4 % 2 == 0 ? 0 : 1;
        int n11 = n6;
        int n12 = 0;
        int n13 = n7 - n12;
        int n14 = n7 + n12 + n9;
        int n15 = n8 - n11;
        int n16 = n8 + n11 + n10;
        while (n12 <= n5 && n11 >= 0) {
            long l4 = (long)((n12 + 1) * (n12 + 1)) * l2 + (long)(n11 * n11) * l - l3;
            long l5 = (long)((n12 + 1) * (n12 + 1)) * l2 + (long)((n11 - 1) * (n11 - 1)) * l - l3;
            long l6 = (long)(n12 * n12) * l2 + (long)((n11 - 1) * (n11 - 1)) * l - l3;
            if (l4 <= 0L) {
                ++n12;
            } else if (l6 >= 0L) {
                --n11;
            } else {
                long l7 = Math.min(Math.abs(l4), Math.min(Math.abs(l5), Math.abs(l6)));
                if (l7 == Math.abs(l4)) {
                    ++n12;
                } else if (l7 == Math.abs(l6)) {
                    --n11;
                } else {
                    ++n12;
                    --n11;
                }
            }
            int n17 = n7 - n12;
            int n18 = n7 + n12 + n9;
            int n19 = n8 - n11;
            int n20 = n8 + n11 + n10;
            if (!bl || n15 != n19) {
                circleQuarterListener.newPoint(n13, n15, n14, n16);
                n15 = n19;
                n16 = n20;
            }
            n13 = n17;
            n14 = n18;
        }
        if (n15 < n16) {
            while (n15 <= n16) {
                circleQuarterListener.newPoint(n7 - n5, n15, n7 + n5 + n9, n16);
                ++n15;
                --n16;
            }
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int n2 = 1;
        while (n2 < n) {
            this.drawLine(nArray[n2 - 1], nArray2[n2 - 1], nArray[n2], nArray2[n2]);
            ++n2;
        }
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolyline(nArray, nArray2, n);
        this.drawLine(nArray[n - 1], nArray2[n - 1], nArray[0], nArray2[0]);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3;
        int[] nArray4;
        if (this.translateX == 0) {
            nArray4 = nArray;
        } else {
            nArray4 = (int[])nArray.clone();
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                nArray4[n3] = nArray4[n3] + this.translateX;
            }
        }
        if (this.translateY == 0) {
            nArray3 = nArray2;
        } else {
            nArray3 = (int[])nArray2.clone();
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                nArray3[n5] = nArray3[n5] + this.translateY;
            }
        }
        PJARectangle pJARectangle = this.getBoundingBox(nArray4, nArray3, n).intersection(this.clip);
        PJAImage pJAImage = this.image;
        synchronized (pJAImage) {
            int n6 = pJARectangle.x;
            while (n6 < pJARectangle.x + pJARectangle.width) {
                int n7 = pJARectangle.y;
                while (n7 < pJARectangle.y + pJARectangle.height) {
                    if (this.contains(nArray4, nArray3, n, pJARectangle, n6, n7)) {
                        this.drawPoint(n6, n7);
                    }
                    ++n7;
                }
                ++n6;
            }
        }
    }

    private PJARectangle getBoundingBox(int[] nArray, int[] nArray2, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        while (n6 < n) {
            int n7 = nArray[n6];
            n2 = Math.min(n2, n7);
            n4 = Math.max(n4, n7);
            int n8 = nArray2[n6];
            n3 = Math.min(n3, n8);
            n5 = Math.max(n5, n8);
            ++n6;
        }
        return new PJARectangle(n2, n3, n4 - n2, n5 - n3);
    }

    private boolean contains(int[] nArray, int[] nArray2, int n, PJARectangle pJARectangle, int n2, int n3) {
        if (pJARectangle != null && pJARectangle.inside(n2, n3) || pJARectangle == null && this.getBoundingBox(nArray, nArray2, n).inside(n2, n3)) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n && nArray2[n6] == n3) {
                ++n6;
            }
            int n7 = 0;
            while (n7 < n) {
                int n8 = (n6 + 1) % n;
                int n9 = nArray[n8] - nArray[n6];
                int n10 = nArray2[n8] - nArray2[n6];
                if (n10 != 0) {
                    int n11 = n2 - nArray[n6];
                    int n12 = n3 - nArray2[n6];
                    if (nArray2[n8] == n3 && nArray[n8] >= n2) {
                        n5 = nArray2[n6];
                    }
                    if (nArray2[n6] == n3 && nArray[n6] >= n2 && n5 > n3 != nArray2[n8] > n3) {
                        --n4;
                    }
                    if (n12 * n10 >= 0 && (n12 <= n10 && n12 >= 0 || n12 >= n10 && n12 <= 0) && PJAGraphics.roundDiv(n9 * n12, n10) >= n11) {
                        ++n4;
                    }
                }
                n6 = n8;
                ++n7;
            }
            return n4 % 2 != 0;
        }
        return false;
    }

    public void drawString(String string, int n, int n2) {
        this.checkFontLoading();
        int n3 = string.length();
        if (this.fontPeer != null && n3 > 0) {
            int n4;
            int n5;
            PJAFontData pJAFontData = this.fontPeer.getFontData(this.fontSize);
            int n6 = pJAFontData.getAscent() + pJAFontData.getDescent();
            int n7 = pJAFontData.getAscent();
            n += this.translateX;
            int n8 = Math.max((n2 += this.translateY) - n7, this.clip.y);
            if (n8 > (n5 = Math.min(n2 - n7 + n6, this.clip.y + this.clip.height) - 1)) {
                return;
            }
            int n9 = n8 - (n2 - n7);
            int n10 = 0;
            int n11 = n;
            int n12 = n;
            int n13 = 0;
            while (n13 < n3) {
                char c = string.charAt(n13);
                int n14 = pJAFontData.getCharWidth(c);
                int n15 = pJAFontData.getCharPixelsWidth(c);
                n4 = pJAFontData.getCharOffsetAtBaseline(c);
                if (n4 < -n10) {
                    n11 = Math.min(n11, n + (n10 + n4));
                }
                n12 = Math.max(n12, n + n10 + n4 + n15);
                n10 += n14;
                ++n13;
            }
            if ((n11 = Math.max(n11, this.clip.x)) > (n12 = Math.min(n12, this.clip.x + this.clip.width) - 1)) {
                return;
            }
            PJAImage pJAImage = this.image;
            synchronized (pJAImage) {
                Object object = this.image.getPixelsArray();
                if (object != null) {
                    n4 = this.image.getWidth();
                    int[] nArray = pJAFontData.getCharBits();
                    int n16 = pJAFontData.getCharBitsScanSize();
                    int n17 = 0;
                    int n18 = n;
                    while (n17 < n3 && n18 < n12) {
                        char c = string.charAt(n17);
                        int n19 = pJAFontData.getCharWidth(c);
                        if (n19 > 0) {
                            int n20 = pJAFontData.getCharPixelsWidth(c);
                            int n21 = pJAFontData.getCharOffsetAtBaseline(c);
                            int n22 = Math.max(n18 + n21, n11);
                            int n23 = Math.min(n18 + n21 + n20 - 1, n12);
                            if (n23 >= n11) {
                                int n24;
                                int n25;
                                int n26;
                                int n27;
                                Object[] objectArray;
                                int n28 = pJAFontData.getCharBitsOffset(c);
                                int n29 = n28 + n9 * n16;
                                if (n18 + n21 < n11) {
                                    n29 += n11 - n18 - n21;
                                }
                                int n30 = n8 * n4 + n22;
                                if (object instanceof int[]) {
                                    objectArray = (int[])object;
                                    if (this.XORMode) {
                                        n27 = n8;
                                        while (n27 <= n5) {
                                            n26 = n22;
                                            n25 = n30;
                                            n24 = n29;
                                            while (n26 <= n23) {
                                                if ((nArray[n24 >> 5] & 1 << (n24 & 0x1F)) != 0) {
                                                    objectArray[n25] = 0xFF000000 | objectArray[n25] ^ this.ARGB ^ this.XorRGB;
                                                }
                                                ++n26;
                                                ++n25;
                                                ++n24;
                                            }
                                            ++n27;
                                            n29 += n16;
                                            n30 += n4;
                                        }
                                    } else {
                                        n27 = n8;
                                        while (n27 <= n5) {
                                            n26 = n22;
                                            n25 = n30;
                                            n24 = n29;
                                            while (n26 <= n23) {
                                                if ((nArray[n24 >> 5] & 1 << (n24 & 0x1F)) != 0) {
                                                    objectArray[n25] = this.ARGB;
                                                }
                                                ++n26;
                                                ++n25;
                                                ++n24;
                                            }
                                            ++n27;
                                            n29 += n16;
                                            n30 += n4;
                                        }
                                    }
                                } else {
                                    objectArray = (byte[])object;
                                    if (this.XORMode) {
                                        n27 = n8;
                                        while (n27 <= n5) {
                                            n26 = n22;
                                            n25 = n30;
                                            n24 = n29;
                                            while (n26 <= n23) {
                                                if ((nArray[n24 >> 5] & 1 << (n24 & 0x1F)) != 0) {
                                                    int n31 = this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), objectArray[n25] & 0xFF);
                                                    int n32 = 0xFF000000 | n31 ^ this.ARGB ^ this.XorRGB;
                                                    objectArray[n25] = (byte)this.manager.getClosestColorIndex((IndexColorModel)this.image.getColorModel(), n32);
                                                }
                                                ++n26;
                                                ++n25;
                                                ++n24;
                                            }
                                            ++n27;
                                            n29 += n16;
                                            n30 += n4;
                                        }
                                    } else if (this.ARGBIndex != -1) {
                                        n27 = n8;
                                        while (n27 <= n5) {
                                            n26 = n22;
                                            n25 = n30;
                                            n24 = n29;
                                            while (n26 <= n23) {
                                                if ((nArray[n24 >> 5] & 1 << (n24 & 0x1F)) != 0) {
                                                    objectArray[n25] = (byte)this.ARGBIndex;
                                                }
                                                ++n26;
                                                ++n25;
                                                ++n24;
                                            }
                                            ++n27;
                                            n29 += n16;
                                            n30 += n4;
                                        }
                                    } else {
                                        n27 = n8;
                                        while (n27 <= n5) {
                                            n26 = n22;
                                            n25 = n30;
                                            n24 = n29;
                                            while (n26 <= n23) {
                                                if ((nArray[n24 >> 5] & 1 << (n24 & 0x1F)) != 0) {
                                                    objectArray[n25] = 0;
                                                }
                                                ++n26;
                                                ++n25;
                                                ++n24;
                                            }
                                            ++n27;
                                            n29 += n16;
                                            n30 += n4;
                                        }
                                    }
                                }
                            }
                        }
                        n18 += n19;
                        ++n17;
                    }
                }
            }
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.drawString(stringBuffer.toString(), n, n2);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        int n3 = n + this.translateX;
        int n4 = n2 + this.translateY;
        image.getSource().startProduction(new 5(color, n3, n4, image, imageObserver, this));
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.drawImage(this.manager.createImage(new FilteredImageSource(image.getSource(), new AreaAveragingScaleFilter(n3, n4))), n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        if (n == n3 || n2 == n4) {
            return true;
        }
        if (n5 == n7 || n6 == n8) {
            return true;
        }
        if (n7 > n5) {
            n16 = n7 - n5 + 1;
            n15 = n5;
        } else {
            n16 = n5 - n7 + 1;
            n15 = n7;
        }
        if (n8 > n6) {
            n14 = n8 - n6 + 1;
            n13 = n6;
        } else {
            n14 = n6 - n8 + 1;
            n13 = n8;
        }
        if (n3 > n) {
            n12 = n3 - n + 1;
            n11 = n;
        } else {
            n12 = n - n3 + 1;
            n11 = n3;
        }
        if (n4 > n2) {
            n10 = n4 - n2 + 1;
            n9 = n2;
        } else {
            n10 = n2 - n4 + 1;
            n9 = n4;
        }
        Image image2 = this.manager.createImage(new FilteredImageSource(image.getSource(), new CropImageFilter(n15, n13, n16, n14)));
        return this.drawImage(image2, n11, n9, n12, n10, color, imageObserver);
    }

    public void dispose() {
    }

    private class PJAFont
    extends Font {
        FontPeer peer;

        public PJAFont(String string, int n, int n2) {
            super(string, n, n2);
            this.peer = PJAGraphics.this.manager.getFontPeer(string, n, true);
        }

        public FontPeer getPeer() {
            return this.peer;
        }
    }

    private static class PJARectangle {
        int x;
        int y;
        int width;
        int height;

        public PJARectangle(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }

        public PJARectangle(PJARectangle pJARectangle) {
            this.x = pJARectangle.x;
            this.y = pJARectangle.y;
            this.width = pJARectangle.width;
            this.height = pJARectangle.height;
        }

        public PJARectangle intersection(PJARectangle pJARectangle) {
            int n = Math.max(this.x, pJARectangle.x);
            int n2 = Math.min(this.x + this.width, pJARectangle.x + pJARectangle.width);
            int n3 = Math.max(this.y, pJARectangle.y);
            int n4 = Math.min(this.y + this.height, pJARectangle.y + pJARectangle.height);
            return new PJARectangle(n, n3, n2 - n, n4 - n3);
        }

        public boolean inside(int n, int n2) {
            return n >= this.x && n - this.x < this.width && n2 >= this.y && n2 - this.y < this.height;
        }
    }

    private final class 1
    implements CircleQuarterListener {
        public void newPoint(int n, int n2, int n3, int n4) {
            PJAGraphics.this.drawPoint(n, n2);
            PJAGraphics.this.drawPoint(n3, n2);
            PJAGraphics.this.drawPoint(n, n4);
            PJAGraphics.this.drawPoint(n3, n4);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements CircleQuarterListener {
        public void newPoint(int n, int n2, int n3, int n4) {
            PJAGraphics.this.drawHorizontalLine(n, n3, n2);
            if (n2 != n4) {
                PJAGraphics.this.drawHorizontalLine(n, n3, n4);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private static final class 3
    implements CircleQuarterListener {
        private final /* synthetic */ PJAGraphics this$0;
        private final /* synthetic */ PJARectangle val$bounds;
        private final /* synthetic */ int val$nPoints;
        private final /* synthetic */ int[] val$yPoints;
        private final /* synthetic */ int[] val$xPoints;

        public void newPoint(int n, int n2, int n3, int n4) {
            this.this$0.drawArcPoint(this.val$xPoints, this.val$yPoints, this.val$nPoints, this.val$bounds, n, n2);
            this.this$0.drawArcPoint(this.val$xPoints, this.val$yPoints, this.val$nPoints, this.val$bounds, n3, n2);
            this.this$0.drawArcPoint(this.val$xPoints, this.val$yPoints, this.val$nPoints, this.val$bounds, n, n4);
            this.this$0.drawArcPoint(this.val$xPoints, this.val$yPoints, this.val$nPoints, this.val$bounds, n3, n4);
        }

        /* synthetic */ 3(PJARectangle pJARectangle, int n, PJAGraphics pJAGraphics, int[] nArray, int[] nArray2) {
            this.val$bounds = pJARectangle;
            this.val$nPoints = n;
            this.this$0 = pJAGraphics;
            this.val$xPoints = nArray;
            this.val$yPoints = nArray2;
        }
    }

    private static final class 4
    implements CircleQuarterListener {
        private final /* synthetic */ PJAGraphics this$0;
        private final /* synthetic */ PJARectangle val$bounds;
        private final /* synthetic */ int val$nPoints;
        private final /* synthetic */ int[] val$yPoints;
        private final /* synthetic */ int[] val$xPoints;

        public void newPoint(int n, int n2, int n3, int n4) {
            this.this$0.drawArcHorizontalLine(this.val$xPoints, this.val$yPoints, this.val$nPoints, this.val$bounds, n, n3, n2);
            if (n2 != n4) {
                this.this$0.drawArcHorizontalLine(this.val$xPoints, this.val$yPoints, this.val$nPoints, this.val$bounds, n, n3, n4);
            }
        }

        /* synthetic */ 4(PJARectangle pJARectangle, int n, PJAGraphics pJAGraphics, int[] nArray, int[] nArray2) {
            this.val$bounds = pJARectangle;
            this.val$nPoints = n;
            this.this$0 = pJAGraphics;
            this.val$xPoints = nArray;
            this.val$yPoints = nArray2;
        }
    }

    private interface CircleQuarterListener {
        public void newPoint(int var1, int var2, int var3, int var4);
    }

    private static final class 5
    implements ImageConsumer {
        private final /* synthetic */ Color val$bgcolor;
        private final /* synthetic */ int val$destY;
        private final /* synthetic */ int val$destX;
        private final /* synthetic */ PJAGraphics this$0;
        private final /* synthetic */ Image val$img;
        private final /* synthetic */ ImageObserver val$observer;
        private int availableInfo;
        private int width;
        private int height;

        public void setDimensions(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.availableInfo |= 3;
            if (this.val$observer != null) {
                this.val$observer.imageUpdate(this.val$img, this.availableInfo, 0, 0, n, n2);
            }
        }

        public void setHints(int n) {
        }

        public void setProperties(Hashtable hashtable) {
            this.availableInfo |= 4;
            if (this.val$observer != null) {
                this.val$observer.imageUpdate(this.val$img, this.availableInfo, 0, 0, this.width, this.height);
            }
        }

        public void setColorModel(ColorModel colorModel) {
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            PJAImage pJAImage = this.this$0.image;
            synchronized (pJAImage) {
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = n5 + n7 * n6;
                    int n9 = 0;
                    while (n9 < n3) {
                        this.drawImagePoint(n + n9 + this.val$destX, n2 + this.val$destY, this.val$bgcolor, colorModel.getRGB(byArray[n8 + n9] & 0xFF));
                        ++n9;
                    }
                    ++n7;
                    ++n2;
                }
            }
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            PJAImage pJAImage = this.this$0.image;
            synchronized (pJAImage) {
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = n5 + n7 * n6;
                    int n9 = 0;
                    while (n9 < n3) {
                        this.drawImagePoint(n + n9 + this.val$destX, n2 + this.val$destY, this.val$bgcolor, colorModel == null ? nArray[n8 + n9] : colorModel.getRGB(nArray[n8 + n9]));
                        ++n9;
                    }
                    ++n7;
                    ++n2;
                }
            }
        }

        public void imageComplete(int n) {
            if (n == 1) {
                this.availableInfo = 64;
            } else if (n == 4) {
                this.availableInfo = 192;
            } else if (n == 3) {
                this.availableInfo |= 0x20;
            } else if (n == 2) {
                this.availableInfo |= 0x10;
            }
            if (this.val$observer != null) {
                if ((this.availableInfo & 0x40) != 0) {
                    this.val$observer.imageUpdate(this.val$img, this.availableInfo, -1, -1, -1, -1);
                } else {
                    this.val$observer.imageUpdate(this.val$img, this.availableInfo, 0, 0, this.width, this.height);
                }
            }
        }

        private void drawImagePoint(int n, int n2, Color color, int n3) {
            Object object;
            if (!this.this$0.isClipped(n, n2) && (object = this.this$0.image.getPixelsArray()) != null) {
                int[] nArray = null;
                byte[] byArray = null;
                if (object instanceof int[]) {
                    nArray = (int[])object;
                } else {
                    byArray = (byte[])object;
                }
                int n4 = this.this$0.image.getWidth();
                int n5 = n + n2 * n4;
                int n6 = color != null ? color.getRGB() | 0xFF000000 : (nArray != null ? nArray[n + n2 * n4] : this.this$0.image.getColorModel().getRGB(byArray[n + n2 * n4] & 0xFF));
                int n7 = (n6 & 0xFF000000) >>> 24;
                int n8 = (n3 & 0xFF000000) >>> 24;
                if (n8 == 0) {
                    if (nArray != null) {
                        nArray[n5] = n6;
                    } else {
                        byArray[n5] = (byte)this.this$0.manager.getClosestColorIndex((IndexColorModel)this.this$0.image.getColorModel(), n6);
                    }
                } else if (n7 == 0 || n8 == 255) {
                    if (nArray != null) {
                        nArray[n5] = n3;
                    } else {
                        byArray[n5] = (byte)this.this$0.manager.getClosestColorIndex((IndexColorModel)this.this$0.image.getColorModel(), n3);
                    }
                } else {
                    int n9 = (n6 & 0xFF0000) >>> 16;
                    n9 = Math.min(255, n9 + n8 * (((n3 & 0xFF0000) >>> 16) - n9) / 255);
                    int n10 = (n6 & 0xFF00) >>> 8;
                    n10 = Math.min(255, n10 + n8 * (((n3 & 0xFF00) >>> 8) - n10) / 255);
                    int n11 = n6 & 0xFF;
                    n11 = Math.min(255, n11 + n8 * ((n3 & 0xFF) - n11) / 255);
                    int n12 = 0xFF000000 | n9 << 16 | n10 << 8 | n11;
                    if (nArray != null) {
                        nArray[n5] = n12;
                    } else {
                        byArray[n5] = (byte)this.this$0.manager.getClosestColorIndex((IndexColorModel)this.this$0.image.getColorModel(), n12);
                    }
                }
            }
        }

        /* synthetic */ 5(Color color, int n, int n2, Image image, ImageObserver imageObserver, PJAGraphics pJAGraphics) {
            this.val$bgcolor = color;
            this.val$destX = n;
            this.val$destY = n2;
            this.val$img = image;
            this.val$observer = imageObserver;
            this.this$0 = pJAGraphics;
        }
    }

    private class AreaAveragingScaleFilter
    extends ImageFilter {
        private ColorModel rgbModel;
        private long[] alphas;
        private long[] reds;
        private long[] greens;
        private long[] blues;
        protected int srcWidth;
        protected int srcHeight;
        private int[] srcPixels;
        protected int destWidth;
        protected int destHeight;
        protected int[] destPixels;

        public AreaAveragingScaleFilter(int n, int n2) {
            boolean bl = PJAGraphicsManager.getDefaultGraphicsManager().isClassAccessible("java.awt.image.ColorModel");
            if (bl) {
                this.rgbModel = ColorModel.getRGBdefault();
            }
            this.destWidth = n;
            this.destHeight = n2;
        }

        public void setDimensions(int n, int n2) {
            this.srcWidth = n;
            this.srcHeight = n2;
            if (this.destWidth < 0) {
                if (this.destHeight < 0) {
                    this.destWidth = this.srcWidth;
                    this.destHeight = this.srcHeight;
                } else {
                    this.destWidth = this.srcWidth * this.destHeight / this.srcHeight;
                }
            } else if (this.destHeight < 0) {
                this.destHeight = this.srcHeight * this.destWidth / this.srcWidth;
            }
            this.consumer.setDimensions(this.destWidth, this.destHeight);
        }

        public void setHints(int n) {
            this.consumer.setHints(n & 0x18 | 2);
        }

        public void imageComplete(int n) {
            if (n == 3 || n == 2) {
                this.accumPixels(0, 0, this.srcWidth, this.srcHeight, this.rgbModel, this.srcPixels, 0, this.srcWidth);
            }
            this.consumer.imageComplete(n);
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
            if (this.srcPixels == null) {
                this.srcPixels = new int[this.srcWidth * this.srcHeight];
            }
            int n7 = 0;
            int n8 = n2 * this.srcWidth;
            while (n7 < n4) {
                int n9 = n5 + n7 * n6;
                int n10 = 0;
                while (n10 < n3) {
                    this.srcPixels[n8 + n + n10] = colorModel.getRGB(byArray[n9 + n10] & 0xFF);
                    ++n10;
                }
                ++n7;
                n8 += this.srcWidth;
            }
        }

        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            if (this.srcPixels == null) {
                this.srcPixels = new int[this.srcWidth * this.srcHeight];
            }
            int n7 = 0;
            int n8 = n2 * this.srcWidth;
            while (n7 < n4) {
                int n9 = n5 + n7 * n6;
                int n10 = 0;
                while (n10 < n3) {
                    this.srcPixels[n8 + n + n10] = colorModel == null ? nArray[n9 + n10] : colorModel.getRGB(nArray[n9 + n10]);
                    ++n10;
                }
                ++n7;
                n8 += this.srcWidth;
            }
        }

        private int[] calcRow() {
            long l = this.srcWidth * this.srcHeight << 32;
            if (this.destPixels == null) {
                this.destPixels = new int[this.destWidth];
            }
            int n = 0;
            while (n < this.destWidth) {
                int n2 = (int)PJAGraphics.roundDiv(this.alphas[n], l);
                int n3 = (int)PJAGraphics.roundDiv(this.reds[n], l);
                int n4 = (int)PJAGraphics.roundDiv(this.greens[n], l);
                int n5 = (int)PJAGraphics.roundDiv(this.blues[n], l);
                n2 = Math.max(Math.min(n2, 255), 0);
                n3 = Math.max(Math.min(n3, 255), 0);
                n4 = Math.max(Math.min(n4, 255), 0);
                n5 = Math.max(Math.min(n5, 255), 0);
                this.destPixels[n] = n2 << 24 | n3 << 16 | n4 << 8 | n5;
                ++n;
            }
            return this.destPixels;
        }

        private void accumPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            this.reds = new long[this.destWidth];
            this.greens = new long[this.destWidth];
            this.blues = new long[this.destWidth];
            this.alphas = new long[this.destWidth];
            int n7 = n2;
            int n8 = this.destHeight;
            int n9 = 0;
            int n10 = 0;
            while (n7 < n2 + n4) {
                int n11;
                if (n10 == 0) {
                    n11 = 0;
                    while (n11 < this.destWidth) {
                        this.blues[n11] = 0L;
                        this.greens[n11] = 0L;
                        this.reds[n11] = 0L;
                        this.alphas[n11] = 0L;
                        ++n11;
                    }
                    n10 = this.srcHeight;
                }
                n11 = Math.min(n8, n10);
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = this.srcWidth;
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                while (n12 < n3) {
                    int n20;
                    if (n14 == 0) {
                        n14 = this.destWidth;
                        n20 = nArray[n5 + n12];
                        n16 = n20 >>> 24;
                        n17 = n20 >> 16 & 0xFF;
                        n18 = n20 >> 8 & 0xFF;
                        n19 = n20 & 0xFF;
                    }
                    n20 = Math.min(n14, n15);
                    long l = n20 * n11 << 32;
                    int n21 = n13;
                    this.alphas[n21] = this.alphas[n21] + l * (long)n16;
                    int n22 = n13;
                    this.reds[n22] = this.reds[n22] + l * (long)n17;
                    int n23 = n13;
                    this.greens[n23] = this.greens[n23] + l * (long)n18;
                    int n24 = n13;
                    this.blues[n24] = this.blues[n24] + l * (long)n19;
                    if ((n14 -= n20) == 0) {
                        ++n12;
                    }
                    if ((n15 -= n20) != 0) continue;
                    ++n13;
                    n15 = this.srcWidth;
                }
                if ((n10 -= n11) == 0) {
                    int[] nArray2 = this.calcRow();
                    do {
                        this.consumer.setPixels(0, n9, this.destWidth, 1, this.rgbModel, nArray2, 0, this.destWidth);
                        ++n9;
                    } while ((n8 -= n11) >= n11 && n11 == this.srcHeight);
                } else {
                    n8 -= n11;
                }
                if (n8 != 0) continue;
                n8 = this.destHeight;
                ++n7;
                n5 += n6;
            }
        }
    }
}

