/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.awt;

import com.eteks.awt.PJAFontData;
import com.eteks.awt.PJAFontPeer;
import com.eteks.awt.PJAGraphicsManager;
import com.eteks.awt.PJAImage;
import com.eteks.awt.image.GIFDecoder;
import java.awt.AWTError;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.awt.image.ByteArrayImageSource;

public abstract class PJAGraphicsManager {
    private static final int DEFAULT_SCREEN_WIDTH = 1024;
    private static final int DEFAULT_SCREEN_HEIGHT = 768;
    private static final int DEFAULT_SCREEN_RES = 75;
    private Hashtable fontTable = new Hashtable();
    private String[] fontList = null;
    private String lastLoadedFont = null;
    private String fontPath = null;
    private ColorModel colorModel = null;
    private static PJAGraphicsManager graphicsManager;
    private static boolean java2DAvailable;
    static /* synthetic */ Class class$com$eteks$awt$image$GIFDecoder;

    protected PJAGraphicsManager() {
        boolean bl = this.isClassAccessible("java.awt.image.ColorModel");
        if (bl) {
            String string = null;
            try {
                string = System.getProperty("com.eteks.awt.colormodel");
            }
            catch (SecurityException securityException) {}
            if (string != null && this.isClassAccessible(string)) {
                try {
                    this.colorModel = (ColorModel)Class.forName(string).newInstance();
                }
                catch (Exception exception) {}
            }
            if (this.colorModel == null) {
                this.colorModel = ColorModel.getRGBdefault();
            }
        }
        try {
            if (this.fontList == null) {
                this.loadFonts();
            }
        }
        catch (Exception exception) {}
    }

    public static synchronized PJAGraphicsManager getDefaultGraphicsManager() {
        if (graphicsManager == null) {
            String string = null;
            try {
                string = System.getProperty("com.eteks.awt.graphicsmanager");
            }
            catch (SecurityException securityException) {}
            try {
                graphicsManager = string == null ? (PJAGraphicsManager.useJava2D() ? (PJAGraphicsManager)Class.forName("com.eteks.java2d.PJAGraphicsManager2D").newInstance() : new 1.InstantiablePJAGraphicsManager()) : (PJAGraphicsManager)Class.forName(string).newInstance();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AWTError("No GraphicsManager defined");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AWTError("GraphicsManager not found : " + string);
            }
            catch (InstantiationException instantiationException) {
                throw new AWTError("Could not instantiate GraphicsManager : " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AWTError("Could not access GraphicsManager : " + string);
            }
            catch (ClassCastException classCastException) {
                throw new AWTError(String.valueOf(String.valueOf(string)) + " not a subclass of com.eteks.awt.PJAGraphicsManager");
            }
        }
        return graphicsManager;
    }

    private static boolean useJava2D() {
        try {
            return !Boolean.getBoolean("com.eteks.awt.nojava2d") && java2DAvailable && Class.forName("com.eteks.java2d.PJAGraphicsManager2D") != null && PJAGraphicsManager.isFontInstantiableInternal();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {}
        return false;
    }

    public boolean isClassAccessible(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {}
        return false;
    }

    public boolean isFontInstantiable() {
        return PJAGraphicsManager.isFontInstantiableInternal();
    }

    private static boolean isFontInstantiableInternal() {
        try {
            new Font("Helvetica", 0, 10);
            return true;
        }
        catch (AWTError aWTError) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (InternalError internalError) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (Error error) {}
        return false;
    }

    public FontPeer getFontPeer(String string, int n) {
        return this.getFontPeer(string, n, true);
    }

    FontPeer getFontPeer(String string, int n, boolean bl) {
        PJAFontPeer[] pJAFontPeerArray;
        if (string == null) {
            throw new IllegalArgumentException("Font name can't be null");
        }
        if (this.fontPath == null || !this.fontPath.equals(this.getFontsPath())) {
            this.loadFonts();
        }
        if ((pJAFontPeerArray = (PJAFontPeer[])this.fontTable.get(string)) == null && this.getDefaultFont() != null) {
            pJAFontPeerArray = (PJAFontPeer[])this.fontTable.get(this.getDefaultFont());
        }
        if (pJAFontPeerArray == null) {
            throw new AWTError("No default font : at least one .pjaf font must be loaded.");
        }
        PJAFontPeer pJAFontPeer = null;
        int n2 = 0;
        while (n2 < pJAFontPeerArray.length) {
            pJAFontPeer = pJAFontPeerArray[n2];
            if (pJAFontPeer != null) break;
            ++n2;
        }
        if (n == 0) {
            if (pJAFontPeerArray[0] != null) {
                pJAFontPeer = pJAFontPeerArray[0];
            } else if (pJAFontPeerArray[2] != null) {
                pJAFontPeer = pJAFontPeerArray[2];
            }
        } else if (n == 1) {
            if (pJAFontPeerArray[2] != null) {
                pJAFontPeer = pJAFontPeerArray[2];
            }
        } else if (n == 2) {
            if (pJAFontPeerArray[1] != null) {
                pJAFontPeer = pJAFontPeerArray[1];
            } else if (pJAFontPeerArray[3] != null) {
                pJAFontPeer = pJAFontPeerArray[3];
            }
        } else if (n == 3) {
            if (pJAFontPeerArray[3] != null) {
                pJAFontPeer = pJAFontPeerArray[3];
            } else if (pJAFontPeerArray[1] != null) {
                pJAFontPeer = pJAFontPeerArray[1];
            } else if (pJAFontPeerArray[2] != null) {
                pJAFontPeer = pJAFontPeerArray[2];
            }
        }
        return pJAFontPeer;
    }

    public int getScreenWidth() {
        return 1024;
    }

    public int getScreenHeight() {
        return 768;
    }

    public int getScreenResolution() {
        return 75;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public int getClosestColorIndex(IndexColorModel indexColorModel, int n) {
        int n2 = n >> 24 & 0xFF;
        if (n2 == 0) {
            return indexColorModel.getTransparentPixel() != -1 ? indexColorModel.getTransparentPixel() : 0;
        }
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = indexColorModel.getMapSize();
        int n7 = 0;
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        while (n9 < n6) {
            int n10;
            int n11;
            int n12;
            int n13 = n2 - indexColorModel.getAlpha(n9);
            int n14 = n13 * n13 + (n12 = n3 - indexColorModel.getRed(n9)) * n12 + (n11 = n4 - indexColorModel.getGreen(n9)) * n11 + (n10 = n5 - indexColorModel.getBlue(n9)) * n10;
            if (n14 < n8) {
                n8 = n14;
                n7 = n9;
            }
            ++n9;
        }
        return n7;
    }

    public String getFontsPath() {
        String string = "";
        try {
            string = System.getProperty("java.awt.fonts", "");
        }
        catch (SecurityException securityException) {}
        try {
            string = "".equals(string) ? System.getProperty("user.dir") : String.valueOf(string) + File.pathSeparator + System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {}
        return string;
    }

    public String getFontsDirectory() {
        String string = this.getFontsPath();
        if ("".equals(string)) {
            return "";
        }
        return new StringTokenizer(string, File.pathSeparator).nextToken();
    }

    public void loadFonts() {
        this.fontPath = this.getFontsPath();
        if (!"".equals(this.fontPath)) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.fontPath, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                this.loadFonts(stringTokenizer.nextToken());
            }
        } else {
            this.loadFonts("");
        }
    }

    public void loadFonts(String string) {
        block11: {
            String[] stringArray = new File(string).list(new 1());
            this.lastLoadedFont = null;
            if (stringArray == null) break block11;
            int n = 0;
            while (n < stringArray.length) {
                Object var7_6;
                File file = new File(string, stringArray[n]);
                BufferedInputStream bufferedInputStream = null;
                try {
                    try {
                        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                        this.loadFont(bufferedInputStream);
                    }
                    catch (IOException iOException) {
                        System.err.println("Can't load font file " + file + "\n" + iOException);
                    }
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    try {
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {}
                ++n;
            }
        }
    }

    public void loadFont(InputStream inputStream) throws IOException {
        try {
            try {
                Object object;
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                try {
                    object = dataInputStream.readUTF();
                    if (!"PJAF1.1".equals(object)) {
                        throw new IOException("Not a PJA font stream");
                    }
                }
                catch (UTFDataFormatException uTFDataFormatException) {
                    throw new IOException("Not a PJA font stream (Warning : PJA 1.0 fonts aren't compatible with PJA 1.1 or higher)");
                }
                while (true) {
                    object = new PJAFontData(dataInputStream);
                    String string = ((PJAFontData)object).getName();
                    int n = ((PJAFontData)object).getStyle();
                    PJAFontPeer[] pJAFontPeerArray = (PJAFontPeer[])this.fontTable.get(string);
                    if (pJAFontPeerArray == null) {
                        pJAFontPeerArray = new PJAFontPeer[4];
                        this.fontTable.put(string, pJAFontPeerArray);
                    }
                    PJAFontPeer pJAFontPeer = null;
                    if (n == 0) {
                        if (pJAFontPeerArray[0] == null) {
                            pJAFontPeerArray[0] = new PJAFontPeer(string, n);
                        }
                        pJAFontPeer = pJAFontPeerArray[0];
                    } else if (n == 2) {
                        if (pJAFontPeerArray[1] == null) {
                            pJAFontPeerArray[1] = new PJAFontPeer(string, n);
                        }
                        pJAFontPeer = pJAFontPeerArray[1];
                    } else if (n == 1) {
                        if (pJAFontPeerArray[2] == null) {
                            pJAFontPeerArray[2] = new PJAFontPeer(string, n);
                        }
                        pJAFontPeer = pJAFontPeerArray[2];
                    } else if (n == 3) {
                        if (pJAFontPeerArray[3] == null) {
                            pJAFontPeerArray[3] = new PJAFontPeer(string, n);
                        }
                        pJAFontPeer = pJAFontPeerArray[3];
                    }
                    pJAFontPeer.addFontData((PJAFontData)object);
                    if (this.lastLoadedFont != null) continue;
                    this.lastLoadedFont = string;
                }
            }
            catch (EOFException eOFException) {
                Object var3_8 = null;
                this.fontList = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.fontList = null;
            throw throwable;
        }
    }

    private void updateFontList() {
        this.fontList = new String[this.fontTable.size()];
        int n = 0;
        Enumeration enumeration = this.fontTable.keys();
        while (enumeration.hasMoreElements()) {
            this.fontList[n] = (String)enumeration.nextElement();
            ++n;
        }
    }

    public String[] getFontList() {
        if (this.fontList == null) {
            this.updateFontList();
        }
        return this.fontList;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getFontMetrics(font, true);
    }

    FontMetrics getFontMetrics(Font font, boolean bl) {
        return ((PJAFontPeer)this.getFontPeer(font.getName(), font.getStyle(), bl)).getFontMetrics(font.getSize());
    }

    public String getDefaultFont() {
        if (this.fontList == null) {
            this.updateFontList();
        }
        if (this.fontList == null || this.fontList.length == 0) {
            return null;
        }
        int n = 0;
        while (n < this.fontList.length) {
            if (this.fontList[n].equalsIgnoreCase("SansSerif")) {
                return this.fontList[n];
            }
            if (this.fontList[n].equalsIgnoreCase("Helvetica")) {
                return this.fontList[n];
            }
            ++n;
        }
        return this.lastLoadedFont != null ? this.lastLoadedFont : this.fontList[0];
    }

    public void sync() {
    }

    public Image getImage(String string) {
        try {
            Image image = this.getImage(new URL("file:" + new File(System.getProperty("user.dir"), string)));
            return image != null ? image : this.getImage(new URL("file:" + new File(string).getAbsolutePath()));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Image getImage(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.getContentType();
            if ("image/gif".equals(uRLConnection.getContentType()) || uRL.getFile().toLowerCase().endsWith(".gif")) {
                try {
                    if (class$com$eteks$awt$image$GIFDecoder == null) {
                        class$com$eteks$awt$image$GIFDecoder = PJAGraphicsManager.class$("com.eteks.awt.image.GIFDecoder");
                    }
                    return this.createImage(new GIFDecoder(uRLConnection.getInputStream(), true));
                }
                catch (LinkageError linkageError) {
                    return this.createImage((ImageProducer)uRLConnection.getContent());
                }
            }
            return this.createImage((ImageProducer)uRLConnection.getContent());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Image createImage(String string) {
        return this.getImage(string);
    }

    public Image createImage(URL uRL) {
        return this.getImage(uRL);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof PJAImage) {
            return ((PJAImage)image).prepare(imageObserver);
        }
        throw new AWTError("PJA can't manage this image (" + image.getClass().getName() + ")");
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof PJAImage) {
            return ((PJAImage)image).check(imageObserver);
        }
        throw new AWTError("PJA can't manage this image (" + image.getClass().getName() + ")");
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        if (byArray.length >= 4 && byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 56) {
            try {
                if (class$com$eteks$awt$image$GIFDecoder == null) {
                    class$com$eteks$awt$image$GIFDecoder = PJAGraphicsManager.class$("com.eteks.awt.image.GIFDecoder");
                }
                return this.createImage(new GIFDecoder(new ByteArrayInputStream(byArray, n, n2)));
            }
            catch (LinkageError linkageError) {}
        }
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    public Image createImage(ImageProducer imageProducer) {
        return new PJAImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new PJAImage(n, n2);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string = System.getProperty("java.version", "1.0");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (Integer.parseInt(stringTokenizer.nextToken()) >= 2) {
                java2DAvailable = true;
            } else if (stringTokenizer.hasMoreTokens() && Integer.parseInt(stringTokenizer.nextToken()) >= 2) {
                java2DAvailable = true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private final class 1
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".pjaf");
        }

        /* synthetic */ 1() {
        }
    }
}

