/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uddi.datatype.service;

import com.ibm.uddi.UDDIElement;
import com.ibm.uddi.UDDIException;
import com.ibm.uddi.datatype.Description;
import com.ibm.uddi.datatype.Name;
import com.ibm.uddi.datatype.binding.BindingTemplates;
import com.ibm.uddi.util.CategoryBag;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BusinessService
extends UDDIElement {
    public static final String UDDI_TAG = "businessService";
    protected Element base = null;
    String serviceKey = null;
    String businessKey = null;
    Name name = null;
    BindingTemplates bindingTemplates = null;
    CategoryBag categoryBag = null;
    Vector description = new Vector();

    public BusinessService() {
    }

    public BusinessService(String string, String string2, BindingTemplates bindingTemplates) {
        this.serviceKey = string;
        this.name = new Name(string2);
        this.bindingTemplates = bindingTemplates;
    }

    public BusinessService(Element element) throws UDDIException {
        super(element);
        this.serviceKey = element.getAttribute("serviceKey");
        this.businessKey = element.getAttribute("businessKey");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "name");
        if (nodeList.getLength() > 0) {
            this.name = new Name((Element)nodeList.item(0));
        }
        if ((nodeList = this.getChildElementsByTagName(element, "bindingTemplates")).getLength() > 0) {
            this.bindingTemplates = new BindingTemplates((Element)nodeList.item(0));
        }
        if ((nodeList = this.getChildElementsByTagName(element, "categoryBag")).getLength() > 0) {
            this.categoryBag = new CategoryBag((Element)nodeList.item(0));
        }
        nodeList = this.getChildElementsByTagName(element, "description");
        int n = 0;
        while (n < nodeList.getLength()) {
            this.description.addElement(new Description((Element)nodeList.item(n)));
            ++n;
        }
    }

    public BindingTemplates getBindingTemplates() {
        return this.bindingTemplates;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description description = (Description)this.description.elementAt(0);
            return description.getText();
        }
        return null;
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public Name getName() {
        return this.name;
    }

    public String getNameString() {
        return this.name.getText();
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        if (this.serviceKey != null) {
            this.base.setAttribute("serviceKey", this.serviceKey);
        }
        if (this.businessKey != null) {
            this.base.setAttribute("businessKey", this.businessKey);
        }
        if (this.name != null) {
            this.name.saveToXML(this.base);
        }
        int n = 0;
        while (n < this.description.size()) {
            ((Description)this.description.elementAt(n)).saveToXML(this.base);
            ++n;
        }
        if (this.bindingTemplates != null) {
            this.bindingTemplates.saveToXML(this.base);
        }
        if (this.categoryBag != null) {
            this.categoryBag.saveToXML(this.base);
        }
        element.appendChild(this.base);
    }

    public void setBindingTemplates(BindingTemplates bindingTemplates) {
        this.bindingTemplates = bindingTemplates;
    }

    public void setBusinessKey(String string) {
        this.businessKey = string;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    public void setDefaultDescriptionString(String string) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(string), 0);
        } else {
            this.description.addElement(new Description(string));
        }
    }

    public void setDescriptionVector(Vector vector) {
        this.description = vector;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void setName(String string) {
        this.name = new Name();
        this.name.setText(string);
    }

    public void setServiceKey(String string) {
        this.serviceKey = string;
    }
}

