/*
 * The source code contained herein is licensed under the IBM Public License   
 * Version 1.0, which has been approved by the Open Source Initiative.
 * Copyright (C) 2001, International Business Machines Corporation
 * All Rights Reserved.         
 * 
 */

import com.ibm.uddi.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.client.*;
import org.w3c.dom.Element;
import java.util.Vector;
import java.util.Properties;

/**
 * Sample code that exercises the publish API. Attempts
 * to save a business named 'Sample Business'.
 * 
 * <OL>
 * <LI>Sets up a UDDIProxy object
 * <LI>Requests an authorization token
 * <LI>Saves a business named "Sample Business"
 * <LI>Lists businesses starting with S. The new
 *    business should be in the list.
 * </OL>
 */
public class SaveBusinessExample {
   public static void main (String args[]) {
      /*****************************************************************/
      /* Comment out the following lines to disable SSL and HTTPS support
       * or if using a different SSL provider.
       * JSSE must be in the classpath to use or compile these lines.
       */
      System.setProperty("java.protocol.handler.pkgs",
                         "com.sun.net.ssl.internal.www.protocol");
      java.security.Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
      /*****************************************************************/

      SaveBusinessExample app = new SaveBusinessExample();
      app.run();
      System.exit(0);
   }

   public void run() {
      // Construct a UDDIProxy object
      UDDIProxy proxy = new UDDIProxy();

      try {
         // Select the desired UDDI server node

         // The following values point to the IBM UDDI test site
         proxy.setInquiryURL("http://www-3.ibm.com/services/uddi/testregistry/inquiryapi");
         proxy.setPublishURL("https://www-3.ibm.com/services/uddi/testregistry/protect/publishapi");

         // The following values point to the IBM UDDI official site
         // proxy.setInquiryURL("http://www-3.ibm.com/services/uddi/inquiryapi");
         // proxy.setPublishURL("https://www-3.ibm.com/services/uddi/protect/publishapi");

         // The following values point to the Microsoft UDDI test site
         // proxy.setInquiryURL("http://test.uddi.microsoft.com/inquire");
         // proxy.setPublishURL("https://test.uddi.microsoft.com/publish");

         // The following values point to the Microsoft UDDI official site
         // proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
         // proxy.setPublishURL("https://uddi.microsoft.com/publish");

         // The following values for a locally installed test server
         // proxy.setInquiryURL("http://localhost:8080/services/uddi/servlet/uddi");
         // proxy.setInquiryURL("http://localhost:8080/services/uddi/servlet/uddi");
      } catch (Exception e) {
         e.printStackTrace();
      }
      try {

         // Get an authorization token
         System.out.println("\nGet authtoken");
         
         // Pass in userid and password registered at the UDDI site
         AuthToken token = proxy.get_authToken("userid",
                                               "password" );

         System.out.println("Returned authToken:" + token.getAuthInfoString());

         System.out.println("\nSave 'Sample business'");

         // Create minimum required data objects
         Vector entities = new Vector();

         // Create a new business entity using required elements constructor
         // Name is the business name. BusinessKey must be "" to save a new
         // business
         BusinessEntity be = new BusinessEntity("", "Sample Business");
         entities.addElement(be);

         // Save business
         BusinessDetail bd = proxy.save_business(token.getAuthInfoString(),entities);

         // Process returned BusinessDetail object
         Vector businessEntities = bd.getBusinessEntityVector();
         BusinessEntity returnedBusinessEntity = (BusinessEntity)(businessEntities.elementAt(0));
         System.out.println("Returned businessKey:" + returnedBusinessEntity.getBusinessKey());

         System.out.println("\nListing businesses starting with S after we publish");

         // Find businesses who's name starts with S
         BusinessList bl = proxy.find_business("S", null, 0);

         Vector businessInfoVector  = bl.getBusinessInfos().getBusinessInfoVector();
         for (int i = 0; i < businessInfoVector.size(); i++) {
            BusinessInfo businessInfo = (BusinessInfo)businessInfoVector.elementAt(i);
            System.out.println(businessInfo.getNameString());
         }

      // Handle possible errors
      } catch (UDDIException e) {
         DispositionReport dr = e.getDispositionReport();
         if (dr!=null) {
            System.out.println("UDDIException faultCode:" + e.getFaultCode() +
                               "\n operator:" + dr.getOperator() +
                               "\n generic:"  + dr.getGeneric() +
                               "\n errno:"    + dr.getErrno() +
                               "\n errCode:"  + dr.getErrCode() +
                               "\n errInfoText:" + dr.getErrInfoText());
         }
         e.printStackTrace();

      // Catch any other exception that may occur
      } catch (Exception e) {
         e.printStackTrace();
      }
   }
}
