/*
 * The source code contained herein is licensed under the IBM Public License   
 * Version 1.0, which has been approved by the Open Source Initiative.
 * Copyright (C) 2001, International Business Machines Corporation
 * All Rights Reserved.         
 * 
 */

package com.ibm.uddi;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.util.Vector;

/**
 * Base class for object representing UDDI XML
 * elements.<p>
 *
 * @author David Melgar
 */
public abstract class UDDIElement {

   public static String GENERIC = "1.0";
   public static String XMLNS = "urn:uddi-org:api";

   public UDDIElement() {
   }

   public UDDIElement(Element el) throws UDDIException {
      // Check that if an exception should be thrown
      if (UDDIException.isValidElement(el)) {
         // Looks like a fault, process and throw
         throw new UDDIException(el, true);
      }
   }

   abstract public void saveToXML(Element base);

   /**
    * Utility function
    * Returns text contained in child elements of the
    * passed in element
    * 
    * @param el     Element
    * @return 
    */
   protected String getText(Node el) {
      NodeList nl = el.getChildNodes();
      String result = "";
      for (int i = 0; i < nl.getLength(); i++) {
         if (nl.item(i).getNodeType()==Element.TEXT_NODE) {
            result += nl.item(i).getNodeValue();
         }
      }
      // Trim result to remove whitespace
      return result.trim();
   }

   public NodeList getChildElementsByTagName(Element el, String tag) {
       // Do NOT traverse the tree. Only search in the within immediate
       // child nodes
       NodeList children = el.getChildNodes();
       Vector result = new Vector();
       for (int i = 0; i < children.getLength(); i++) {
           Node node = children.item(i);
           if (node.getNodeType() == node.ELEMENT_NODE &&
               node.getNodeName().equals(tag)) {
               // This is a valid node
               result.addElement(node);
           }
       }
       return new VectorNodeList(result);
   }

   protected Element base = null;

}
