/*
 * The source code contained herein is licensed under the IBM Public License   
 * Version 1.0, which has been approved by the Open Source Initiative.
 * Copyright (C) 2001, International Business Machines Corporation
 * All Rights Reserved.         
 * 
 */

package com.ibm.uddi.response;
import java.util.Vector;
import org.w3c.dom.*;
import com.ibm.uddi.*;
import com.ibm.uddi.datatype.*;
import com.ibm.uddi.datatype.binding.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.datatype.service.*;
import com.ibm.uddi.datatype.tmodel.*;
import com.ibm.uddi.request.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.util.*;

/**
 * <p><b>General information:</b><p>
 *
 * This class represents an element within the UDDI version 1.0 schema.
 * This class contains the following types of methods:<ul>
 *
 *   <li>Constructor passing required fields.
 *   <li>Constructor that will instantiate the object from an XML DOM element
 *       that is the appropriate element for this object.
 *   <li>Get/set methods for each attribute that this element can contain.
 *   <li>For sets of attributes, a get/setVector method is provided.
 *   <li>SaveToXML method. Serialized this class within a passed in element.
 *
 * </ul>
 * Typically this class is used to construct parameters for, or interpret
 * responses from methods in the UDDIProxy class.
 * 
 * <p><b>Element description:</b><p>
 * This structure is the container for safely extending the businessEntity
 * information in private implementations of UDDI compatible registries.
 * Official operator nodes may not provide extended data but must return
 * a properly populated businessEntity structure within this structure in
 * response to a get_businessDetailExt message.
 * 
 * <p>
 *
 * @author David Melgar
 */
public class BusinessEntityExt extends UDDIElement {
   public static final String UDDI_TAG = "businessEntityExt";

   protected Element base = null;

   BusinessEntity businessEntity = null;

   /**
    * Default constructor.
    * Use of this constructor should be avoided. Use the required fields
    * constructor to provide validation. No validation of required
    * fields is performed when using the default constructor.
    *
    */
   public BusinessEntityExt() {
   }

   /**
    * Construct the object with required fields.
    *
    * @param BusinessEntity	BusinessEntity object
    */
   public BusinessEntityExt(BusinessEntity businessEntity) {
      this.businessEntity = businessEntity;
   }

   /**
    * Construct the object from a DOM tree. Used by 
    * UDDIProxy to construct object from received UDDI
    * message.
    * 
    * @param base   Element with name appropriate for this class.
    * @exception UDDIException
    *                   Thrown if DOM tree contains a SOAP fault or
    *                   disposition report indicating a UDDI error.
    */
   public BusinessEntityExt(Element base) throws UDDIException {
      // Check if its a fault. Throw exception if it is
      super(base);
      NodeList nl = null;
      nl = getChildElementsByTagName(base, BusinessEntity.UDDI_TAG);
      if (nl.getLength() > 0) {
         businessEntity = new BusinessEntity((Element)nl.item(0));
      }
   }

   public void setBusinessEntity(BusinessEntity s) {
      businessEntity = s;
   }

   public BusinessEntity getBusinessEntity() {
      return businessEntity;
   }


   /**
    * Save object to DOM tree. Used to serialize object
    * to a DOM tree, typically to send a UDDI message.
    * 
    * <BR>Used by UDDIProxy.
    * 
    * @param parent Object will serialize as a child element under the
    *               passed in parent element.
    */
   public void saveToXML(Element parent) {
      base = parent.getOwnerDocument().createElement(UDDI_TAG);
      // Save attributes
      if (businessEntity!=null) {
         businessEntity.saveToXML(base);
      }
      parent.appendChild(base);
   }
}
