/*
 * The source code contained herein is licensed under the IBM Public License   
 * Version 1.0, which has been approved by the Open Source Initiative.
 * Copyright (C) 2001, International Business Machines Corporation
 * All Rights Reserved.         
 * 
 */

package com.ibm.uddi.response;
import java.util.Vector;
import org.w3c.dom.*;
import com.ibm.uddi.*;
import com.ibm.uddi.datatype.*;
import com.ibm.uddi.datatype.binding.*;
import com.ibm.uddi.datatype.business.*;
import com.ibm.uddi.datatype.service.*;
import com.ibm.uddi.datatype.tmodel.*;
import com.ibm.uddi.request.*;
import com.ibm.uddi.response.*;
import com.ibm.uddi.util.*;

/**
 * <p><b>General information:</b><p>
 *
 * This class represents an element within the UDDI version 1.0 schema.
 * This class contains the following types of methods:<ul>
 *
 *   <li>Constructor passing required fields.
 *   <li>Constructor that will instantiate the object from an XML DOM element
 *       that is the appropriate element for this object.
 *   <li>Get/set methods for each attribute that this element can contain.
 *   <li>For sets of attributes, a get/setVector method is provided.
 *   <li>SaveToXML method. Serialized this class within a passed in element.
 *
 * </ul>
 * Typically this class is used to construct parameters for, or interpret
 * responses from methods in the UDDIProxy class.
 * 
 * <p><b>Element description:</b><p>
 * Supports the DispositionReport structure.
 * This structure is provided for conveying text and structured
 * error code (alphanumeric) information.  Error message text
 * is contained by this element.
 * 
 * <p>
 *
 * @author David Melgar
 */
public class ErrInfo extends UDDIElement {
   public static final String UDDI_TAG = "errInfo";

   protected Element base = null;

   String text = null;
   String errCode = null;

   /**
    * Default constructor.
    * Use of this constructor should be avoided. Use the required fields
    * constructor to provide validation. No validation of required
    * fields is performed when using the default constructor.
    *
    */
   public ErrInfo() {
   }

   /**
    * Construct the object with required fields.
    *
    * @param value	String value
    * @param errCode	String
    */
   public ErrInfo(String value,
			String errCode) {
      setText(value);
      this.errCode = errCode;
   }

   /**
    * Construct the object from a DOM tree. Used by 
    * UDDIProxy to construct object from received UDDI
    * message.
    * 
    * @param base   Element with name appropriate for this class.
    * @exception UDDIException
    *                   Thrown if DOM tree contains a SOAP fault or
    *                   disposition report indicating a UDDI error.
    */
   public ErrInfo(Element base) throws UDDIException {
      // Check if its a fault. Throw exception if it is
      super(base);
      text = getText(base);
      errCode = base.getAttribute("errCode");
   }

   public void setText(String s) {
      text = s;
   }

   public void setErrCode(String s) {
      errCode = s;
   }

   public String getText() {
      return text;
   }

   public String getErrCode() {
      return errCode;
   }


   /**
    * Save object to DOM tree. Used to serialize object
    * to a DOM tree, typically to send a UDDI message.
    * 
    * <BR>Used by UDDIProxy.
    * 
    * @param parent Object will serialize as a child element under the
    *               passed in parent element.
    */
   public void saveToXML(Element parent) {
      base = parent.getOwnerDocument().createElement(UDDI_TAG);
      // Save attributes
      if (text!=null) {
         base.appendChild(parent.getOwnerDocument().createTextNode(text));
      }
      if (errCode!=null) {
         base.setAttribute("errCode", errCode);
      }
      parent.appendChild(base);
   }
}
